/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateWithExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StringBasedPostfixTemplate
extends PostfixTemplateWithExpressionSelector {
    public StringBasedPostfixTemplate(@NotNull String name, @NotNull String example, @NotNull PostfixTemplateExpressionSelector selector2) {
        super(name, example, selector2);
    }

    @Override
    public final void expandForChooseExpression(@NotNull PsiElement expr, @NotNull Editor editor) {
        Project project2 = expr.getProject();
        Document document = editor.getDocument();
        PsiElement elementForRemoving = this.getElementToRemove(expr);
        document.deleteString(elementForRemoving.getTextRange().getStartOffset(), elementForRemoving.getTextRange().getEndOffset());
        TemplateManager manager = TemplateManager.getInstance(project2);
        String templateString = this.getTemplateString(expr);
        if (templateString == null) {
            PostfixTemplatesUtils.showErrorHint(expr.getProject(), editor);
            return;
        }
        Template template = this.createTemplate(manager, templateString);
        if (this.shouldAddExpressionToContext()) {
            template.addVariable("expr", (Expression)new TextExpression(expr.getText()), false);
        }
        this.setVariables(template, expr);
        manager.startTemplate(editor, template);
    }

    public Template createTemplate(TemplateManager manager, String templateString) {
        Template template = manager.createTemplate("", "", templateString);
        template.setToReformat(this.shouldReformat());
        return template;
    }

    public void setVariables(@NotNull Template template, @NotNull PsiElement element) {
    }

    @Nullable
    public abstract String getTemplateString(@NotNull PsiElement var1);

    protected boolean shouldAddExpressionToContext() {
        return true;
    }

    protected boolean shouldReformat() {
        return true;
    }

    protected boolean shouldRemoveParent() {
        return true;
    }

    protected PsiElement getElementToRemove(PsiElement expr) {
        if (this.shouldRemoveParent()) {
            return expr.getParent();
        }
        return expr;
    }
}

