/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatePsiInfo;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateWithExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public abstract class SurroundPostfixTemplateBase
extends PostfixTemplateWithExpressionSelector {
    @NotNull
    protected final PostfixTemplatePsiInfo myPsiInfo;

    protected SurroundPostfixTemplateBase(@NotNull String name, @NotNull String descr, @NotNull PostfixTemplatePsiInfo psiInfo, @NotNull PostfixTemplateExpressionSelector selector2) {
        super(name, descr, selector2);
        this.myPsiInfo = psiInfo;
    }

    @Override
    public final void expandForChooseExpression(@NotNull PsiElement context, @NotNull Editor editor) {
        PsiElement replace = this.getReplacedExpression(context);
        TextRange range = PostfixTemplatesUtils.surround(this.getSurrounder(), editor, replace);
        if (range != null) {
            editor.getCaretModel().moveToOffset(range.getStartOffset());
        }
    }

    protected PsiElement getReplacedExpression(PsiElement topmostExpression) {
        PsiElement expression2 = this.getWrappedExpression(topmostExpression);
        assert (topmostExpression != null);
        return topmostExpression.replace(expression2);
    }

    protected PsiElement getWrappedExpression(PsiElement expression2) {
        if (StringUtil.isEmpty((String)this.getHead()) && StringUtil.isEmpty((String)this.getTail())) {
            return expression2;
        }
        return this.createNew(expression2);
    }

    protected PsiElement createNew(PsiElement expression2) {
        return this.myPsiInfo.createExpression(expression2, this.getHead(), this.getTail());
    }

    @NotNull
    protected String getHead() {
        return "";
    }

    @NotNull
    protected String getTail() {
        return "";
    }

    @NotNull
    protected abstract Surrounder getSurrounder();
}

