/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.generation.surroundWith.JavaWithTryCatchSurrounder;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class TryStatementPostfixTemplate
extends PostfixTemplate {
    protected TryStatementPostfixTemplate() {
        super("try", "try { exp } catch(Exception e)");
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        PsiStatement statementParent = (PsiStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiStatement.class});
        if (statementParent == null || newOffset != statementParent.getTextRange().getEndOffset()) {
            return false;
        }
        if (statementParent instanceof PsiDeclarationStatement) {
            return true;
        }
        if (statementParent instanceof PsiExpressionStatement) {
            PsiExpression expression2 = ((PsiExpressionStatement)statementParent).getExpression();
            return null != expression2.getType();
        }
        return false;
    }

    @Override
    public void expand(@NotNull PsiElement context, @NotNull Editor editor) {
        PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiStatement.class});
        assert (statement2 != null);
        PsiFile file2 = statement2.getContainingFile();
        JavaWithTryCatchSurrounder surrounder = new JavaWithTryCatchSurrounder();
        Project project2 = context.getProject();
        TextRange range = surrounder.surroundElements(project2, editor, new PsiElement[]{statement2});
        if (range == null) {
            PostfixTemplatesUtils.showErrorHint(project2, editor);
            return;
        }
        PsiElement element = file2.findElementAt(range.getStartOffset());
        PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTryStatement.class);
        assert (tryStatement != null);
        PsiCodeBlock block = tryStatement.getTryBlock();
        assert (block != null);
        PsiStatement statementInTry = (PsiStatement)ArrayUtil.getFirstElement((Object[])block.getStatements());
        if (null != statementInTry) {
            editor.getCaretModel().moveToOffset(statementInTry.getTextRange().getEndOffset());
        }
    }
}

