/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPolyadicExpressionUnwrapper
extends JavaUnwrapper {
    public JavaPolyadicExpressionUnwrapper() {
        super("");
    }

    @Override
    public String getDescription(PsiElement e) {
        return CodeInsightBundle.message((String)"unwrap.with.placeholder", (Object[])new Object[]{e.getText()});
    }

    @Override
    public boolean isApplicableTo(PsiElement e) {
        if (!(e.getParent() instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)e.getParent();
        PsiExpression operand2 = JavaPolyadicExpressionUnwrapper.findOperand(e, expression2);
        return operand2 != null;
    }

    @Override
    protected void doUnwrap(PsiElement element, JavaUnwrapper.Context context) throws IncorrectOperationException {
        PsiPolyadicExpression parent = (PsiPolyadicExpression)element.getParent();
        PsiExpression operand2 = JavaPolyadicExpressionUnwrapper.findOperand(element, parent);
        if (operand2 == null) {
            return;
        }
        context.extractElement((PsiElement)operand2, (PsiElement)parent);
        context.delete((PsiElement)parent);
    }

    @Nullable
    private static PsiExpression findOperand(@NotNull PsiElement e, @NotNull PsiPolyadicExpression expression2) {
        TextRange elementTextRange = e.getTextRange();
        for (PsiExpression operand2 : expression2.getOperands()) {
            TextRange operandTextRange = operand2.getTextRange();
            if (operandTextRange == null || !operandTextRange.contains(elementTextRange)) continue;
            return operand2;
        }
        return null;
    }
}

