/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.unwrap.LanguageUnwrappers;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.codeInsight.unwrap.UnwrapDescriptor;
import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class UnwrapHandler
implements CodeInsightActionHandler {
    public static final int HIGHLIGHTER_LEVEL = 6001;

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        List<AnAction> options = UnwrapHandler.collectOptions(project2, editor, file2);
        this.selectOption(options, editor, file2);
    }

    private static List<AnAction> collectOptions(Project project2, Editor editor, PsiFile file2) {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        UnwrapDescriptor d = UnwrapHandler.getUnwrapDescription(file2);
        for (Pair<PsiElement, Unwrapper> each : d.collectUnwrappers(project2, editor, file2)) {
            result2.add(UnwrapHandler.createUnwrapAction((Unwrapper)each.getSecond(), (PsiElement)each.getFirst(), editor, project2));
        }
        return result2;
    }

    private static UnwrapDescriptor getUnwrapDescription(PsiFile file2) {
        return (UnwrapDescriptor)LanguageUnwrappers.INSTANCE.forLanguage(file2.getLanguage());
    }

    private static AnAction createUnwrapAction(Unwrapper u, PsiElement el, Editor ed, Project p) {
        return new MyUnwrapAction(p, ed, u, el);
    }

    protected void selectOption(List<AnAction> options, Editor editor, PsiFile file2) {
        if (options.isEmpty()) {
            return;
        }
        if (!UnwrapHandler.getUnwrapDescription(file2).showOptionsDialog() || ApplicationManager.getApplication().isUnitTestMode()) {
            options.get(0).actionPerformed(null);
            return;
        }
        UnwrapHandler.showPopup(options, editor);
    }

    private static void showPopup(List<AnAction> options, Editor editor) {
        final ScopeHighlighter highlighter = new ScopeHighlighter(editor);
        DefaultListModel<String> m = new DefaultListModel<String>();
        for (AnAction a : options) {
            m.addElement(((MyUnwrapAction)a).getName());
        }
        JBList list = new JBList(m);
        list.setSelectionMode(0);
        list.setVisibleRowCount(options.size());
        list.addListSelectionListener(new ListSelectionListener((JList)list, options, highlighter){
            final /* synthetic */ JList val$list;
            final /* synthetic */ List val$options;
            final /* synthetic */ ScopeHighlighter val$highlighter;
            {
                this.val$list = jList;
                this.val$options = list;
                this.val$highlighter = scopeHighlighter;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = this.val$list.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                MyUnwrapAction a = (MyUnwrapAction)((Object)this.val$options.get(index));
                ArrayList<PsiElement> toExtract = new ArrayList<PsiElement>();
                PsiElement wholeRange = a.collectAffectedElements(toExtract);
                this.val$highlighter.highlight(wholeRange, toExtract);
            }
        });
        PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder((JList)list);
        builder.setTitle(CodeInsightBundle.message((String)"unwrap.popup.title", (Object[])new Object[0])).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> UnwrapHandler.lambda$showPopup$0(options, (JList)list)).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                highlighter.dropHighlight();
            }
        });
        JBPopup popup = builder.createPopup();
        popup.showInBestPositionFor(editor);
    }

    public static TextAttributes getTestAttributesForExtract() {
        EditorColorsManager manager = EditorColorsManager.getInstance();
        return manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
    }

    private static /* synthetic */ void lambda$showPopup$0(List options, JList list) {
        MyUnwrapAction a = (MyUnwrapAction)((Object)options.get(list.getSelectedIndex()));
        a.actionPerformed(null);
    }

    private static class MyUnwrapAction
    extends AnAction {
        private static final Key<Integer> CARET_POS_KEY = new Key("UNWRAP_HANDLER_CARET_POSITION");
        private final Project myProject;
        private final Editor myEditor;
        private final Unwrapper myUnwrapper;
        private final PsiElement myElement;

        public MyUnwrapAction(Project project2, Editor editor, Unwrapper unwrapper, PsiElement element) {
            super(unwrapper.getDescription(element));
            this.myProject = project2;
            this.myEditor = editor;
            this.myUnwrapper = unwrapper;
            this.myElement = element;
        }

        public void actionPerformed(AnActionEvent e) {
            PsiFile file2 = this.myElement.getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    UnwrapDescriptor d = UnwrapHandler.getUnwrapDescription(file2);
                    if (d.shouldTryToRestoreCaretPosition()) {
                        this.saveCaretPosition(file2);
                    }
                    int scrollOffset = this.myEditor.getScrollingModel().getVerticalScrollOffset();
                    List<PsiElement> extractedElements = this.myUnwrapper.unwrap(this.myEditor, this.myElement);
                    if (d.shouldTryToRestoreCaretPosition()) {
                        this.restoreCaretPosition(file2);
                    }
                    this.myEditor.getScrollingModel().scrollVertically(scrollOffset);
                    this.highlightExtractedElements(extractedElements);
                }
                catch (IncorrectOperationException ex) {
                    throw new RuntimeException(ex);
                }
            }), null, (Object)this.myEditor.getDocument());
        }

        private void saveCaretPosition(PsiFile file2) {
            int offset = this.myEditor.getCaretModel().getOffset();
            PsiElement el = file2.findElementAt(offset);
            if (el == null) {
                return;
            }
            int innerOffset = offset - el.getTextOffset();
            el.putCopyableUserData(CARET_POS_KEY, (Object)innerOffset);
        }

        private void restoreCaretPosition(PsiFile file2) {
            ((TreeElement)file2.getNode()).acceptTree(new RecursiveTreeElementWalkingVisitor(){

                @Override
                protected void visitNode(TreeElement element) {
                    PsiElement el = element.getPsi();
                    Integer offset = (Integer)el.getCopyableUserData(CARET_POS_KEY);
                    if (offset != null) {
                        myEditor.getCaretModel().moveToOffset(el.getTextOffset() + offset);
                        el.putCopyableUserData(CARET_POS_KEY, null);
                        return;
                    }
                    super.visitNode(element);
                }
            });
        }

        private void highlightExtractedElements(List<PsiElement> extractedElements) {
            for (PsiElement each : extractedElements) {
                TextRange textRange = each.getTextRange();
                HighlightManager.getInstance((Project)this.myProject).addRangeHighlight(this.myEditor, textRange.getStartOffset(), textRange.getEndOffset(), UnwrapHandler.getTestAttributesForExtract(), false, true, null);
            }
        }

        public String getName() {
            return this.myUnwrapper.getDescription(this.myElement);
        }

        public PsiElement collectAffectedElements(List<PsiElement> toExtract) {
            return this.myUnwrapper.collectAffectedElements(this.myElement, toExtract);
        }
    }
}

