/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.UnwrapHandler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class UnwrapTestCase
extends LightPlatformCodeInsightTestCase {
    protected void assertUnwrapped(String codeBefore, String expectedCodeAfter) throws Exception {
        this.assertUnwrapped(codeBefore, expectedCodeAfter, 0);
    }

    protected void assertUnwrapped(String codeBefore, String expectedCodeAfter, final int option) throws Exception {
        this.configureCode(codeBefore);
        UnwrapHandler h = new UnwrapHandler(){

            @Override
            protected void selectOption(List<AnAction> options, Editor editor, PsiFile file2) {
                if (options.isEmpty()) {
                    return;
                }
                options.get(option).actionPerformed(null);
            }
        };
        h.invoke(UnwrapTestCase.getProject(), UnwrapTestCase.getEditor(), UnwrapTestCase.getFile());
        this.checkResultByText(this.createCode(expectedCodeAfter));
    }

    protected void assertOptions(String code2, String ... expectedOptions) throws IOException {
        this.configureCode(code2);
        final ArrayList actualOptions = new ArrayList();
        UnwrapHandler h = new UnwrapHandler(){

            @Override
            protected void selectOption(List<AnAction> options, Editor editor, PsiFile file2) {
                for (AnAction each : options) {
                    actualOptions.add(each.getTemplatePresentation().getText());
                }
            }
        };
        h.invoke(UnwrapTestCase.getProject(), UnwrapTestCase.getEditor(), UnwrapTestCase.getFile());
        UnwrapTestCase.assertEquals(Arrays.asList(expectedOptions), actualOptions);
    }

    protected void configureCode(String codeBefore) throws IOException {
        UnwrapTestCase.configureFromFileText(this.getFileNameToCreate(), this.createCode(codeBefore));
    }

    protected String getFileNameToCreate() {
        return "A.java";
    }

    protected String createCode(String codeBefore) {
        return "public class A {\n    void foo() {\n" + this.indentTwice(codeBefore) + "    }\n}";
    }

    protected String indentTwice(String code2) {
        return this.indent(this.indent(code2));
    }

    protected String indent(String code2) {
        String result2 = "";
        for (String line : StringUtil.tokenize((String)code2, (String)"\n")) {
            result2 = result2 + "    " + line + "\n";
        }
        return result2;
    }
}

