/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotateMethodFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.AnnotateMethodFix");
    protected final String myAnnotation;
    private final String[] myAnnotationsToRemove;

    public AnnotateMethodFix(@NotNull String fqn, String ... annotationsToRemove) {
        this.myAnnotation = fqn;
        this.myAnnotationsToRemove = annotationsToRemove;
    }

    @NotNull
    public String getName() {
        return InspectionsBundle.message((String)"inspection.annotate.method.quickfix.name", (Object[])new Object[]{ClassUtil.extractClassName((String)this.myAnnotation)});
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement = descriptor.getPsiElement();
        PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class);
        if (method2 == null) {
            return;
        }
        ArrayList<PsiMethod> toAnnotate = new ArrayList<PsiMethod>();
        toAnnotate.add(method2);
        List superMethodSignatures = method2.findSuperMethodSignaturesIncludingStatic(true);
        for (PsiMethod[] superMethodSignature : superMethodSignatures) {
            PsiMethod superMethod = superMethodSignature.getMethod();
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)superMethod, (String)this.myAnnotation, (boolean)false, (boolean)false) || !superMethod.getManager().isInProject((PsiElement)superMethod)) continue;
            int ret = this.shouldAnnotateBaseMethod(method2, superMethod, project2);
            if (ret != 0 && ret != 1) {
                return;
            }
            if (ret != 0) continue;
            toAnnotate.add(superMethod);
        }
        if (this.annotateOverriddenMethods()) {
            PsiMethod[] methods;
            for (PsiMethod psiMethod : methods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method2).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
                if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)psiMethod, (String)this.myAnnotation) || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)this.myAnnotation, (boolean)false, (boolean)false) || !psiMethod.getManager().isInProject((PsiElement)psiMethod)) continue;
                toAnnotate.add(psiMethod);
            }
        }
        FileModificationService.getInstance().preparePsiElementsForWrite(toAnnotate);
        for (PsiMethod psiMethod : toAnnotate) {
            this.annotateMethod(psiMethod);
        }
        UndoUtil.markPsiFileForUndo((PsiFile)method2.getContainingFile());
    }

    public int shouldAnnotateBaseMethod(PsiMethod method2, PsiMethod superMethod, Project project2) {
        return 0;
    }

    protected boolean annotateOverriddenMethods() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return InspectionsBundle.message((String)"inspection.annotate.method.quickfix.family.name", (Object[])new Object[0]);
    }

    private void annotateMethod(@NotNull PsiMethod method2) {
        AddAnnotationPsiFix fix = new AddAnnotationPsiFix(this.myAnnotation, (PsiModifierListOwner)method2, PsiNameValuePair.EMPTY_ARRAY, this.myAnnotationsToRemove);
        fix.invoke(method2.getProject(), method2.getContainingFile(), (PsiElement)method2, (PsiElement)method2);
    }
}

