/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.performance.CollectionsListSettings;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionAddAllCanBeReplacedWithConstructorInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(CollectionAddAllCanBeReplacedWithConstructorInspection.class);
    private final CollectionsListSettings mySettings = new CollectionsListSettings(){

        @Override
        protected Collection<String> getDefaultSettings() {
            return DEFAULT_COLLECTION_LIST;
        }
    };

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.mySettings.writeSettings(node);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return this.mySettings.createOptionsPanel();
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        this.mySettings.readSettings(node);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        return new JavaElementVisitor(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                String methodName = expression2.getMethodExpression().getReferenceName();
                if (!"addAll".equals(methodName) && !"putAll".equals(methodName)) return;
                if (expression2.getArgumentList().getExpressions().length != 1) {
                    return;
                }
                PsiExpression qualifierExpression2 = expression2.getMethodExpression().getQualifierExpression();
                if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiElement parent = expression2.getParent();
                if (!(parent instanceof PsiExpressionStatement)) {
                    return;
                }
                PsiElement resolvedReference = ((PsiReferenceExpression)qualifierExpression2).resolve();
                if (!(resolvedReference instanceof PsiLocalVariable)) {
                    return;
                }
                PsiLocalVariable variable = (PsiLocalVariable)resolvedReference;
                PsiType variableType = variable.getType();
                if (!(variableType instanceof PsiClassType) || CollectionAddAllCanBeReplacedWithConstructorInspection.statementHasSubsequentAddAll(parent, variable, methodName)) {
                    return;
                }
                PsiClass variableClass = ((PsiClassType)variableType).resolve();
                if (variableClass == null) {
                    return;
                }
                Pair pair = CollectionAddAllCanBeReplacedWithConstructorInspection.this.isProperAssignmentStatementFound(variable, expression2);
                if (!((Boolean)pair.getFirst()).booleanValue()) return;
                PsiNewExpression assignmentExpression = (PsiNewExpression)pair.getSecond();
                if (assignmentExpression == null) {
                    if (!CollectionAddAllCanBeReplacedWithConstructorInspection.this.checkLocalVariableAssignmentOrInitializer(variable.getInitializer())) return;
                    assignmentExpression = (PsiNewExpression)variable.getInitializer();
                }
                if (!CollectionAddAllCanBeReplacedWithConstructorInspection.isAddAllReplaceable((PsiExpression)expression2, assignmentExpression) || !CollectionAddAllCanBeReplacedWithConstructorInspection.checkUsages(variable, expression2, assignmentExpression)) {
                    return;
                }
                PsiMethod method2 = expression2.resolveMethod();
                if (method2 == null) return;
                holder.registerProblem((PsiElement)expression2, QuickFixBundle.message("collection.addall.can.be.replaced.with.constructor.fix.description", methodName), new LocalQuickFix[]{new ReplaceAddAllWithConstructorFix(assignmentExpression, expression2)});
            }
        };
    }

    private static boolean statementHasSubsequentAddAll(@NotNull PsiElement statement2, @NotNull PsiLocalVariable referent, @NotNull String previousMethodName) {
        PsiMethod method2;
        PsiMethodCallExpression siblingMethodCall;
        PsiExpression qualifier;
        PsiExpression siblingExpression;
        PsiElement sibling = PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, PsiStatement.class);
        return sibling instanceof PsiExpressionStatement && (siblingExpression = ((PsiExpressionStatement)sibling).getExpression()) instanceof PsiMethodCallExpression && (qualifier = (siblingMethodCall = (PsiMethodCallExpression)siblingExpression).getMethodExpression().getQualifierExpression()) instanceof PsiReferenceExpression && referent.isEquivalentTo(((PsiReferenceExpression)qualifier).resolve()) && (method2 = siblingMethodCall.resolveMethod()) != null && method2.getName().equals(previousMethodName);
    }

    private boolean checkLocalVariableAssignmentOrInitializer(PsiExpression initializer) {
        if (!(initializer instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)initializer;
        PsiJavaCodeReferenceElement classReference2 = newExpression.getClassReference();
        if (classReference2 == null) {
            return false;
        }
        PsiClass initializerClass = (PsiClass)classReference2.resolve();
        if (initializerClass == null || !this.mySettings.getCollectionClassesRequiringCapacity().contains(initializerClass.getQualifiedName()) || !this.hasProperConstructor(initializerClass)) {
            return false;
        }
        PsiExpressionList argumentList = newExpression.getArgumentList();
        return argumentList != null && argumentList.getExpressions().length == 0;
    }

    private boolean hasProperConstructor(PsiClass psiClass) {
        for (PsiMethod psiMethod : psiClass.getConstructors()) {
            PsiType type2;
            PsiParameter parameter;
            PsiTypeElement typeElement;
            PsiParameterList parameterList = psiMethod.getParameterList();
            if (parameterList.getParametersCount() != 1 || (typeElement = (parameter = parameterList.getParameters()[0]).getTypeElement()) == null || !InheritanceUtil.isInheritor((PsiType)(type2 = typeElement.getType()), (String)"java.util.Collection") && !InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Map")) continue;
            return true;
        }
        return false;
    }

    private Pair<Boolean, PsiNewExpression> isProperAssignmentStatementFound(PsiLocalVariable localVariable, PsiMethodCallExpression addAllExpression) {
        PsiStatement currentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)addAllExpression, PsiStatement.class);
        PsiStatement localVariableDefinitionStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)localVariable, PsiStatement.class);
        while (currentStatement != null) {
            if ((currentStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)currentStatement, PsiStatement.class)) == localVariableDefinitionStatement) {
                return Pair.create((Object)true, null);
            }
            for (PsiAssignmentExpression expression2 : PsiTreeUtil.findChildrenOfType((PsiElement)currentStatement, PsiAssignmentExpression.class)) {
                if (!ExpressionUtils.isReferenceTo(expression2.getLExpression(), (PsiVariable)localVariable)) continue;
                PsiExpression rExpression = expression2.getRExpression();
                boolean isValid = this.checkLocalVariableAssignmentOrInitializer(rExpression);
                return Pair.create((Object)isValid, (Object)(isValid ? (PsiNewExpression)rExpression : null));
            }
        }
        return Pair.create((Object)true, null);
    }

    private static boolean isAddAllReplaceable(PsiExpression addAllExpression, PsiNewExpression newExpression) {
        final boolean[] isReplaceable = new boolean[]{true};
        final PsiFile newExpressionContainingFile = newExpression.getContainingFile();
        final TextRange newExpressionTextRange = newExpression.getTextRange();
        addAllExpression.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                PsiVariable variable;
                LocalSearchScope useScope;
                PsiElement resolved = expression2.resolve();
                if ((resolved instanceof PsiLocalVariable || resolved instanceof PsiParameter) && !(useScope = (LocalSearchScope)(variable = (PsiVariable)resolved).getUseScope()).containsRange(newExpressionContainingFile, newExpressionTextRange)) {
                    isReplaceable[0] = false;
                }
            }
        });
        return isReplaceable[0];
    }

    private static List<PsiElement> extractReferencedElementsFromParameter(PsiMethodCallExpression expression2) {
        PsiExpression psiExpression = expression2.getArgumentList().getExpressions()[0];
        ArrayList<PsiReferenceExpression> references = new ArrayList<PsiReferenceExpression>(PsiTreeUtil.findChildrenOfType((PsiElement)psiExpression, PsiReferenceExpression.class));
        if (psiExpression instanceof PsiReferenceExpression) {
            references.add((PsiReferenceExpression)psiExpression);
        }
        return ContainerUtil.mapNotNull(references, (Function)((NullableFunction)expression1 -> expression1.resolve()));
    }

    private static boolean isReferenceToOneOf(PsiReferenceExpression reference, List<PsiElement> elements) {
        for (PsiElement element : elements) {
            if (!reference.isReferenceTo(element)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkUsages(PsiLocalVariable variable, PsiMethodCallExpression methodCallExpression, PsiNewExpression variableAssignmentExpression) {
        PsiCodeBlock variableAssignmentBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variableAssignmentExpression, PsiCodeBlock.class);
        PsiCodeBlock methodCallBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiCodeBlock.class);
        if (variableAssignmentBlock == null || variableAssignmentBlock != methodCallBlock) {
            return false;
        }
        PsiStatement variableDeclarationStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)variableAssignmentExpression, PsiStatement.class);
        PsiStatement methodCallStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiStatement.class);
        if (variableDeclarationStatement == null || methodCallStatement == null || variableDeclarationStatement.getParent() != methodCallStatement.getParent()) {
            return false;
        }
        PsiStatement nextStatement = variableDeclarationStatement;
        List<PsiElement> referencedElementsFromParameter = CollectionAddAllCanBeReplacedWithConstructorInspection.extractReferencedElementsFromParameter(methodCallExpression);
        while (nextStatement != null) {
            if ((nextStatement = PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class)) == methodCallStatement) {
                return true;
            }
            for (PsiReferenceExpression referenceExpression : PsiTreeUtil.findChildrenOfType((PsiElement)nextStatement, PsiReferenceExpression.class)) {
                if (!referenceExpression.isReferenceTo((PsiElement)variable) && !CollectionAddAllCanBeReplacedWithConstructorInspection.isReferenceToOneOf(referenceExpression, referencedElementsFromParameter)) continue;
                return false;
            }
            for (PsiLocalVariable localVariable : PsiTreeUtil.findChildrenOfType((PsiElement)nextStatement, PsiLocalVariable.class)) {
                if (!referencedElementsFromParameter.contains(localVariable)) continue;
                return false;
            }
        }
        return false;
    }

    private static class ReplaceAddAllWithConstructorFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer<PsiMethodCallExpression> myMethodCallExpression;
        private final SmartPsiElementPointer<PsiNewExpression> myAssignmentExpression;

        private ReplaceAddAllWithConstructorFix(PsiNewExpression assignmentExpression, PsiMethodCallExpression expression2) {
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)assignmentExpression.getProject());
            this.myMethodCallExpression = smartPointerManager.createSmartPsiElementPointer((PsiElement)expression2);
            this.myAssignmentExpression = smartPointerManager.createSmartPsiElementPointer((PsiElement)assignmentExpression);
        }

        @NotNull
        public String getFamilyName() {
            return QuickFixBundle.message("collection.addall.can.be.replaced.with.constructor.fix.title", new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)this.myMethodCallExpression.getElement();
            if (methodCallExpression == null) {
                return;
            }
            PsiElement parameter = methodCallExpression.getArgumentList().getExpressions()[0].copy();
            PsiNewExpression element = (PsiNewExpression)this.myAssignmentExpression.getElement();
            if (element == null) {
                return;
            }
            PsiExpressionList constructorArguments = element.getArgumentList();
            if (constructorArguments == null) {
                return;
            }
            constructorArguments.add(parameter);
            methodCallExpression.delete();
        }
    }
}

