/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Collection;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparatorCombinatorsInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)("#" + ComparatorCombinatorsInspection.class.getName()));

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                PsiBinaryExpression binOp;
                super.visitLambdaExpression(lambda2);
                PsiType type2 = lambda2.getFunctionalInterfaceType();
                PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
                if (parameters2.length != 2 || !(type2 instanceof PsiClassType) || !((PsiClassType)type2).rawType().equalsToText("java.util.Comparator")) {
                    return;
                }
                PsiExpression body2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
                String methodName = null;
                if (body2 instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression methodCall = (PsiMethodCallExpression)body2;
                    PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                    if (args.length == 1 && MethodCallUtils.isCompareToCall(methodCall)) {
                        PsiExpression left = methodCall.getMethodExpression().getQualifierExpression();
                        if (left == null) {
                            return;
                        }
                        PsiExpression right = args[0];
                        if (left instanceof PsiReferenceExpression && right instanceof PsiReferenceExpression) {
                            PsiElement leftElement = ((PsiReferenceExpression)left).resolve();
                            PsiElement rightElement = ((PsiReferenceExpression)right).resolve();
                            if (leftElement == parameters2[0] && rightElement == parameters2[1]) {
                                methodName = "naturalOrder";
                            } else if (leftElement == parameters2[1] && rightElement == parameters2[0]) {
                                methodName = "reverseOrder";
                            }
                        }
                        if (methodName == null && ComparatorCombinatorsInspection.areEquivalent(parameters2, left, right)) {
                            methodName = "comparing";
                        }
                    } else {
                        PsiClass compareClass;
                        PsiMethod method2 = methodCall.resolveMethod();
                        if (args.length == 2 && method2 != null && method2.getName().equals("compare") && (compareClass = method2.getContainingClass()) != null) {
                            methodName = ComparatorCombinatorsInspection.getComparingMethodName(compareClass.getQualifiedName());
                            if (!ComparatorCombinatorsInspection.areEquivalent(parameters2, args[0], args[1])) {
                                return;
                            }
                        }
                    }
                } else if (body2 instanceof PsiBinaryExpression && (binOp = (PsiBinaryExpression)body2).getOperationTokenType().equals(JavaTokenType.MINUS) && ComparatorCombinatorsInspection.areEquivalent(parameters2, binOp.getLOperand(), binOp.getROperand())) {
                    PsiType opType = binOp.getLOperand().getType();
                    if (opType == null) {
                        return;
                    }
                    methodName = ComparatorCombinatorsInspection.getComparingMethodName(opType.getCanonicalText());
                }
                if (methodName != null) {
                    holder.registerProblem((PsiElement)lambda2, "Can be replaced with Comparator." + methodName, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new ReplaceWithComparatorFix(methodName)});
                }
            }
        };
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    private static String getComparingMethodName(String type2) {
        if (type2 == null) {
            return null;
        }
        switch (PsiTypesUtil.unboxIfPossible((String)type2)) {
            case "int": 
            case "short": 
            case "byte": 
            case "char": {
                return "comparingInt";
            }
            case "long": {
                return "comparingLong";
            }
            case "double": {
                return "comparingDouble";
            }
        }
        return null;
    }

    @Contract(value="_, null, _ -> false; _, !null, null -> false")
    private static boolean areEquivalent(@NotNull PsiParameter[] parameters2, @Nullable PsiExpression left, @Nullable PsiExpression right) {
        if (left == null || right == null) {
            return false;
        }
        if (!PsiTreeUtil.processElements((PsiElement)left, e -> !(e instanceof PsiReferenceExpression) || ((PsiReferenceExpression)e).resolve() != parameters2[1]) || !PsiTreeUtil.processElements((PsiElement)right, e -> !(e instanceof PsiReferenceExpression) || ((PsiReferenceExpression)e).resolve() != parameters2[0])) {
            return false;
        }
        PsiExpression copy = (PsiExpression)right.copy();
        PsiElement[] rightRefs = PsiTreeUtil.collectElements((PsiElement)copy, e -> e instanceof PsiReferenceExpression && ((PsiReferenceExpression)e).resolve() == parameters2[1]);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)left.getProject());
        String paramName = parameters2[0].getName();
        if (paramName == null) {
            return false;
        }
        for (PsiElement ref : rightRefs) {
            PsiElement nameElement = ((PsiReferenceExpression)ref).getReferenceNameElement();
            LOG.assertTrue(nameElement != null);
            nameElement.replace((PsiElement)factory.createIdentifier(paramName));
        }
        return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(left, copy);
    }

    static class ReplaceWithComparatorFix
    implements LocalQuickFix {
        private final String myMethodName;

        public ReplaceWithComparatorFix(String methodName) {
            this.myMethodName = methodName;
        }

        @Nls
        @NotNull
        public String getName() {
            return "Replace with Comparator." + this.myMethodName;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Simplify comparator using Comparator static methods";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiElement result2;
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiLambdaExpression)) {
                return;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)element;
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            if (parameters2.length != 2) {
                return;
            }
            PsiExpression body2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            PsiExpression keyExtractor = null;
            String methodName = null;
            if (body2 instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)body2;
                if (MethodCallUtils.isCompareToCall(methodCall)) {
                    methodName = "comparing";
                    keyExtractor = methodCall.getMethodExpression().getQualifierExpression();
                    if (keyExtractor instanceof PsiReferenceExpression) {
                        PsiElement keyElement = ((PsiReferenceExpression)keyExtractor).resolve();
                        if (keyElement == parameters2[0]) {
                            methodName = "naturalOrder";
                        } else if (keyElement == parameters2[1]) {
                            methodName = "reverseOrder";
                        }
                    }
                } else {
                    String className;
                    PsiClass containingClass;
                    PsiMethod method2 = methodCall.resolveMethod();
                    if (method2 != null && method2.getName().equals("compare") && (containingClass = method2.getContainingClass()) != null && (className = containingClass.getQualifiedName()) != null) {
                        PsiExpression[] args = methodCall.getArgumentList().getExpressions();
                        if (args.length != 2) {
                            return;
                        }
                        keyExtractor = args[0];
                        methodName = ComparatorCombinatorsInspection.getComparingMethodName(className);
                    }
                }
            } else if (body2 instanceof PsiBinaryExpression) {
                PsiBinaryExpression binOp = (PsiBinaryExpression)body2;
                if (!binOp.getOperationTokenType().equals(JavaTokenType.MINUS)) {
                    return;
                }
                keyExtractor = binOp.getLOperand();
                PsiType type2 = keyExtractor.getType();
                if (type2 == null) {
                    return;
                }
                methodName = ComparatorCombinatorsInspection.getComparingMethodName(type2.getCanonicalText());
            }
            if (methodName == null || keyExtractor == null) {
                return;
            }
            String parameterName = parameters2[0].getName();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            if (!methodName.startsWith("comparing")) {
                result2 = lambda2.replace((PsiElement)factory.createExpressionFromText("java.util.Comparator." + methodName + "()", element));
            } else {
                String newLambda = parameterName + " -> " + keyExtractor.getText();
                PsiExpression replacement = factory.createExpressionFromText("java.util.Comparator." + methodName + "(" + newLambda + ")", element);
                result2 = lambda2.replace((PsiElement)replacement);
                ReplaceWithComparatorFix.normalizeLambda(((PsiMethodCallExpression)result2).getArgumentList().getExpressions()[0], factory);
            }
            CodeStyleManager.getInstance((Project)project2).reformat(JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(result2));
        }

        private static void normalizeLambda(PsiExpression expression2, PsiElementFactory factory) {
            if (!(expression2 instanceof PsiLambdaExpression)) {
                return;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)expression2;
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            PsiElement body2 = lambda2.getBody();
            if (body2 == null) {
                return;
            }
            if (LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference(lambda2) == lambda2) {
                String[] names;
                PsiParameter parameter = parameters2[0];
                String name = parameter.getName();
                SuggestedNameInfo nameCandidate = null;
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)expression2.getProject());
                if (name != null) {
                    if (name.length() > 1 && name.endsWith("1")) {
                        nameCandidate = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, name.substring(0, name.length() - 1), null, parameter.getType(), true);
                    } else if (name.equals("first")) {
                        nameCandidate = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, parameter.getType(), true);
                    }
                }
                if (nameCandidate != null && (names = codeStyleManager.suggestUniqueVariableName(nameCandidate, (PsiElement)lambda2, (boolean)true).names).length > 0) {
                    String newName = names[0];
                    Collection references = PsiTreeUtil.collectElementsOfType((PsiElement)body2, (Class[])new Class[]{PsiReferenceExpression.class});
                    ((StreamEx)((StreamEx)StreamEx.of((Collection)references).filter(ref -> ref.resolve() == parameter)).map(PsiJavaCodeReferenceElement::getReferenceNameElement).nonNull()).forEach(nameElement -> nameElement.replace((PsiElement)factory.createIdentifier(newName)));
                    parameter.setName(newName);
                }
            }
        }
    }
}

