/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodThrowsFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class DeleteThrowsFix
implements LocalQuickFix {
    private final MethodThrowsFix myQuickFix;

    public DeleteThrowsFix(@NotNull PsiMethod method2, PsiClassType exceptionClass) {
        this.myQuickFix = new MethodThrowsFix(method2, exceptionClass, false, false);
    }

    @NotNull
    public String getName() {
        return this.myQuickFix.getText();
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("fix.throws.list.family", new Object[0]);
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (method2 == null) {
            return;
        }
        PsiFile psiFile = method2.getContainingFile();
        if (this.myQuickFix.isAvailable(project2, psiFile, (PsiElement)method2, (PsiElement)method2)) {
            this.myQuickFix.invoke(project2, psiFile, (PsiElement)method2, (PsiElement)method2);
        }
    }
}

