/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalInspectionUtil {
    private static final String LOC_MARKER = " #loc";

    @NotNull
    public static String createInspectionMessage(@NotNull String message2) {
        return message2 + LOC_MARKER;
    }

    public static void createProblem(@NotNull PsiElement elt, @NotNull HighlightInfo info, TextRange range, @Nullable ProblemGroup problemGroup, @NotNull InspectionManager manager, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor, @NotNull GlobalInspectionContext globalContext) {
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (info.quickFixActionRanges != null) {
            for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> actionRange : info.quickFixActionRanges) {
                IntentionAction action = ((HighlightInfo.IntentionActionDescriptor)actionRange.getFirst()).getAction();
                if (!(action instanceof LocalQuickFix)) continue;
                fixes.add((LocalQuickFix)action);
            }
        }
        ProblemDescriptor descriptor = manager.createProblemDescriptor(elt, range, GlobalInspectionUtil.createInspectionMessage(StringUtil.notNullize((String)info.getDescription())), HighlightInfo.convertType(info.type), false, fixes.isEmpty() ? null : fixes.toArray(new LocalQuickFix[fixes.size()]));
        descriptor.setProblemGroup(problemGroup);
        problemDescriptionsProcessor.addProblemElement((RefEntity)GlobalInspectionContextUtil.retrieveRefElement(elt, globalContext), new CommonProblemDescriptor[]{descriptor});
    }
}

