/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.application.options.CodeStyleSchemesConfigurable;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongLineInspection
extends LocalInspectionTool {
    @Nullable
    public JComponent createOptionsPanel() {
        HyperlinkLabel codeStyleHyperlink = new HyperlinkLabel("Edit Code Style settings");
        codeStyleHyperlink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                DataManager.getInstance().getDataContextFromFocus().doWhenDone((Consumer)new Consumer<DataContext>(){

                    public void consume(DataContext context) {
                        if (context != null) {
                            Settings settings = (Settings)Settings.KEY.getData(context);
                            if (settings != null) {
                                settings.select((Configurable)settings.find(CodeStyleSchemesConfigurable.class));
                            } else {
                                ShowSettingsUtil.getInstance().showSettingsDialog((Project)CommonDataKeys.PROJECT.getData(context), CodeStyleSchemesConfigurable.class);
                            }
                        }
                    }
                });
            }
        });
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)codeStyleHyperlink, "North");
        return panel2;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Project project2 = manager.getProject();
        int codeStyleRightMargin = CodeStyleSettingsManager.getSettings((Project)project2).getRightMargin(file2.getLanguage());
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile instanceof VirtualFileWindow) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(vFile);
        if (document == null) {
            return null;
        }
        SmartList descriptors = new SmartList();
        for (int idx = 0; idx < document.getLineCount(); ++idx) {
            int startOffset = document.getLineStartOffset(idx);
            int endOffset = document.getLineEndOffset(idx);
            if (endOffset - startOffset <= codeStyleRightMargin) continue;
            int maxOffset = startOffset + codeStyleRightMargin;
            descriptors.add(manager.createProblemDescriptor((PsiElement)file2, new TextRange(maxOffset, endOffset), String.format("Line is longer than allowed by code style (> %s columns)", codeStyleRightMargin), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
        }
        return descriptors.isEmpty() ? null : descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }
}

