/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.RemoveSuppressWarningAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantSuppressInspectionBase
extends GlobalInspectionTool {
    private BidirectionalMap<String, QuickFix> myQuickFixes;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.RedundantSuppressInspection");
    public boolean IGNORE_ALL;

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.DECLARATION_REDUNDANCY;
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"inspection.redundant.suppression.name", (Object[])new Object[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "RedundantSuppression";
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Ignore '@SuppressWarning(\"ALL\")'", (InspectionProfileEntry)this, "IGNORE_ALL");
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (this.IGNORE_ALL) {
            super.writeSettings(node);
        }
    }

    public void runInspection(@NotNull AnalysisScope scope, final @NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        globalContext.getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitClass(@NotNull RefClass refClass) {
                if (!globalContext.shouldCheck((RefEntity)refClass, (GlobalInspectionTool)RedundantSuppressInspectionBase.this)) {
                    return;
                }
                CommonProblemDescriptor[] descriptors = RedundantSuppressInspectionBase.this.checkElement(refClass, manager);
                if (descriptors != null) {
                    for (CommonProblemDescriptor descriptor : descriptors) {
                        if (descriptor instanceof ProblemDescriptor) {
                            PsiElement psiElement = ((ProblemDescriptor)descriptor).getPsiElement();
                            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMember.class);
                            RefElement refElement = globalContext.getRefManager().getReference((PsiElement)member);
                            if (refElement != null) {
                                problemDescriptionsProcessor.addProblemElement((RefEntity)refElement, new CommonProblemDescriptor[]{descriptor});
                                continue;
                            }
                        }
                        problemDescriptionsProcessor.addProblemElement((RefEntity)refClass, new CommonProblemDescriptor[]{descriptor});
                    }
                }
            }
        });
    }

    @Nullable
    private CommonProblemDescriptor[] checkElement(@NotNull RefClass refEntity, @NotNull InspectionManager manager) {
        PsiClass psiClass = refEntity.getElement();
        if (psiClass == null) {
            return null;
        }
        return this.checkElement((PsiElement)psiClass, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonProblemDescriptor[] checkElement(final @NotNull PsiElement psiElement, @NotNull InspectionManager manager) {
        ArrayList<ProblemDescriptor> result2;
        THashMap suppressedScopes = new THashMap();
        psiElement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Map)suppressedScopes){
            final /* synthetic */ Map val$suppressedScopes;
            {
                this.val$suppressedScopes = map2;
            }

            public void visitModifierList(PsiModifierList list) {
                super.visitModifierList(list);
                PsiElement parent = list.getParent();
                if (parent instanceof PsiModifierListOwner && !(parent instanceof PsiClass)) {
                    this.checkElement(parent);
                }
            }

            public void visitComment(PsiComment comment) {
                this.checkElement((PsiElement)comment);
            }

            public void visitClass(PsiClass aClass) {
                if (aClass == psiElement) {
                    super.visitClass(aClass);
                    this.checkElement((PsiElement)aClass);
                }
            }

            private void checkElement(PsiElement owner) {
                String idsString = JavaSuppressionUtil.getSuppressedInspectionIdsIn(owner);
                if (idsString != null && !idsString.isEmpty()) {
                    List ids = StringUtil.split((String)idsString, (String)",");
                    if (RedundantSuppressInspectionBase.this.IGNORE_ALL && (ids.contains("ALL") || ids.contains("ALL".toLowerCase()))) {
                        return;
                    }
                    Collection suppressed = (Collection)this.val$suppressedScopes.get(owner);
                    if (suppressed == null) {
                        suppressed = ids;
                    } else {
                        for (String id : ids) {
                            if (suppressed.contains(id)) continue;
                            suppressed.add(id);
                        }
                    }
                    this.val$suppressedScopes.put(owner, suppressed);
                }
            }
        });
        if (suppressedScopes.values().isEmpty()) {
            return null;
        }
        THashMap suppressedTools = new THashMap();
        InspectionToolWrapper[] toolWrappers = this.getInspectionTools(psiElement, manager);
        for (Collection ids : suppressedScopes.values()) {
            Iterator iterator = ids.iterator();
            block4: while (iterator.hasNext()) {
                String shortName = ((String)iterator.next()).trim();
                for (InspectionToolWrapper toolWrapper : toolWrappers) {
                    if (toolWrapper instanceof LocalInspectionToolWrapper && (((LocalInspectionTool)((LocalInspectionToolWrapper)toolWrapper).getTool()).getID().equals(shortName) || shortName.equals(((LocalInspectionTool)((LocalInspectionToolWrapper)toolWrapper).getTool()).getAlternativeID()))) {
                        if (((LocalInspectionToolWrapper)toolWrapper).isUnfair()) {
                            iterator.remove();
                            continue block4;
                        }
                        suppressedTools.put(toolWrapper, shortName);
                        continue;
                    }
                    if (!toolWrapper.getShortName().equals(shortName)) continue;
                    if (toolWrapper instanceof LocalInspectionToolWrapper || toolWrapper instanceof GlobalInspectionToolWrapper && !((GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool()).isGraphNeeded()) {
                        suppressedTools.put(toolWrapper, shortName);
                        continue;
                    }
                    iterator.remove();
                    continue block4;
                }
            }
        }
        PsiFile file2 = psiElement.getContainingFile();
        AnalysisScope scope = new AnalysisScope(file2);
        GlobalInspectionContextBase globalContext = this.createContext(file2);
        globalContext.setCurrentScope(scope);
        RefManagerImpl refManager = (RefManagerImpl)globalContext.getRefManager();
        refManager.inspectionReadActionStarted();
        try {
            result2 = new ArrayList<ProblemDescriptor>();
            for (InspectionToolWrapper toolWrapper : suppressedTools.keySet()) {
                Object global;
                ArrayList descriptors;
                String toolId = (String)suppressedTools.get(toolWrapper);
                toolWrapper.initialize((GlobalInspectionContext)globalContext);
                if (toolWrapper instanceof LocalInspectionToolWrapper) {
                    LocalInspectionToolWrapper local = (LocalInspectionToolWrapper)toolWrapper;
                    if (local.isUnfair()) continue;
                    List results = ((LocalInspectionTool)local.getTool()).processFile(file2, manager);
                    descriptors = new ArrayList(results);
                } else {
                    GlobalInspectionTool globalTool;
                    if (!(toolWrapper instanceof GlobalInspectionToolWrapper) || (globalTool = (GlobalInspectionTool)(global = (GlobalInspectionToolWrapper)toolWrapper).getTool()).isGraphNeeded()) continue;
                    descriptors = new ArrayList();
                    globalContext.getRefManager().iterate(new RefVisitor((GlobalInspectionToolWrapper)((Object)global), scope, manager, globalContext, descriptors){
                        final /* synthetic */ GlobalInspectionToolWrapper val$global;
                        final /* synthetic */ AnalysisScope val$scope;
                        final /* synthetic */ InspectionManager val$manager;
                        final /* synthetic */ GlobalInspectionContextBase val$globalContext;
                        final /* synthetic */ Collection val$descriptors;
                        {
                            this.val$global = globalInspectionToolWrapper;
                            this.val$scope = analysisScope;
                            this.val$manager = inspectionManager;
                            this.val$globalContext = globalInspectionContextBase;
                            this.val$descriptors = collection;
                        }

                        public void visitElement(@NotNull RefEntity refEntity) {
                            Object[] descriptors1 = ((GlobalInspectionTool)this.val$global.getTool()).checkElement(refEntity, this.val$scope, this.val$manager, (GlobalInspectionContext)this.val$globalContext, new ProblemDescriptionsProcessor(){});
                            if (descriptors1 != null) {
                                ContainerUtil.addAll((Collection)this.val$descriptors, (Object[])descriptors1);
                            }
                        }
                    });
                }
                global = suppressedScopes.keySet().iterator();
                block7: while (global.hasNext()) {
                    PsiElement suppressedScope = (PsiElement)global.next();
                    Collection suppressedIds = (Collection)suppressedScopes.get(suppressedScope);
                    if (!suppressedIds.contains(toolId)) continue;
                    for (CommonProblemDescriptor descriptor : descriptors) {
                        PsiElement annotation;
                        PsiElement element;
                        if (!(descriptor instanceof ProblemDescriptor) || (element = ((ProblemDescriptor)descriptor).getPsiElement()) == null || ((annotation = JavaSuppressionUtil.getElementToolSuppressedIn(element, toolId)) == null || !PsiTreeUtil.isAncestor((PsiElement)suppressedScope, (PsiElement)annotation, (boolean)false)) && (annotation != null || PsiTreeUtil.isAncestor((PsiElement)suppressedScope, (PsiElement)element, (boolean)false))) continue;
                        suppressedIds.remove(toolId);
                        continue block7;
                    }
                }
            }
            for (PsiElement suppressedScope : suppressedScopes.keySet()) {
                Collection suppressedIds = (Collection)suppressedScopes.get(suppressedScope);
                for (String toolId : suppressedIds) {
                    String key2;
                    Object fix;
                    PsiMember psiMember;
                    String problemLine = null;
                    if (suppressedScope instanceof PsiMember) {
                        psiMember = (PsiMember)suppressedScope;
                    } else {
                        psiMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)suppressedScope, PsiDocCommentOwner.class);
                        PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)suppressedScope, PsiStatement.class);
                        String string = problemLine = statement2 != null ? statement2.getText() : null;
                    }
                    if (psiMember == null || !psiMember.isValid()) continue;
                    String description = InspectionsBundle.message((String)"inspection.redundant.suppression.description", (Object[])new Object[0]);
                    if (this.myQuickFixes == null) {
                        this.myQuickFixes = new BidirectionalMap();
                    }
                    if ((fix = (QuickFix)this.myQuickFixes.get((Object)(key2 = toolId + (problemLine != null ? ";" + problemLine : "")))) == null) {
                        fix = new RemoveSuppressWarningAction(toolId, problemLine);
                        this.myQuickFixes.put((Object)key2, fix);
                    }
                    PsiElement identifier = null;
                    if (!(suppressedScope instanceof PsiMember)) {
                        identifier = suppressedScope;
                    } else if (psiMember instanceof PsiMethod) {
                        identifier = ((PsiMethod)psiMember).getNameIdentifier();
                    } else if (psiMember instanceof PsiField) {
                        identifier = ((PsiField)psiMember).getNameIdentifier();
                    } else if (psiMember instanceof PsiClass) {
                        identifier = ((PsiClass)psiMember).getNameIdentifier();
                    }
                    if (identifier == null) {
                        identifier = psiMember;
                    }
                    result2.add(manager.createProblemDescriptor(identifier, description, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false));
                }
            }
        }
        finally {
            refManager.inspectionReadActionFinished();
            globalContext.close(true);
        }
        return (CommonProblemDescriptor[])result2.toArray(new ProblemDescriptor[result2.size()]);
    }

    protected GlobalInspectionContextBase createContext(PsiFile file2) {
        return new GlobalInspectionContextBase(file2.getProject());
    }

    protected InspectionToolWrapper[] getInspectionTools(PsiElement psiElement, @NotNull InspectionManager manager) {
        return new InspectionProfileModifiableModel(InspectionProjectProfileManager.getInstance(manager.getProject()).getCurrentProfile()).getInspectionTools(psiElement);
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return this.myQuickFixes != null ? (QuickFix)this.myQuickFixes.get((Object)hint) : new RemoveSuppressWarningAction(hint);
    }

    @Nullable
    public String getHint(@NotNull QuickFix fix) {
        List list;
        if (this.myQuickFixes != null && (list = this.myQuickFixes.getKeysByValue((Object)fix)) != null) {
            LOG.assertTrue(list.size() == 1);
            return (String)list.get(0);
        }
        return null;
    }

    public boolean isEnabledByDefault() {
        return false;
    }
}

