/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.SelectInEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithTernaryOperatorFix
implements LocalQuickFix {
    private final String myText;

    @NotNull
    public String getName() {
        return InspectionsBundle.message((String)"inspection.replace.ternary.quickfix", (Object[])new Object[]{this.myText});
    }

    public ReplaceWithTernaryOperatorFix(@NotNull PsiExpression expressionToAssert) {
        this.myText = expressionToAssert.getText();
    }

    @NotNull
    public String getFamilyName() {
        return InspectionsBundle.message((String)"inspection.surround.if.family", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiElement parent;
        PsiElement element = descriptor.getPsiElement();
        while ((parent = element.getParent()) instanceof PsiReferenceExpression || parent instanceof PsiMethodCallExpression) {
            element = parent;
        }
        if (!(element instanceof PsiExpression)) {
            return;
        }
        PsiExpression expression2 = (PsiExpression)element;
        PsiFile file2 = expression2.getContainingFile();
        PsiConditionalExpression conditionalExpression = ReplaceWithTernaryOperatorFix.replaceWthConditionalExpression(project2, this.myText + "!=null", expression2, ReplaceWithTernaryOperatorFix.suggestDefaultValue(expression2));
        PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
        if (elseExpression2 != null) {
            ((Navigatable)elseExpression2).navigate(true);
            SelectInEditorManager.getInstance((Project)project2).selectInEditor(file2.getVirtualFile(), elseExpression2.getTextRange().getStartOffset(), elseExpression2.getTextRange().getEndOffset(), false, true);
        }
    }

    @NotNull
    private static PsiConditionalExpression replaceWthConditionalExpression(@NotNull Project project2, @NotNull String condition2, @NotNull PsiExpression expression2, @NotNull String defaultValue) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiElement parent = expression2.getParent();
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)factory.createExpressionFromText(condition2 + " ? " + expression2.getText() + " : " + defaultValue, parent);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        return (PsiConditionalExpression)expression2.replace(codeStyleManager.reformat((PsiElement)conditionalExpression));
    }

    public static boolean isAvailable(@NotNull PsiExpression qualifier, @NotNull PsiExpression expression2) {
        if (!qualifier.isValid() || qualifier.getText() == null) {
            return false;
        }
        return !(expression2.getParent() instanceof PsiExpressionStatement) && !PsiUtil.isAccessedForWriting((PsiExpression)expression2);
    }

    private static String suggestDefaultValue(@NotNull PsiExpression expression2) {
        PsiType type2 = expression2.getType();
        return PsiTypesUtil.getDefaultValueOfType((PsiType)type2);
    }
}

