/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressManagerImpl
extends SuppressManager {
    private static final Logger LOG = Logger.getInstance(SuppressManager.class);

    @NotNull
    public SuppressIntentionAction[] createSuppressActions(@NotNull HighlightDisplayKey displayKey) {
        SuppressQuickFix[] batchSuppressActions = this.createBatchSuppressActions(displayKey);
        return SuppressIntentionActionFromFix.convertBatchToSuppressIntentionActions(batchSuppressActions);
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        HighlightDisplayKey displayKey = HighlightDisplayKey.findById((String)toolId);
        LOG.assertTrue(displayKey != null, (Object)("Display key is null for `" + toolId + "` tool"));
        return this.createBatchSuppressActions(displayKey);
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        return JavaSuppressionUtil.getElementToolSuppressedIn(element, toolId) != null;
    }

    @Nullable
    public PsiElement getElementMemberSuppressedIn(@NotNull PsiDocCommentOwner owner, @NotNull String inspectionToolID) {
        return JavaSuppressionUtil.getElementMemberSuppressedIn(owner, inspectionToolID);
    }

    @Nullable
    public PsiElement getAnnotationMemberSuppressedIn(@NotNull PsiModifierListOwner owner, @NotNull String inspectionToolID) {
        return JavaSuppressionUtil.getAnnotationMemberSuppressedIn(owner, inspectionToolID);
    }

    @Nullable
    public PsiElement getDocCommentToolSuppressedIn(@NotNull PsiDocCommentOwner owner, @NotNull String inspectionToolID) {
        return JavaSuppressionUtil.getDocCommentToolSuppressedIn(owner, inspectionToolID);
    }

    @NotNull
    public Collection<String> getInspectionIdsSuppressedInAnnotation(@NotNull PsiModifierListOwner owner) {
        return JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation(owner);
    }

    @Nullable
    public String getSuppressedInspectionIdsIn(@NotNull PsiElement element) {
        return JavaSuppressionUtil.getSuppressedInspectionIdsIn(element);
    }

    @Nullable
    public PsiElement getElementToolSuppressedIn(@NotNull PsiElement place, @NotNull String toolId) {
        return JavaSuppressionUtil.getElementToolSuppressedIn(place, toolId);
    }

    public boolean canHave15Suppressions(@NotNull PsiElement file2) {
        return JavaSuppressionUtil.canHave15Suppressions(file2);
    }

    public boolean alreadyHas14Suppressions(@NotNull PsiDocCommentOwner commentOwner) {
        return JavaSuppressionUtil.alreadyHas14Suppressions(commentOwner);
    }
}

