/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TrivialFunctionalExpressionUsageInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                this.doCheckMethodCallOnFunctionalExpression((PsiElement)expression2, (Condition<PsiElement>)((Condition)element -> expression2.resolve() != null));
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                this.doCheckMethodCallOnFunctionalExpression((PsiElement)expression2, (Condition<PsiElement>)((Condition)ggParent -> {
                    PsiElement callParent = ggParent.getParent();
                    PsiElement body2 = expression2.getBody();
                    if (!(body2 instanceof PsiCodeBlock)) {
                        return callParent instanceof PsiStatement || callParent instanceof PsiLocalVariable || expression2.isValueCompatible();
                    }
                    Object[] statements = ((PsiCodeBlock)body2).getStatements();
                    if (statements.length == 1) {
                        return callParent instanceof PsiStatement || callParent instanceof PsiLocalVariable || statements[0] instanceof PsiReturnStatement && expression2.isValueCompatible();
                    }
                    List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)expression2);
                    if (returnExpressions.size() > 1 || returnExpressions.size() == 1 && !(ArrayUtil.getLastElement((Object[])statements) instanceof PsiReturnStatement)) {
                        return false;
                    }
                    if (!returnExpressions.isEmpty() && callParent instanceof PsiLocalVariable) {
                        return true;
                    }
                    return callParent instanceof PsiStatement && !(callParent instanceof PsiLoopStatement) || callParent instanceof PsiLambdaExpression;
                }));
            }

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda(aClass, false, Collections.emptySet())) {
                    PsiElement newExpression = aClass.getParent();
                    this.doCheckMethodCallOnFunctionalExpression((Condition<PsiElement>)((Condition)ggParent -> {
                        PsiMethod method2 = aClass.getMethods()[0];
                        PsiCodeBlock body2 = method2.getBody();
                        PsiReturnStatement[] returnStatements = PsiUtil.findReturnStatements((PsiCodeBlock)body2);
                        if (returnStatements.length > 1) {
                            return false;
                        }
                        PsiElement callParent = ggParent.getParent();
                        return callParent instanceof PsiStatement || callParent instanceof PsiLocalVariable;
                    }), newExpression, (PsiType)aClass.getBaseClassType(), new ReplaceAnonymousWithLambdaBodyFix());
                }
            }

            private void doCheckMethodCallOnFunctionalExpression(PsiElement expression2, Condition<PsiElement> elementContainerCondition) {
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
                if (parent instanceof PsiTypeCastExpression) {
                    PsiType interfaceType = ((PsiTypeCastExpression)parent).getType();
                    this.doCheckMethodCallOnFunctionalExpression(elementContainerCondition, parent, interfaceType, expression2 instanceof PsiLambdaExpression ? new ReplaceWithLambdaBodyFix() : new ReplaceWithMethodReferenceFix());
                }
            }

            private void doCheckMethodCallOnFunctionalExpression(Condition<PsiElement> elementContainerCondition, PsiElement parent, PsiType interfaceType, LocalQuickFix fix) {
                PsiElement ggParent;
                PsiElement gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
                if (gParent instanceof PsiReferenceExpression && (ggParent = gParent.getParent()) instanceof PsiMethodCallExpression) {
                    PsiMethod interfaceMethod;
                    PsiMethod resolveMethod = ((PsiMethodCallExpression)ggParent).resolveMethod();
                    PsiElement referenceNameElement = ((PsiMethodCallExpression)ggParent).getMethodExpression().getReferenceNameElement();
                    if (resolveMethod != null && !resolveMethod.isVarArgs() && ((PsiMethodCallExpression)ggParent).getArgumentList().getExpressions().length == resolveMethod.getParameterList().getParametersCount() && referenceNameElement != null && elementContainerCondition.value((Object)ggParent) && (resolveMethod == (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)interfaceType)) || interfaceMethod != null && MethodSignatureUtil.isSuperMethod((PsiMethod)interfaceMethod, (PsiMethod)resolveMethod))) {
                        holder.registerProblem(referenceNameElement, "Method call can be simplified", new LocalQuickFix[]{fix});
                    }
                }
            }
        };
    }

    private static void replaceWithLambdaBody(PsiMethodCallExpression callExpression, PsiLambdaExpression element) {
        PsiElement body2 = element.getBody();
        PsiExpression expression2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)body2);
        if (expression2 != null) {
            CommentTracker ct = new CommentTracker();
            TrivialFunctionalExpressionUsageInspection.inlineCallArguments(callExpression, element, ct);
            ct.replaceAndRestoreComments((PsiElement)callExpression, (PsiElement)ct.markUnchanged(expression2));
        } else if (body2 instanceof PsiCodeBlock) {
            if ((element = RefactoringUtil.ensureCodeBlock(element)) == null) {
                return;
            }
            body2 = element.getBody();
            if (!(body2 instanceof PsiCodeBlock)) {
                return;
            }
            callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
            if (callExpression == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            TrivialFunctionalExpressionUsageInspection.inlineCallArguments(callExpression, element, ct);
            PsiElement parent = callExpression.getParent();
            PsiStatement[] statements = ((PsiCodeBlock)body2).getStatements();
            if (statements.length > 0) {
                PsiExpression returnValue;
                PsiStatement anchor = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiStatement.class, (boolean)false);
                PsiReturnStatement statement2 = (PsiReturnStatement)ObjectUtils.tryCast((Object)statements[statements.length - 1], PsiReturnStatement.class);
                if (anchor != null) {
                    PsiElement gParent = anchor.getParent();
                    for (PsiElement child : body2.getChildren()) {
                        if (child == statement2 || child instanceof PsiJavaToken) continue;
                        gParent.addBefore(ct.markUnchanged(child), (PsiElement)anchor);
                    }
                }
                PsiExpression psiExpression = returnValue = statement2 == null ? null : statement2.getReturnValue();
                if (returnValue != null) {
                    ct.replaceAndRestoreComments((PsiElement)callExpression, (PsiElement)ct.markUnchanged(returnValue));
                } else {
                    ct.deleteAndRestoreComments((PsiElement)callExpression);
                }
            }
        }
    }

    private static void inlineCallArguments(PsiMethodCallExpression callExpression, PsiLambdaExpression element, CommentTracker ct) {
        PsiExpression[] args = callExpression.getArgumentList().getExpressions();
        PsiParameter[] parameters2 = element.getParameterList().getParameters();
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            PsiParameter parameter = parameters2[i2];
            PsiExpression initializer = args[i2];
            for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter)) {
                PsiElement referenceElement = reference.getElement();
                if (!(referenceElement instanceof PsiJavaCodeReferenceElement)) continue;
                ct.markUnchanged(initializer);
                InlineUtil.inlineVariable((PsiVariable)parameter, initializer, (PsiJavaCodeReferenceElement)referenceElement);
            }
        }
    }

    private static abstract class ReplaceFix
    implements LocalQuickFix {
        private ReplaceFix() {
        }

        @Nls
        @NotNull
        public String getName() {
            return this.getFamilyName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement = descriptor.getPsiElement();
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethodCallExpression.class);
            if (callExpression != null) {
                this.fixExpression(callExpression, PsiUtil.skipParenthesizedExprDown((PsiExpression)callExpression.getMethodExpression().getQualifierExpression()));
            }
        }

        protected abstract void fixExpression(PsiMethodCallExpression var1, PsiExpression var2);
    }

    private static class ReplaceAnonymousWithLambdaBodyFix
    extends ReplaceFix {
        private ReplaceAnonymousWithLambdaBodyFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Replace call with method body";
        }

        @Override
        protected void fixExpression(PsiMethodCallExpression callExpression, PsiExpression qualifierExpression2) {
            PsiExpression lambdaExpression;
            PsiExpression cast = AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)qualifierExpression2, true, false);
            if (cast instanceof PsiTypeCastExpression && (lambdaExpression = ((PsiTypeCastExpression)cast).getOperand()) instanceof PsiLambdaExpression) {
                TrivialFunctionalExpressionUsageInspection.replaceWithLambdaBody(callExpression, (PsiLambdaExpression)lambdaExpression);
            }
        }
    }

    private static class ReplaceWithMethodReferenceFix
    extends ReplaceFix {
        private ReplaceWithMethodReferenceFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Replace method call on method reference with corresponding method call";
        }

        @Override
        protected void fixExpression(PsiMethodCallExpression callExpression, PsiExpression qualifierExpression2) {
            PsiLambdaExpression lambdaExpression;
            PsiExpression element;
            if (qualifierExpression2 instanceof PsiTypeCastExpression && (element = ((PsiTypeCastExpression)qualifierExpression2).getOperand()) instanceof PsiMethodReferenceExpression && (lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)element, false, true)) != null) {
                TrivialFunctionalExpressionUsageInspection.replaceWithLambdaBody(callExpression, lambdaExpression);
            }
        }
    }

    private static class ReplaceWithLambdaBodyFix
    extends ReplaceFix {
        private ReplaceWithLambdaBodyFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Replace method call on lambda with lambda body";
        }

        @Override
        protected void fixExpression(PsiMethodCallExpression callExpression, PsiExpression qualifierExpression2) {
            PsiExpression element;
            if (qualifierExpression2 instanceof PsiTypeCastExpression && (element = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiTypeCastExpression)qualifierExpression2).getOperand())) instanceof PsiLambdaExpression) {
                TrivialFunctionalExpressionUsageInspection.replaceWithLambdaBody(callExpression, (PsiLambdaExpression)element);
            }
        }
    }
}

