/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TrivialMethodReferenceInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                PsiElement resolve2;
                PsiType functionalInterfaceType;
                PsiMethod interfaceMethod;
                PsiType qualifierType;
                PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
                PsiElement referenceNameElement = expression2.getReferenceNameElement();
                if (qualifierExpression2 != null && referenceNameElement != null && !(qualifierExpression2 instanceof PsiSuperExpression) && (qualifierType = qualifierExpression2.getType()) != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)(functionalInterfaceType = expression2.getFunctionalInterfaceType()))) != null && (resolve2 = expression2.resolve()) instanceof PsiMethod && (interfaceMethod == resolve2 || MethodSignatureUtil.isSuperMethod((PsiMethod)interfaceMethod, (PsiMethod)((PsiMethod)resolve2))) && TypeConversionUtil.isAssignable((PsiType)functionalInterfaceType, (PsiType)qualifierType)) {
                    holder.registerProblem(referenceNameElement, "Method reference can be replaced with qualifier", new LocalQuickFix[]{new ReplaceMethodRefWithQualifierFix()});
                }
            }
        };
    }

    private static class ReplaceMethodRefWithQualifierFix
    implements LocalQuickFix {
        private ReplaceMethodRefWithQualifierFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Replace with qualifier";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiExpression qualifierExpression2;
            PsiElement parent;
            PsiElement element = descriptor.getPsiElement();
            PsiElement psiElement = parent = element != null ? element.getParent() : null;
            if (parent instanceof PsiMethodReferenceExpression && (qualifierExpression2 = ((PsiMethodReferenceExpression)parent).getQualifierExpression()) != null) {
                parent.replace((PsiElement)qualifierExpression2);
            }
        }
    }
}

