/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.PerformFixesModalTask;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SequentialModalProgressTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleanupInspectionIntention
implements IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(CleanupInspectionIntention.class);
    private final InspectionToolWrapper myToolWrapper;
    private final Class myQuickfixClass;
    private final String myText;

    public CleanupInspectionIntention(@NotNull InspectionToolWrapper toolWrapper, @NotNull Class quickFixClass, String text) {
        this.myToolWrapper = toolWrapper;
        this.myQuickfixClass = quickFixClass;
        this.myText = text;
    }

    @NotNull
    public String getText() {
        return InspectionsBundle.message((String)"fix.all.inspection.problems.in.file", (Object[])new Object[]{this.myToolWrapper.getDisplayName()});
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        List descriptions = (List)ProgressManager.getInstance().runProcess(() -> {
            InspectionManager inspectionManager = InspectionManager.getInstance((Project)project2);
            return InspectionEngine.runInspectionOnFile(file2, this.myToolWrapper, inspectionManager.createNewGlobalContext(false));
        }, (ProgressIndicator)new EmptyProgressIndicator());
        if (!descriptions.isEmpty() && !FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file2)) {
            return;
        }
        AbstractPerformFixesTask fixesTask = CleanupInspectionIntention.applyFixes(project2, "Apply Fixes", descriptions, this.myQuickfixClass);
        if (!fixesTask.isApplicableFixFound()) {
            HintManager.getInstance().showErrorHint(editor, "Unfortunately '" + this.myText + "' is currently not available for batch mode\n User interaction is required for each problem found");
        }
    }

    public static AbstractPerformFixesTask applyFixes(@NotNull Project project2, @NotNull String presentationText, @NotNull List<ProblemDescriptor> descriptions, @Nullable Class quickfixClass) {
        CleanupInspectionIntention.sortDescriptions(descriptions);
        return CleanupInspectionIntention.applyFixesNoSort(project2, presentationText, descriptions, quickfixClass);
    }

    public static AbstractPerformFixesTask applyFixesNoSort(@NotNull Project project2, @NotNull String presentationText, @NotNull List<ProblemDescriptor> descriptions, @Nullable Class quickfixClass) {
        SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project2, presentationText, true);
        boolean isBatch = quickfixClass != null && BatchQuickFix.class.isAssignableFrom(quickfixClass);
        AbstractPerformFixesTask fixesTask = isBatch ? new PerformBatchFixesTask(project2, (CommonProblemDescriptor[])descriptions.toArray(ProblemDescriptor.EMPTY_ARRAY), progressTask, quickfixClass) : new PerformFixesTask(project2, (CommonProblemDescriptor[])descriptions.toArray(ProblemDescriptor.EMPTY_ARRAY), progressTask, quickfixClass);
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
            progressTask.setMinIterationTime(200L);
            progressTask.setTask(fixesTask);
            ProgressManager.getInstance().run((Task)progressTask);
        }, presentationText, null);
        return fixesTask;
    }

    public static void sortDescriptions(@NotNull List<ProblemDescriptor> descriptions) {
        Collections.sort(descriptions, (o1, o2) -> {
            ProblemDescriptorBase d1 = (ProblemDescriptorBase)o1;
            ProblemDescriptorBase d2 = (ProblemDescriptorBase)o2;
            int elementsDiff = PsiUtilCore.compareElementsByPosition((PsiElement)d1.getPsiElement(), (PsiElement)d2.getPsiElement());
            if (elementsDiff == 0) {
                return Comparing.compare((Comparable)((Object)d1.getDescriptionTemplate()), (Comparable)((Object)d2.getDescriptionTemplate()));
            }
            return -elementsDiff;
        });
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myQuickfixClass != EmptyIntentionAction.class && editor != null && (!(this.myToolWrapper instanceof LocalInspectionToolWrapper) || !((LocalInspectionToolWrapper)this.myToolWrapper).isUnfair());
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static class PerformFixesTask
    extends AbstractPerformFixesTask {
        public PerformFixesTask(@NotNull Project project2, @NotNull CommonProblemDescriptor[] descriptors, @NotNull SequentialModalProgressTask task, @Nullable Class quickFixClass) {
            super(project2, descriptors, task, quickFixClass);
        }

        @Override
        protected void collectFix(QuickFix fix, ProblemDescriptor descriptor, Project project2) {
            fix.applyFix(project2, (CommonProblemDescriptor)descriptor);
        }
    }

    private static class PerformBatchFixesTask
    extends AbstractPerformFixesTask {
        private final List<ProblemDescriptor> myBatchModeDescriptors = new ArrayList<ProblemDescriptor>();
        private boolean myApplied = false;

        public PerformBatchFixesTask(@NotNull Project project2, @NotNull CommonProblemDescriptor[] descriptors, @NotNull SequentialModalProgressTask task, @NotNull Class quickfixClass) {
            super(project2, descriptors, task, quickfixClass);
        }

        @Override
        protected void collectFix(QuickFix fix, ProblemDescriptor descriptor, Project project2) {
            this.myBatchModeDescriptors.add(descriptor);
        }

        @Override
        public boolean isDone() {
            if (super.isDone()) {
                if (!this.myApplied && !this.myBatchModeDescriptors.isEmpty()) {
                    ProblemDescriptor representative = this.myBatchModeDescriptors.get(0);
                    LOG.assertTrue(representative.getFixes() != null);
                    for (QuickFix fix : representative.getFixes()) {
                        if (fix == null || !fix.getClass().isAssignableFrom(this.myQuickfixClass)) continue;
                        ((BatchQuickFix)fix).applyFix(this.myProject, (CommonProblemDescriptor[])this.myBatchModeDescriptors.toArray(new ProblemDescriptor[this.myBatchModeDescriptors.size()]), new ArrayList(), null);
                        break;
                    }
                    this.myApplied = true;
                }
                return true;
            }
            return false;
        }
    }

    private static abstract class AbstractPerformFixesTask
    extends PerformFixesModalTask {
        private boolean myApplicableFixFound = false;
        protected final Class myQuickfixClass;

        public AbstractPerformFixesTask(@NotNull Project project2, @NotNull CommonProblemDescriptor[] descriptors, @NotNull SequentialModalProgressTask task, @Nullable Class quickfixClass) {
            super(project2, descriptors, task);
            this.myQuickfixClass = quickfixClass;
        }

        protected abstract void collectFix(QuickFix var1, ProblemDescriptor var2, Project var3);

        @Override
        protected final void applyFix(Project project2, CommonProblemDescriptor descriptor) {
            QuickFix[] fixes = descriptor.getFixes();
            if (fixes != null && fixes.length > 0) {
                for (QuickFix fix : fixes) {
                    if (fix == null || this.myQuickfixClass != null && !fix.getClass().isAssignableFrom(this.myQuickfixClass)) continue;
                    ProblemDescriptor problemDescriptor = (ProblemDescriptor)descriptor;
                    PsiElement element = problemDescriptor.getPsiElement();
                    if (element == null || !element.isValid()) break;
                    this.collectFix(fix, problemDescriptor, project2);
                    this.myApplicableFixFound = true;
                    break;
                }
            }
        }

        public final boolean isApplicableFixFound() {
            return this.myApplicableFixFound;
        }
    }
}

