/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.application.options.schemes.SchemesCombo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.header.InspectionProfileSchemesModel;
import com.intellij.profile.codeInspection.ui.header.InspectionToolsConfigurable;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CodeInspectionAction
extends BaseAnalysisAction {
    private static final Logger LOG = Logger.getInstance(CodeInspectionAction.class);
    private static final String LAST_SELECTED_PROFILE_PROP = "run.code.analysis.last.selected.profile";
    private GlobalInspectionContextImpl myGlobalInspectionContext;
    protected InspectionProfileImpl myExternalProfile;

    public CodeInspectionAction() {
        super(InspectionsBundle.message((String)"inspection.action.title", (Object[])new Object[0]), InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0]));
    }

    public CodeInspectionAction(String title, String analysisNoon) {
        super(title, analysisNoon);
    }

    @Override
    protected void analyze(@NotNull Project project2, @NotNull AnalysisScope scope) {
        try {
            this.runInspections(project2, scope);
        }
        finally {
            this.myGlobalInspectionContext = null;
            this.myExternalProfile = null;
        }
    }

    protected void runInspections(Project project2, AnalysisScope scope) {
        scope.setSearchInLibraries(false);
        FileDocumentManager.getInstance().saveAllDocuments();
        GlobalInspectionContextImpl inspectionContext = this.getGlobalInspectionContext(project2);
        inspectionContext.setExternalProfile(this.myExternalProfile);
        inspectionContext.setCurrentScope(scope);
        inspectionContext.doInspections(scope);
    }

    private GlobalInspectionContextImpl getGlobalInspectionContext(Project project2) {
        if (this.myGlobalInspectionContext == null) {
            this.myGlobalInspectionContext = ((InspectionManagerEx)InspectionManager.getInstance((Project)project2)).createNewGlobalContext(false);
        }
        return this.myGlobalInspectionContext;
    }

    @Override
    @NonNls
    protected String getHelpTopic() {
        return "reference.dialogs.inspection.scope";
    }

    @Override
    protected void canceled() {
        super.canceled();
        this.myGlobalInspectionContext = null;
    }

    @Override
    protected JComponent getAdditionalActionSettings(final @NotNull Project project2, final BaseAnalysisActionDialog dialog2) {
        AdditionalPanel panel2 = new AdditionalPanel();
        final InspectionManagerEx manager = (InspectionManagerEx)InspectionManager.getInstance((Project)project2);
        final SchemesCombo profiles = (SchemesCombo)((Object)panel2.myBrowseProfilesCombo.getComboBox());
        final InspectionProfileManager profileManager = InspectionProfileManager.getInstance();
        final ProjectInspectionProfileManager projectProfileManager = ProjectInspectionProfileManager.getInstance(project2);
        panel2.myBrowseProfilesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExternalProfilesComboboxAwareInspectionToolsConfigurable errorConfigurable = CodeInspectionAction.this.createConfigurable(projectProfileManager, profiles);
                MySingleConfigurableEditor editor = new MySingleConfigurableEditor(project2, errorConfigurable, manager);
                if (editor.showAndGet()) {
                    CodeInspectionAction.this.reloadProfiles(profiles, profileManager, projectProfileManager, project2);
                    if (errorConfigurable.mySelectedName != null) {
                        InspectionProfileImpl profile2 = (errorConfigurable.mySelectedIsProjectProfile ? projectProfileManager : profileManager).getProfile(errorConfigurable.mySelectedName);
                        profiles.selectScheme(profile2);
                    }
                } else {
                    InspectionProfile profile3 = (InspectionProfile)profiles.getSelectedScheme();
                    boolean canExecute = profile3 != null && profile3.isExecutable(project2);
                    dialog2.setOKActionEnabled(canExecute);
                }
            }
        });
        profiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeInspectionAction.this.myExternalProfile = (InspectionProfileImpl)profiles.getSelectedScheme();
                boolean canExecute = CodeInspectionAction.this.myExternalProfile != null && CodeInspectionAction.this.myExternalProfile.isExecutable(project2);
                dialog2.setOKActionEnabled(canExecute);
                if (canExecute) {
                    PropertiesComponent.getInstance((Project)project2).setValue(CodeInspectionAction.LAST_SELECTED_PROFILE_PROP, (CodeInspectionAction.this.myExternalProfile.isProjectLevel() ? (char)'p' : 'a') + CodeInspectionAction.this.myExternalProfile.getName());
                    manager.setProfile(CodeInspectionAction.this.myExternalProfile.getName());
                }
            }
        });
        this.reloadProfiles(profiles, profileManager, projectProfileManager, project2);
        return panel2.myAdditionalPanel;
    }

    protected ExternalProfilesComboboxAwareInspectionToolsConfigurable createConfigurable(ProjectInspectionProfileManager projectProfileManager, SchemesCombo<InspectionProfileImpl> profilesCombo) {
        return new ExternalProfilesComboboxAwareInspectionToolsConfigurable(projectProfileManager, profilesCombo);
    }

    private void reloadProfiles(SchemesCombo<InspectionProfileImpl> profilesCombo, InspectionProfileManager appProfileManager, InspectionProjectProfileManager projectProfileManager, Project project2) {
        profilesCombo.resetSchemes(InspectionProfileSchemesModel.getSortedProfiles(appProfileManager, projectProfileManager));
        InspectionProfileImpl selectedProfile = this.getProfileToUse(project2, appProfileManager, projectProfileManager);
        profilesCombo.selectScheme(selectedProfile);
    }

    @NotNull
    private InspectionProfileImpl getProfileToUse(@NotNull Project project2, @NotNull InspectionProfileManager appProfileManager, @NotNull InspectionProjectProfileManager projectProfileManager) {
        String lastSelectedProfile = PropertiesComponent.getInstance((Project)project2).getValue(LAST_SELECTED_PROFILE_PROP);
        if (lastSelectedProfile != null) {
            char type2 = lastSelectedProfile.charAt(0);
            String lastSelectedProfileName = lastSelectedProfile.substring(1);
            if (type2 == 'a') {
                InspectionProfileImpl profile2 = appProfileManager.getProfile(lastSelectedProfileName, false);
                if (profile2 != null) {
                    return profile2;
                }
            } else {
                LOG.assertTrue(type2 == 'p', (Object)("Unexpected last selected profile: '" + lastSelectedProfile + "'"));
                InspectionProfileImpl profile3 = projectProfileManager.getProfile(lastSelectedProfileName, false);
                if (profile3 != null && profile3.isProjectLevel()) {
                    return profile3;
                }
            }
        }
        return this.getGlobalInspectionContext(project2).getCurrentProfile();
    }

    private static class MySingleConfigurableEditor
    extends SingleConfigurableEditor {
        private final InspectionManagerEx myManager;

        public MySingleConfigurableEditor(Project project2, ErrorsConfigurable configurable, InspectionManagerEx manager) {
            super(project2, (Configurable)configurable, MySingleConfigurableEditor.createDimensionKey(configurable));
            this.myManager = manager;
        }

        @Override
        protected void doOKAction() {
            Object o = ((ErrorsConfigurable)this.getConfigurable()).getSelectedObject();
            if (o instanceof InspectionProfile) {
                this.myManager.setProfile(((InspectionProfile)o).getName());
            }
            super.doOKAction();
        }
    }

    private static class AdditionalPanel {
        public ComboboxWithBrowseButton myBrowseProfilesCombo;
        public JPanel myAdditionalPanel;

        private AdditionalPanel() {
            this.$$$setupUI$$$();
        }

        private void createUIComponents() {
            this.myBrowseProfilesCombo = new ComboboxWithBrowseButton((JComboBox)((Object)new SchemesCombo<InspectionProfileImpl>(){

                @Override
                protected boolean supportsProjectSchemes() {
                    return true;
                }

                @Override
                protected boolean isProjectScheme(@NotNull InspectionProfileImpl profile2) {
                    return profile2.isProjectLevel();
                }

                @Override
                @NotNull
                protected SimpleTextAttributes getSchemeAttributes(InspectionProfileImpl profile2) {
                    return SimpleTextAttributes.REGULAR_ATTRIBUTES;
                }
            }));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            this.createUIComponents();
            this.myAdditionalPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
            jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.action.profile.label"), (int)0, (int)0, null, null));
            ComboboxWithBrowseButton comboboxWithBrowseButton = this.myBrowseProfilesCombo;
            jPanel2.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
            ButtonGroup buttonGroup2 = new ButtonGroup();
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myAdditionalPanel;
        }
    }

    protected static class ExternalProfilesComboboxAwareInspectionToolsConfigurable
    extends InspectionToolsConfigurable {
        private final SchemesCombo<InspectionProfileImpl> myProfilesCombo;
        private String mySelectedName;
        private boolean mySelectedIsProjectProfile;

        public ExternalProfilesComboboxAwareInspectionToolsConfigurable(@NotNull ProjectInspectionProfileManager projectProfileManager, SchemesCombo<InspectionProfileImpl> profilesCombo) {
            super(projectProfileManager);
            this.myProfilesCombo = profilesCombo;
        }

        @Override
        protected InspectionProfileImpl getCurrentProfile() {
            return this.myProfilesCombo.getSelectedScheme();
        }

        @Override
        protected void applyRootProfile(@NotNull String name, boolean isProjectLevel) {
            this.mySelectedName = name;
            this.mySelectedIsProjectProfile = isProjectLevel;
        }
    }
}

