/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceImplementsWithStaticImportAction
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(ReplaceImplementsWithStaticImportAction.class);
    @NonNls
    private static final String FIND_CONSTANT_FIELD_USAGES = "Find Constant Field Usages...";

    @NotNull
    public String getText() {
        return "Replace implements with static import";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiElement parent;
        if (!(file2 instanceof PsiJavaFile)) {
            return false;
        }
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        if (element instanceof PsiIdentifier && (parent = element.getParent()) instanceof PsiClass) {
            return ReplaceImplementsWithStaticImportAction.isEmptyClass(project2, (PsiClass)parent) && DirectClassInheritorsSearch.search((PsiClass)((PsiClass)parent)).findFirst() != null;
        }
        PsiReference psiReference = TargetElementUtil.findReference(editor);
        if (psiReference == null) {
            return false;
        }
        PsiReferenceList referenceList = (PsiReferenceList)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiReferenceList.class);
        if (referenceList == null) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceList, PsiClass.class);
        if (psiClass == null) {
            return false;
        }
        if (psiClass.getExtendsList() != referenceList && psiClass.getImplementsList() != referenceList) {
            return false;
        }
        PsiElement target = psiReference.resolve();
        if (target == null || !(target instanceof PsiClass)) {
            return false;
        }
        return ReplaceImplementsWithStaticImportAction.isEmptyClass(project2, (PsiClass)target);
    }

    private static boolean isEmptyClass(Project project2, PsiClass targetClass) {
        if (!targetClass.isInterface()) {
            return false;
        }
        PsiReferenceList extendsList = targetClass.getExtendsList();
        if (extendsList != null && extendsList.getReferencedTypes().length > 0) {
            ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(Arrays.asList(targetClass.getAllMethods()));
            PsiClass objectClass = JavaPsiFacade.getInstance((Project)project2).findClass("java.lang.Object", GlobalSearchScope.allScope((Project)project2));
            if (objectClass == null) {
                return false;
            }
            methods.removeAll(Arrays.asList(objectClass.getMethods()));
            if (!methods.isEmpty()) {
                return false;
            }
        } else if (targetClass.getMethods().length > 0) {
            return false;
        }
        return targetClass.getAllFields().length > 0;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiClass targetClass;
        int offset = editor.getCaretModel().getOffset();
        PsiReference psiReference = TargetElementUtil.findReference(editor);
        if (psiReference != null) {
            PsiElement element = psiReference.getElement();
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            LOG.assertTrue(psiClass != null);
            PsiElement target = psiReference.resolve();
            LOG.assertTrue(target instanceof PsiClass);
            targetClass = (PsiClass)target;
        } else {
            PsiElement identifier = file2.findElementAt(offset);
            LOG.assertTrue(identifier instanceof PsiIdentifier);
            PsiElement element = identifier.getParent();
            LOG.assertTrue(element instanceof PsiClass);
            targetClass = (PsiClass)element;
        }
        HashMap refs = new HashMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            for (PsiField field : targetClass.getAllFields()) {
                PsiClass containingClass = field.getContainingClass();
                for (PsiReference reference : ReferencesSearch.search((PsiElement)field)) {
                    HashSet<PsiReference> fieldsRefs;
                    PsiFile psiFile;
                    if (reference == null) continue;
                    PsiElement refElement = reference.getElement();
                    if (ReplaceImplementsWithStaticImportAction.encodeQualifier(containingClass, reference, targetClass) || !((psiFile = refElement.getContainingFile()) instanceof PsiJavaFile)) continue;
                    HashMap<PsiField, HashSet<PsiReference>> references = (HashMap<PsiField, HashSet<PsiReference>>)refs.get(psiFile);
                    if (references == null) {
                        references = new HashMap<PsiField, HashSet<PsiReference>>();
                        refs.put(psiFile, references);
                    }
                    if ((fieldsRefs = (HashSet<PsiReference>)references.get(field)) == null) {
                        fieldsRefs = new HashSet<PsiReference>();
                        references.put(field, fieldsRefs);
                    }
                    fieldsRefs.add(reference);
                }
            }
        }), FIND_CONSTANT_FIELD_USAGES, true, project2)) {
            return;
        }
        HashSet refs2Unimplement = new HashSet();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            for (PsiClass psiClass : DirectClassInheritorsSearch.search((PsiClass)targetClass)) {
                PsiFile containingFile = psiClass.getContainingFile();
                if (!refs.containsKey(containingFile)) {
                    refs.put(containingFile, new HashMap());
                }
                if (ReplaceImplementsWithStaticImportAction.collectExtendsImplements(targetClass, psiClass.getExtendsList(), refs2Unimplement)) continue;
                ReplaceImplementsWithStaticImportAction.collectExtendsImplements(targetClass, psiClass.getImplementsList(), refs2Unimplement);
            }
        }), "Find References in Implement/Extends Lists...", true, project2)) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(refs.keySet())) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (PsiFile psiFile : refs.keySet()) {
                Map map2 = (Map)refs.get(psiFile);
                for (PsiField psiField : map2.keySet()) {
                    PsiClass containingClass = psiField.getContainingClass();
                    String fieldName = psiField.getName();
                    for (PsiReference reference : (Set)map2.get(psiField)) {
                        ReplaceImplementsWithStaticImportAction.bindReference(psiFile, psiField, containingClass, fieldName, reference, project2);
                    }
                }
            }
            for (PsiJavaCodeReferenceElement referenceElement : refs2Unimplement) {
                referenceElement.delete();
            }
        });
        HashMap redundant = new HashMap();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            for (PsiFile psiFile : refs.keySet()) {
                PsiImportList prepared;
                if (!(psiFile instanceof PsiJavaFile) || (prepared = codeStyleManager.prepareOptimizeImportsResult((PsiJavaFile)psiFile)) == null) continue;
                redundant.put((PsiJavaFile)psiFile, prepared);
            }
        }), "Optimize Imports...", true, project2)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (PsiJavaFile file1 : redundant.keySet()) {
                PsiImportList list;
                PsiImportList importList = (PsiImportList)redundant.get(file1);
                if (importList == null || (list = file1.getImportList()) == null) continue;
                list.replace((PsiElement)importList);
            }
        });
    }

    private static boolean encodeQualifier(PsiClass containingClass, PsiReference reference, PsiClass targetClass) {
        PsiElement qualifier;
        if (reference instanceof PsiReferenceExpression && (qualifier = ((PsiReferenceExpression)reference).getQualifier()) != null) {
            PsiElement resolved;
            if (qualifier instanceof PsiReferenceExpression && ((resolved = ((PsiReferenceExpression)qualifier).resolve()) == containingClass || resolved instanceof PsiClass && InheritanceUtil.isInheritorOrSelf((PsiClass)targetClass, (PsiClass)((PsiClass)resolved), (boolean)true))) {
                return true;
            }
            qualifier.putCopyableUserData(ChangeContextUtil.CAN_REMOVE_QUALIFIER_KEY, (Object)ChangeContextUtil.canRemoveQualifier((PsiReferenceExpression)reference));
        }
        return false;
    }

    private static void bindReference(PsiFile psiFile, PsiField psiField, PsiClass containingClass, String fieldName, PsiReference reference, Project project2) {
        if (reference instanceof PsiReferenceExpression) {
            PsiReferenceExpressionImpl.bindToElementViaStaticImport(containingClass, fieldName, ((PsiJavaFile)psiFile).getImportList());
            PsiElement qualifier = ((PsiReferenceExpression)reference).getQualifier();
            if (qualifier != null) {
                Boolean canRemoveQualifier = (Boolean)qualifier.getCopyableUserData(ChangeContextUtil.CAN_REMOVE_QUALIFIER_KEY);
                if (canRemoveQualifier != null && canRemoveQualifier.booleanValue()) {
                    qualifier.delete();
                } else {
                    PsiReferenceExpression classReferenceElement = JavaPsiFacade.getElementFactory((Project)project2).createReferenceExpression(containingClass);
                    qualifier.replace((PsiElement)classReferenceElement);
                }
            }
        } else if (reference.getElement() instanceof PsiDocMethodOrFieldRef) {
            reference.bindToElement((PsiElement)psiField);
        }
    }

    private static boolean collectExtendsImplements(PsiClass targetClass, PsiReferenceList referenceList, Set<PsiJavaCodeReferenceElement> refs) {
        if (referenceList != null) {
            for (PsiJavaCodeReferenceElement referenceElement : referenceList.getReferenceElements()) {
                if (referenceElement.resolve() != targetClass) continue;
                refs.add(referenceElement);
                return true;
            }
        }
        return false;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

