/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunInspectionIntention
implements IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(RunInspectionIntention.class);
    private final String myShortName;

    public RunInspectionIntention(HighlightDisplayKey key2) {
        this.myShortName = key2.toString();
    }

    @NotNull
    public String getText() {
        return InspectionsBundle.message((String)"run.inspection.on.file.intention.text", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return LocalInspectionToolWrapper.findTool2RunInBatch(project2, (PsiElement)file2, this.myShortName) != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        Module module2 = file2 != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)file2) : null;
        AnalysisScope analysisScope = new AnalysisScope(project2);
        if (file2 != null) {
            VirtualFile virtualFile = file2.getVirtualFile();
            if (file2.isPhysical() && virtualFile != null && virtualFile.isInLocalFileSystem()) {
                analysisScope = new AnalysisScope(file2);
            }
        }
        RunInspectionIntention.selectScopeAndRunInspection(this.myShortName, analysisScope, module2, (PsiElement)file2, project2);
    }

    public static void selectScopeAndRunInspection(@NotNull String toolShortName, @NotNull AnalysisScope customScope, @Nullable Module module2, @Nullable PsiElement context, @NotNull Project project2) {
        BaseAnalysisActionDialog dlg = new BaseAnalysisActionDialog(AnalysisScopeBundle.message((String)"specify.analysis.scope", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.title", (Object[])new Object[0])}), AnalysisScopeBundle.message((String)"analysis.scope.title", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0])}), project2, customScope, module2 != null ? module2.getName() : null, true, AnalysisUIOptions.getInstance(project2), context);
        if (!dlg.showAndGet()) {
            return;
        }
        AnalysisUIOptions uiOptions = AnalysisUIOptions.getInstance(project2);
        customScope = dlg.getScope(uiOptions, customScope, project2, module2);
        InspectionToolWrapper wrapper = LocalInspectionToolWrapper.findTool2RunInBatch(project2, context, toolShortName);
        LOG.assertTrue(wrapper != null, (Object)("Can't find tool with name = \"" + toolShortName + "\""));
        RunInspectionIntention.rerunInspection(wrapper, (InspectionManagerEx)InspectionManager.getInstance((Project)project2), customScope, context);
    }

    public static void rerunInspection(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, @NotNull AnalysisScope scope, @Nullable PsiElement psiElement) {
        GlobalInspectionContextImpl inspectionContext = RunInspectionIntention.createContext(toolWrapper, managerEx, psiElement);
        inspectionContext.doInspections(scope);
    }

    @NotNull
    public static GlobalInspectionContextImpl createContext(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, @Nullable PsiElement psiElement) {
        InspectionProfileImpl model = RunInspectionIntention.createProfile(toolWrapper, managerEx, psiElement);
        GlobalInspectionContextImpl inspectionContext = managerEx.createNewGlobalContext(false);
        inspectionContext.setExternalProfile(model);
        return inspectionContext;
    }

    @NotNull
    public static InspectionProfileImpl createProfile(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, @Nullable PsiElement psiElement) {
        InspectionProfileImpl rootProfile = InspectionProfileManager.getInstance().getCurrentProfile();
        LinkedHashSet allWrappers = new LinkedHashSet();
        allWrappers.add(toolWrapper);
        rootProfile.collectDependentInspections(toolWrapper, allWrappers, managerEx.getProject());
        List<Object> toolWrappers = allWrappers.size() == 1 ? Collections.singletonList(allWrappers.iterator().next()) : new ArrayList(allWrappers);
        InspectionProfileImpl model = InspectionProfileKt.createSimple(toolWrapper.getDisplayName(), managerEx.getProject(), toolWrappers);
        try {
            Element element = new Element("toCopy");
            for (InspectionToolWrapper inspectionToolWrapper : toolWrappers) {
                inspectionToolWrapper.getTool().writeSettings(element);
                InspectionToolWrapper tw = psiElement == null ? model.getInspectionTool(inspectionToolWrapper.getShortName(), managerEx.getProject()) : model.getInspectionTool(inspectionToolWrapper.getShortName(), psiElement);
                tw.getTool().readSettings(element);
            }
        }
        catch (InvalidDataException | WriteExternalException throwable) {
            // empty catch block
        }
        model.setSingleTool(toolWrapper.getShortName());
        return model;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

