/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bulkOperation;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.bulkOperation.BulkMethodInfo;
import com.intellij.codeInspection.bulkOperation.BulkMethodInfoProvider;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.IteratorDeclaration;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.IndexedContainer;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UseBulkOperationInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Pattern FOR_EACH_METHOD = Pattern.compile("forEach(Ordered)?");
    public boolean USE_ARRAYS_AS_LIST = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionsBundle.message((String)"inspection.replace.with.bulk.wrap.arrays", (Object[])new Object[0]), (InspectionProfileEntry)this, "USE_ARRAYS_AS_LIST");
    }

    @Nullable
    private static BulkMethodInfo findInfo(PsiReferenceExpression ref) {
        return StreamEx.of((Object[])BulkMethodInfoProvider.KEY.getExtensions()).flatMap(BulkMethodInfoProvider::consumers).findFirst(info -> info.isMyMethod(ref)).orElse(null);
    }

    @Nullable
    private static PsiExpression findIterable(PsiMethodCallExpression expression2) {
        PsiExpression[] args = expression2.getArgumentList().getExpressions();
        if (args.length != 1) {
            return null;
        }
        PsiExpression arg = args[0];
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiLambdaExpression) {
            return UseBulkOperationInspection.findIterableForLambda((PsiLambdaExpression)parent, arg);
        }
        if (parent instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)parent;
            if (expressionStatement.getParent() instanceof PsiCodeBlock) {
                PsiCodeBlock codeBlock = (PsiCodeBlock)expressionStatement.getParent();
                PsiStatement[] statements = codeBlock.getStatements();
                if (codeBlock.getParent() instanceof PsiBlockStatement) {
                    PsiBlockStatement blockStatement = (PsiBlockStatement)codeBlock.getParent();
                    if (statements.length == 1) {
                        return UseBulkOperationInspection.findIterableForSingleStatement((PsiStatement)blockStatement, arg);
                    }
                    PsiElement blockParent = blockStatement.getParent();
                    if (statements.length == 2 && statements[1] == parent && blockParent instanceof PsiLoopStatement) {
                        PsiLocalVariable var;
                        PsiElement[] elements;
                        IteratorDeclaration declaration2 = IteratorDeclaration.fromLoop((PsiLoopStatement)blockParent);
                        if (declaration2 != null && ExpressionUtils.isReferenceTo(arg, declaration2.getNextElementVariable(statements[0]))) {
                            return declaration2.getIterable();
                        }
                        if (blockParent instanceof PsiForStatement && statements[0] instanceof PsiDeclarationStatement && (elements = ((PsiDeclarationStatement)statements[0]).getDeclaredElements()).length == 1 && elements[0] instanceof PsiLocalVariable && ExpressionUtils.isReferenceTo(arg, (PsiVariable)(var = (PsiLocalVariable)elements[0]))) {
                            return UseBulkOperationInspection.findIterableForIndexedLoop((PsiForStatement)blockParent, var.getInitializer());
                        }
                    }
                } else if (codeBlock.getParent() instanceof PsiLambdaExpression && statements.length == 1) {
                    return UseBulkOperationInspection.findIterableForLambda((PsiLambdaExpression)codeBlock.getParent(), arg);
                }
            } else {
                return UseBulkOperationInspection.findIterableForSingleStatement((PsiStatement)expressionStatement, arg);
            }
        }
        return null;
    }

    @Nullable
    private static PsiExpression findIterableForLambda(PsiLambdaExpression lambda2, PsiExpression arg) {
        PsiParameterList parameters2 = lambda2.getParameterList();
        if (parameters2.getParametersCount() != 1) {
            return null;
        }
        PsiParameter parameter = parameters2.getParameters()[0];
        if (ExpressionUtils.isReferenceTo(arg, (PsiVariable)parameter)) {
            return UseBulkOperationInspection.findIterableForFunction((PsiFunctionalExpression)lambda2);
        }
        return null;
    }

    @Nullable
    private static PsiExpression findIterableForSingleStatement(PsiStatement statement2, PsiExpression arg) {
        IteratorDeclaration declaration2;
        PsiForeachStatement foreachStatement;
        PsiElement parent = statement2.getParent();
        if (parent instanceof PsiForeachStatement && ExpressionUtils.isReferenceTo(arg, (PsiVariable)(foreachStatement = (PsiForeachStatement)parent).getIterationParameter())) {
            return foreachStatement.getIteratedValue();
        }
        if (parent instanceof PsiLoopStatement && (declaration2 = IteratorDeclaration.fromLoop((PsiLoopStatement)parent)) != null && declaration2.isIteratorMethodCall((PsiElement)arg, "next")) {
            return declaration2.getIterable();
        }
        if (parent instanceof PsiForStatement) {
            return UseBulkOperationInspection.findIterableForIndexedLoop((PsiForStatement)parent, arg);
        }
        return null;
    }

    @Nullable
    private static PsiExpression findIterableForIndexedLoop(PsiForStatement loop, PsiExpression getElementExpression) {
        CountingLoop countingLoop = CountingLoop.from(loop);
        if (countingLoop == null || countingLoop.isIncluding() || !ExpressionUtils.isZero(countingLoop.getInitializer())) {
            return null;
        }
        IndexedContainer container = IndexedContainer.fromLengthExpression(countingLoop.getBound());
        if (container == null) {
            return null;
        }
        PsiExpression index = container.extractIndexFromGetExpression(getElementExpression);
        if (!ExpressionUtils.isReferenceTo(index, (PsiVariable)countingLoop.getCounter())) {
            return null;
        }
        return container.getQualifier();
    }

    @Nullable
    private static PsiExpression findIterableForFunction(PsiFunctionalExpression function) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)function.getParent());
        if (parent instanceof PsiTypeCastExpression) {
            parent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
        }
        if (!(parent instanceof PsiExpressionList)) {
            return null;
        }
        PsiExpression[] args = ((PsiExpressionList)parent).getExpressions();
        if (args.length != 1) {
            return null;
        }
        if (!((parent = parent.getParent()) instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression parentCall = (PsiMethodCallExpression)parent;
        PsiExpression parentQualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)parentCall.getMethodExpression().getQualifierExpression());
        if (MethodCallUtils.isCallToMethod(parentCall, "java.lang.Iterable", null, "forEach", new PsiType[]{null})) {
            return ExpressionUtils.getQualifierOrThis(parentCall.getMethodExpression());
        }
        if (MethodCallUtils.isCallToMethod(parentCall, "java.util.stream.Stream", null, FOR_EACH_METHOD, new PsiType[]{null}) && parentQualifier instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression grandParentCall = (PsiMethodCallExpression)parentQualifier;
            if (MethodCallUtils.isCallToMethod(grandParentCall, "java.util.Collection", null, "stream", PsiType.EMPTY_ARRAY)) {
                return ExpressionUtils.getQualifierOrThis(grandParentCall.getMethodExpression());
            }
            PsiExpression[] grandParentArgs = grandParentCall.getArgumentList().getExpressions();
            if (grandParentArgs.length == 1) {
                PsiType type2;
                PsiExpression maybeArray = grandParentArgs[0];
                if (MethodCallUtils.isCallToStaticMethod(grandParentCall, "java.util.Arrays", "stream", 1)) {
                    return maybeArray;
                }
                if (MethodCallUtils.isCallToStaticMethod(grandParentCall, "java.util.stream.Stream", "of", 1) && (type2 = maybeArray.getType()) instanceof PsiArrayType) {
                    return maybeArray;
                }
            }
        }
        return null;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                super.visitMethodCallExpression(call);
                BulkMethodInfo info = UseBulkOperationInspection.findInfo(call.getMethodExpression());
                if (info == null) {
                    return;
                }
                PsiExpression iterable = UseBulkOperationInspection.findIterable(call);
                if (iterable != null) {
                    this.register(iterable, info, call.getMethodExpression());
                }
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression methodReference) {
                super.visitMethodReferenceExpression(methodReference);
                BulkMethodInfo info = UseBulkOperationInspection.findInfo((PsiReferenceExpression)methodReference);
                if (info == null) {
                    return;
                }
                PsiExpression iterable = UseBulkOperationInspection.findIterableForFunction((PsiFunctionalExpression)methodReference);
                if (iterable != null) {
                    this.register(iterable, info, (PsiReferenceExpression)methodReference);
                }
            }

            private void register(@NotNull PsiExpression iterable, @NotNull BulkMethodInfo info, @NotNull PsiReferenceExpression methodExpression) {
                PsiMethod method2;
                PsiExpression qualifier = ExpressionUtils.getQualifierOrThis(methodExpression);
                if (qualifier instanceof PsiThisExpression && (method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)iterable, PsiMethod.class)) != null && method2.getName().equals(info.getBulkName())) {
                    return;
                }
                if (this.isSupportedQualifier(qualifier) && info.isSupportedIterable(qualifier, iterable, UseBulkOperationInspection.this.USE_ARRAYS_AS_LIST)) {
                    holder.registerProblem((PsiElement)methodExpression, InspectionsBundle.message((String)"inspection.replace.with.bulk.message", (Object[])new Object[]{info.getReplacementName()}), new LocalQuickFix[]{new UseBulkOperationFix(info)});
                }
            }

            @Contract(value="null -> false")
            private boolean isSupportedQualifier(PsiExpression qualifier) {
                if (qualifier instanceof PsiThisExpression) {
                    return true;
                }
                if (qualifier instanceof PsiReferenceExpression) {
                    PsiExpression subQualifier = ((PsiReferenceExpression)qualifier).getQualifierExpression();
                    return subQualifier == null || this.isSupportedQualifier(subQualifier);
                }
                return false;
            }
        };
    }

    private static class UseBulkOperationFix
    implements LocalQuickFix {
        private BulkMethodInfo myInfo;

        public UseBulkOperationFix(BulkMethodInfo info) {
            this.myInfo = info;
        }

        @Nls
        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"inspection.replace.with.bulk.fix.name", (Object[])new Object[]{this.myInfo.getReplacementName()});
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.replace.with.bulk.fix.family.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiLoopStatement loop;
            PsiElement parent;
            PsiExpression iterable;
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiReferenceExpression)) {
                return;
            }
            PsiExpression qualifier = ExpressionUtils.getQualifierOrThis((PsiReferenceExpression)element);
            if (element instanceof PsiMethodReferenceExpression) {
                iterable = UseBulkOperationInspection.findIterableForFunction((PsiFunctionalExpression)element);
            } else {
                parent = element.getParent();
                if (!(parent instanceof PsiMethodCallExpression)) {
                    return;
                }
                iterable = UseBulkOperationInspection.findIterable((PsiMethodCallExpression)parent);
            }
            if (iterable == null) {
                return;
            }
            parent = RefactoringUtil.getParentStatement((PsiElement)iterable, false);
            if (parent == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            PsiType type2 = iterable.getType();
            String iterableText = ct.text((PsiElement)iterable);
            if (type2 instanceof PsiArrayType) {
                iterableText = "java.util.Arrays.asList(" + iterableText + ")";
            }
            if (parent instanceof PsiDeclarationStatement && (loop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLoopStatement.class)) != null && loop.getParent() == parent.getParent()) {
                ct.delete((PsiElement)loop);
            }
            PsiElement result2 = ct.replaceAndRestoreComments(parent, ct.text((PsiElement)qualifier) + "." + this.myInfo.getBulkName() + "(" + iterableText + ")" + (parent instanceof PsiStatement ? ";" : ""));
            result2 = JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(result2);
            CodeStyleManager.getInstance((Project)project2).reformat(result2);
        }
    }
}

