/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.Bytes;
import com.intellij.codeInspection.bytecodeAnalysis.CombinedAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.HEquations;
import com.intellij.codeInspection.bytecodeAnalysis.InOutAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import com.intellij.codeInspection.bytecodeAnalysis.KeyedMethodVisitor;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import com.intellij.codeInspection.bytecodeAnalysis.NegationAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NegationAnalysisFailure;
import com.intellij.codeInspection.bytecodeAnalysis.NonNullInAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NullableInAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NullableMethodAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.PResults;
import com.intellij.codeInspection.bytecodeAnalysis.PendingAction;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.PurityAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.DFSTree;
import com.intellij.codeInspection.bytecodeAnalysis.asm.LeakingParameters;
import com.intellij.codeInspection.bytecodeAnalysis.asm.OriginsAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.VirtualFileGist;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

public class ClassDataIndexer
implements VirtualFileGist.GistCalculator<Map<Bytes, HEquations>> {
    public static final Final FINAL_TOP = new Final(Value.Top);
    public static final Final FINAL_BOT = new Final(Value.Bot);
    public static final Final FINAL_NOT_NULL = new Final(Value.NotNull);
    public static final Final FINAL_NULL = new Final(Value.Null);

    @Nullable
    public Map<Bytes, HEquations> calcData(@NotNull Project project2, @NotNull VirtualFile file2) {
        HashMap<Bytes, HEquations> map2 = new HashMap<Bytes, HEquations>();
        try {
            MessageDigest md = BytecodeAnalysisConverter.getMessageDigest();
            Map<Key, List<Equation>> allEquations = ClassDataIndexer.processClass(new ClassReader(file2.contentsToByteArray(false)), file2.getPresentableUrl());
            for (Map.Entry<Key, List<Equation>> entry : allEquations.entrySet()) {
                Key methodKey = entry.getKey();
                map2.put(ClassDataIndexer.compressKey(md, methodKey), ClassDataIndexer.convertEquations(md, methodKey, entry.getValue()));
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during indexing of bytecode", e);
        }
        return map2;
    }

    @NotNull
    static Bytes compressKey(MessageDigest md, Key methodKey) {
        return new Bytes(BytecodeAnalysisConverter.asmKey((Key)methodKey, (MessageDigest)md).key);
    }

    @NotNull
    private static HEquations convertEquations(MessageDigest md, Key methodKey, List<Equation> rawMethodEquations) {
        List compressedMethodEquations = ContainerUtil.map(rawMethodEquations, equation -> BytecodeAnalysisConverter.convert(equation, md));
        return new HEquations(compressedMethodEquations, methodKey.stable);
    }

    public static Map<Key, List<Equation>> processClass(ClassReader classReader, final String presentableUrl) {
        final State[] sharedPendingStates = new State[30000];
        final PendingAction[] sharedPendingActions = new PendingAction[30000];
        final PResults.PResult[] sharedResults = new PResults.PResult[30000];
        final HashMap<Key, List<Equation>> equations = new HashMap<Key, List<Equation>>();
        classReader.accept((ClassVisitor)new KeyedMethodVisitor(){

            @Override
            protected MethodVisitor visitMethod(final MethodNode node, final Key key2) {
                return new MethodVisitor(393216, (MethodVisitor)node){
                    private boolean jsr;

                    public void visitJumpInsn(int opcode, Label label) {
                        if (opcode == 168) {
                            this.jsr = true;
                        }
                        super.visitJumpInsn(opcode, label);
                    }

                    public void visitEnd() {
                        super.visitEnd();
                        equations.put(key2, this.processMethod(node, this.jsr, key2.method, key2.stable));
                    }
                };
            }

            private List<Equation> processMethod(MethodNode methodNode, boolean jsr, Method method2, boolean stable) {
                ProgressManager.checkCanceled();
                Type[] argumentTypes = Type.getArgumentTypes((String)methodNode.desc);
                Type resultType = Type.getReturnType((String)methodNode.desc);
                boolean isReferenceResult = ASMUtils.isReferenceType(resultType);
                boolean isBooleanResult = ASMUtils.isBooleanType(resultType);
                boolean isInterestingResult = isReferenceResult || isBooleanResult;
                ArrayList<Equation> equations2 = new ArrayList<Equation>(argumentTypes.length * 4 + 3);
                equations2.add(PurityAnalysis.analyze(method2, methodNode, stable));
                if (argumentTypes.length == 0 && !isInterestingResult) {
                    return equations2;
                }
                try {
                    ControlFlowGraph graph = ControlFlowGraph.build(this.className, methodNode, jsr);
                    if (graph.transitions.length > 0) {
                        boolean branching;
                        DFSTree dfs = DFSTree.build(graph.transitions, graph.edgeCount);
                        boolean bl = branching = !dfs.back.isEmpty();
                        if (!branching) {
                            for (int[] transition : graph.transitions) {
                                if (transition == null || transition.length <= 1) continue;
                                branching = true;
                                break;
                            }
                        }
                        if (branching) {
                            RichControlFlow richControlFlow = new RichControlFlow(graph, dfs);
                            if (richControlFlow.reducible()) {
                                NegationAnalysis negated = this.tryNegation(method2, argumentTypes, graph, isBooleanResult, dfs, jsr);
                                this.processBranchingMethod(method2, methodNode, richControlFlow, argumentTypes, isReferenceResult, isBooleanResult, stable, jsr, equations2, negated);
                                return equations2;
                            }
                            ProjectBytecodeAnalysis.LOG.debug(method2 + ": CFG is not reducible");
                        } else {
                            this.processNonBranchingMethod(method2, argumentTypes, graph, isReferenceResult, isBooleanResult, stable, equations2);
                            return equations2;
                        }
                    }
                    return this.topEquations(method2, argumentTypes, isReferenceResult, isInterestingResult, stable);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during processing of " + method2 + " in " + presentableUrl, e);
                    return this.topEquations(method2, argumentTypes, isReferenceResult, isInterestingResult, stable);
                }
            }

            private NegationAnalysis tryNegation(final Method method2, final Type[] argumentTypes, final ControlFlowGraph graph, boolean isBooleanResult, DFSTree dfs, final boolean jsr) throws AnalyzerException {
                Util util;
                class Util {
                    Util() {
                    }

                    boolean isMethodCall(int opCode) {
                        return opCode == 184 || opCode == 183 || opCode == 182 || opCode == 185;
                    }

                    boolean singleIfBranch() {
                        int branch = 0;
                        for (int i2 = 0; i2 < graph.transitions.length; ++i2) {
                            int[] transition = graph.transitions[i2];
                            if (transition.length == 2) {
                                boolean isIfInsn;
                                ++branch;
                                int opCode = graph.methodNode.instructions.get(i2).getOpcode();
                                boolean bl = isIfInsn = opCode == 153 || opCode == 154;
                                if (!isIfInsn) {
                                    return false;
                                }
                            }
                            if (branch <= 1) continue;
                            return false;
                        }
                        return branch == 1;
                    }

                    boolean singleMethodCall() {
                        int callCount = 0;
                        for (int i2 = 0; i2 < graph.transitions.length; ++i2) {
                            if (!this.isMethodCall(graph.methodNode.instructions.get(i2).getOpcode()) || ++callCount <= 1) continue;
                            return false;
                        }
                        return callCount == 1;
                    }

                    public boolean booleanConstResult() {
                        try {
                            boolean[] origins = OriginsAnalysis.resultOrigins((this).leakingParametersAndFrames((Method)method2, (MethodNode)graph.methodNode, (Type[])argumentTypes, (boolean)jsr).frames, graph.methodNode.instructions, graph);
                            for (int i2 = 0; i2 < origins.length; ++i2) {
                                boolean isBooleanConst;
                                if (!origins[i2]) continue;
                                int opCode = graph.methodNode.instructions.get(i2).getOpcode();
                                boolean bl = isBooleanConst = opCode == 3 || opCode == 4;
                                if (isBooleanConst) continue;
                                return false;
                            }
                            return true;
                        }
                        catch (AnalyzerException analyzerException) {
                            return false;
                        }
                    }
                }
                if (graph.methodNode.instructions.size() < 20 && isBooleanResult && dfs.back.isEmpty() && !jsr && (util = new Util()).singleIfBranch() && util.singleMethodCall() && util.booleanConstResult()) {
                    NegationAnalysis analyzer = new NegationAnalysis(method2, graph);
                    try {
                        analyzer.analyze();
                        return analyzer;
                    }
                    catch (NegationAnalysisFailure ignore) {
                        return null;
                    }
                }
                return null;
            }

            private void processBranchingMethod(Method method2, MethodNode methodNode, RichControlFlow richControlFlow, Type[] argumentTypes, boolean isReferenceResult, boolean isBooleanResult, boolean stable, boolean jsr, List<Equation> result2, NegationAnalysis negatedAnalysis) throws AnalyzerException {
                boolean withCycle;
                Equation outEquation;
                boolean isInterestingResult;
                boolean maybeLeakingParameter = isInterestingResult = isBooleanResult || isReferenceResult;
                for (Type argType : argumentTypes) {
                    if (!ASMUtils.isReferenceType(argType)) continue;
                    maybeLeakingParameter = true;
                    break;
                }
                LeakingParameters leakingParametersAndFrames = maybeLeakingParameter ? this.leakingParametersAndFrames(method2, methodNode, argumentTypes, jsr) : null;
                boolean[] leakingParameters = leakingParametersAndFrames != null ? leakingParametersAndFrames.parameters : null;
                boolean[] leakingNullableParameters = leakingParametersAndFrames != null ? leakingParametersAndFrames.nullableParameters : null;
                boolean[] origins = isInterestingResult ? OriginsAnalysis.resultOrigins(leakingParametersAndFrames.frames, methodNode.instructions, richControlFlow.controlFlow) : null;
                Equation equation = outEquation = isInterestingResult ? new InOutAnalysis(richControlFlow, Direction.Out, origins, stable, sharedPendingStates).analyze() : null;
                if (isReferenceResult) {
                    result2.add(outEquation);
                    result2.add(new Equation(new Key(method2, Direction.NullableOut, stable), NullableMethodAnalysis.analyze(methodNode, origins, jsr)));
                }
                boolean bl = withCycle = !richControlFlow.dfsTree.back.isEmpty();
                if (argumentTypes.length > 50 && withCycle) {
                    return;
                }
                for (int i2 = 0; i2 < argumentTypes.length; ++i2) {
                    boolean notNullParam = false;
                    if (!ASMUtils.isReferenceType(argumentTypes[i2])) continue;
                    boolean possibleNPE = false;
                    if (leakingParameters[i2]) {
                        NonNullInAnalysis notNullInAnalysis = new NonNullInAnalysis(richControlFlow, new Direction.In(i2, 0), stable, sharedPendingActions, sharedResults);
                        Equation notNullParamEquation = notNullInAnalysis.analyze();
                        possibleNPE = notNullInAnalysis.possibleNPE;
                        notNullParam = notNullParamEquation.rhs.equals(FINAL_NOT_NULL);
                        result2.add(notNullParamEquation);
                    } else {
                        result2.add(new Equation(new Key(method2, new Direction.In(i2, 0), stable), FINAL_TOP));
                    }
                    if (leakingNullableParameters[i2]) {
                        if (notNullParam || possibleNPE) {
                            result2.add(new Equation(new Key(method2, new Direction.In(i2, 1), stable), FINAL_TOP));
                        } else {
                            result2.add(new NullableInAnalysis(richControlFlow, new Direction.In(i2, 1), stable, sharedPendingStates).analyze());
                        }
                    } else {
                        result2.add(new Equation(new Key(method2, new Direction.In(i2, 1), stable), FINAL_NULL));
                    }
                    if (!isInterestingResult) continue;
                    if (leakingParameters[i2]) {
                        if (notNullParam) {
                            result2.add(new Equation(new Key(method2, new Direction.InOut(i2, Value.Null), stable), FINAL_BOT));
                        } else if (isBooleanResult && negatedAnalysis != null) {
                            result2.add(negatedAnalysis.contractEquation(i2, Value.Null, stable));
                        } else {
                            result2.add(new InOutAnalysis(richControlFlow, new Direction.InOut(i2, Value.Null), origins, stable, sharedPendingStates).analyze());
                        }
                        if (isBooleanResult && negatedAnalysis != null) {
                            result2.add(negatedAnalysis.contractEquation(i2, Value.NotNull, stable));
                            continue;
                        }
                        result2.add(new InOutAnalysis(richControlFlow, new Direction.InOut(i2, Value.NotNull), origins, stable, sharedPendingStates).analyze());
                        continue;
                    }
                    result2.add(new Equation(new Key(method2, new Direction.InOut(i2, Value.Null), stable), outEquation.rhs));
                    result2.add(new Equation(new Key(method2, new Direction.InOut(i2, Value.NotNull), stable), outEquation.rhs));
                }
            }

            private void processNonBranchingMethod(Method method2, Type[] argumentTypes, ControlFlowGraph graph, boolean isReferenceResult, boolean isBooleanResult, boolean stable, List<Equation> result2) throws AnalyzerException {
                CombinedAnalysis analyzer = new CombinedAnalysis(method2, graph);
                analyzer.analyze();
                if (isReferenceResult) {
                    result2.add(analyzer.outContractEquation(stable));
                    result2.add(analyzer.nullableResultEquation(stable));
                }
                for (int i2 = 0; i2 < argumentTypes.length; ++i2) {
                    Type argType = argumentTypes[i2];
                    if (!ASMUtils.isReferenceType(argType)) continue;
                    result2.add(analyzer.notNullParamEquation(i2, stable));
                    result2.add(analyzer.nullableParamEquation(i2, stable));
                    if (!isReferenceResult && !isBooleanResult) continue;
                    result2.add(analyzer.contractEquation(i2, Value.Null, stable));
                    result2.add(analyzer.contractEquation(i2, Value.NotNull, stable));
                }
            }

            private List<Equation> topEquations(Method method2, Type[] argumentTypes, boolean isReferenceResult, boolean isInterestingResult, boolean stable) {
                ArrayList<Equation> result2 = new ArrayList<Equation>(argumentTypes.length * 4 + 2);
                if (isReferenceResult) {
                    result2.add(new Equation(new Key(method2, Direction.Out, stable), FINAL_TOP));
                    result2.add(new Equation(new Key(method2, Direction.NullableOut, stable), FINAL_BOT));
                }
                for (int i2 = 0; i2 < argumentTypes.length; ++i2) {
                    if (!ASMUtils.isReferenceType(argumentTypes[i2])) continue;
                    result2.add(new Equation(new Key(method2, new Direction.In(i2, 0), stable), FINAL_TOP));
                    result2.add(new Equation(new Key(method2, new Direction.In(i2, 1), stable), FINAL_TOP));
                    if (!isInterestingResult) continue;
                    result2.add(new Equation(new Key(method2, new Direction.InOut(i2, Value.Null), stable), FINAL_TOP));
                    result2.add(new Equation(new Key(method2, new Direction.InOut(i2, Value.NotNull), stable), FINAL_TOP));
                }
                return result2;
            }

            @NotNull
            private LeakingParameters leakingParametersAndFrames(Method method2, MethodNode methodNode, Type[] argumentTypes, boolean jsr) throws AnalyzerException {
                return argumentTypes.length < 32 ? LeakingParameters.buildFast(method2.internalClassName, methodNode, jsr) : LeakingParameters.build(method2.internalClassName, methodNode, jsr);
            }
        }, 6);
        return equations;
    }
}

