/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Method;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

interface CombinedData {
    public static final BasicValue ThisValue = new BasicValue(Type.getObjectType((String)"java/lang/Object"));

    public static final class TrackableValue
    extends BasicValue
    implements Trackable {
        private final int originInsnIndex;

        public TrackableValue(int originInsnIndex, Type type2) {
            super(type2);
            this.originInsnIndex = originInsnIndex;
        }

        @Override
        public int getOriginInsnIndex() {
            return this.originInsnIndex;
        }
    }

    public static final class TrackableNullValue
    extends BasicValue
    implements Trackable {
        static final Type NullType = Type.getObjectType((String)"null");
        private final int originInsnIndex;

        public TrackableNullValue(int originInsnIndex) {
            super(NullType);
            this.originInsnIndex = originInsnIndex;
        }

        @Override
        public int getOriginInsnIndex() {
            return this.originInsnIndex;
        }
    }

    public static final class NthParamValue
    extends BasicValue {
        final int n;

        public NthParamValue(Type type2, int n) {
            super(type2);
            this.n = n;
        }
    }

    public static final class TrackableCallValue
    extends BasicValue
    implements Trackable {
        private final int originInsnIndex;
        final Method method;
        final List<? extends BasicValue> args;
        final boolean stableCall;
        final boolean thisCall;

        TrackableCallValue(int originInsnIndex, Type tp, Method method2, List<? extends BasicValue> args, boolean stableCall, boolean thisCall) {
            super(tp);
            this.originInsnIndex = originInsnIndex;
            this.method = method2;
            this.args = args;
            this.stableCall = stableCall;
            this.thisCall = thisCall;
        }

        @Override
        public int getOriginInsnIndex() {
            return this.originInsnIndex;
        }
    }

    public static interface Trackable {
        public int getOriginInsnIndex();
    }

    public static final class ParamKey {
        final Method method;
        final int i;
        final boolean stable;

        ParamKey(Method method2, int i2, boolean stable) {
            this.method = method2;
            this.i = i2;
            this.stable = stable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParamKey paramKey = (ParamKey)o;
            if (this.i != paramKey.i) {
                return false;
            }
            if (this.stable != paramKey.stable) {
                return false;
            }
            return this.method.equals(paramKey.method);
        }

        public int hashCode() {
            int result2 = this.method.hashCode();
            result2 = 31 * result2 + this.i;
            result2 = 31 * result2 + (this.stable ? 1 : 0);
            return result2;
        }
    }
}

