/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.Analysis;
import com.intellij.codeInspection.bytecodeAnalysis.Conf;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.InOutInterpreter;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Product;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.ResultUtil;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import com.intellij.openapi.progress.ProgressManager;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

class InOutAnalysis
extends Analysis<Result> {
    static final ResultUtil resultUtil = new ResultUtil(new ELattice<Value>(Value.Bot, Value.Top));
    private final State[] pending;
    private final InOutInterpreter interpreter;
    private final Value inValue;
    private final int generalizeShift;
    private Result internalResult;
    private int id;
    private int pendingTop;

    protected InOutAnalysis(RichControlFlow richControlFlow, Direction direction, boolean[] resultOrigins, boolean stable, State[] pending) {
        super(richControlFlow, direction, stable);
        this.pending = pending;
        this.interpreter = new InOutInterpreter(direction, richControlFlow.controlFlow.methodNode.instructions, resultOrigins);
        this.inValue = direction instanceof Direction.InOut ? ((Direction.InOut)direction).inValue : null;
        this.generalizeShift = (this.methodNode.access & 8) == 0 ? 1 : 0;
        this.internalResult = new Final(Value.Bot);
    }

    @NotNull
    Equation mkEquation(Result res) {
        return new Equation(this.aKey, res);
    }

    @Override
    @NotNull
    protected Equation analyze() throws AnalyzerException {
        this.pendingPush(this.createStartState());
        int steps = 0;
        while (this.pendingTop > 0 && this.earlyResult == null) {
            if (++steps >= 30000) {
                throw new AnalyzerException(null, "limit is reached, steps: " + steps + " in method " + this.method);
            }
            if (steps % 128 == 0) {
                ProgressManager.checkCanceled();
            }
            State state = this.pending[--this.pendingTop];
            int insnIndex = state.conf.insnIndex;
            Conf conf = state.conf;
            List<Conf> history = state.history;
            boolean fold = false;
            if (this.dfsTree.loopEnters[insnIndex]) {
                for (Conf prev : history) {
                    if (!AbstractValues.isInstance(conf, prev)) continue;
                    fold = true;
                    break;
                }
            }
            if (fold) {
                this.addComputed(insnIndex, state);
                continue;
            }
            State baseState = null;
            List thisComputed = this.computed[insnIndex];
            if (thisComputed != null) {
                for (State prevState : thisComputed) {
                    if (!InOutAnalysis.stateEquiv(state, prevState)) continue;
                    baseState = prevState;
                    break;
                }
            }
            if (baseState != null) continue;
            this.processState(state);
        }
        if (this.earlyResult != null) {
            return this.mkEquation((Result)this.earlyResult);
        }
        return this.mkEquation(this.internalResult);
    }

    void processState(State state) throws AnalyzerException {
        Conf preConf = state.conf;
        int insnIndex = preConf.insnIndex;
        boolean loopEnter = this.dfsTree.loopEnters[insnIndex];
        Conf conf = loopEnter ? this.generalize(preConf) : preConf;
        List<Conf> history = state.history;
        boolean taken = state.taken;
        Frame<BasicValue> frame = conf.frame;
        AbstractInsnNode insnNode = this.methodNode.instructions.get(insnIndex);
        List<Conf> nextHistory = loopEnter ? InOutAnalysis.append(history, conf) : history;
        Frame nextFrame = this.execute(frame, insnNode);
        this.addComputed(insnIndex, state);
        if (this.interpreter.deReferenced) {
            return;
        }
        int opcode = insnNode.getOpcode();
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                Result subResult;
                BasicValue stackTop = InOutAnalysis.popValue(frame);
                if (AbstractValues.FalseValue == stackTop) {
                    subResult = new Final(Value.False);
                } else if (AbstractValues.TrueValue == stackTop) {
                    subResult = new Final(Value.True);
                } else if (AbstractValues.NullValue == stackTop) {
                    subResult = new Final(Value.Null);
                } else if (stackTop instanceof AbstractValues.NotNullValue) {
                    subResult = new Final(Value.NotNull);
                } else if (stackTop instanceof AbstractValues.ParamValue) {
                    subResult = new Final(this.inValue);
                } else if (stackTop instanceof AbstractValues.CallResultValue) {
                    Set<Key> keys = ((AbstractValues.CallResultValue)stackTop).inters;
                    subResult = new Pending(Collections.singleton(new Product(Value.Top, keys)));
                } else {
                    this.earlyResult = new Final(Value.Top);
                    return;
                }
                this.internalResult = resultUtil.join(this.internalResult, subResult);
                if (this.internalResult instanceof Final && ((Final)this.internalResult).value == Value.Top) {
                    this.earlyResult = this.internalResult;
                }
                return;
            }
            case 191: {
                return;
            }
        }
        if (opcode == 199 && InOutAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
            int nextInsnIndex = this.inValue == Value.Null ? insnIndex + 1 : this.methodNode.instructions.indexOf((AbstractInsnNode)((JumpInsnNode)insnNode).label);
            State nextState = new State(++this.id, new Conf(nextInsnIndex, nextFrame), nextHistory, true, false);
            this.pendingPush(nextState);
            return;
        }
        if (opcode == 198 && InOutAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
            int nextInsnIndex = this.inValue == Value.NotNull ? insnIndex + 1 : this.methodNode.instructions.indexOf((AbstractInsnNode)((JumpInsnNode)insnNode).label);
            State nextState = new State(++this.id, new Conf(nextInsnIndex, nextFrame), nextHistory, true, false);
            this.pendingPush(nextState);
            return;
        }
        if (opcode == 153 && InOutAnalysis.popValue(frame) == AbstractValues.InstanceOfCheckValue && this.inValue == Value.Null) {
            int nextInsnIndex = this.methodNode.instructions.indexOf((AbstractInsnNode)((JumpInsnNode)insnNode).label);
            State nextState = new State(++this.id, new Conf(nextInsnIndex, nextFrame), nextHistory, true, false);
            this.pendingPush(nextState);
            return;
        }
        if (opcode == 154 && InOutAnalysis.popValue(frame) == AbstractValues.InstanceOfCheckValue && this.inValue == Value.Null) {
            int nextInsnIndex = insnIndex + 1;
            State nextState = new State(++this.id, new Conf(nextInsnIndex, nextFrame), nextHistory, true, false);
            this.pendingPush(nextState);
            return;
        }
        for (int nextInsnIndex : this.controlFlow.transitions[insnIndex]) {
            Frame nextFrame1 = nextFrame;
            if (this.controlFlow.errors[nextInsnIndex] && this.controlFlow.errorTransitions.contains(new ControlFlowGraph.Edge(insnIndex, nextInsnIndex))) {
                nextFrame1 = new Frame(frame);
                nextFrame1.clearStack();
                nextFrame1.push((org.jetbrains.org.objectweb.asm.tree.analysis.Value)ASMUtils.THROWABLE_VALUE);
            }
            this.pendingPush(new State(++this.id, new Conf(nextInsnIndex, (Frame<BasicValue>)nextFrame1), nextHistory, taken, false));
        }
    }

    private void pendingPush(State st) throws AnalyzerException {
        if (this.pendingTop >= 30000) {
            throw new AnalyzerException(null, "limit is reached in method " + this.method);
        }
        this.pending[this.pendingTop++] = st;
    }

    private Frame<BasicValue> execute(Frame<BasicValue> frame, AbstractInsnNode insnNode) throws AnalyzerException {
        this.interpreter.deReferenced = false;
        switch (insnNode.getType()) {
            case 8: 
            case 14: 
            case 15: {
                return frame;
            }
        }
        Frame nextFrame = new Frame(frame);
        nextFrame.execute(insnNode, (Interpreter)this.interpreter);
        return nextFrame;
    }

    private Conf generalize(Conf conf) {
        Frame frame = new Frame(conf.frame);
        for (int i2 = this.generalizeShift; i2 < frame.getLocals(); ++i2) {
            BasicValue value2 = (BasicValue)frame.getLocal(i2);
            Class<?> valueClass = value2.getClass();
            if (valueClass == BasicValue.class || valueClass == AbstractValues.ParamValue.class) continue;
            frame.setLocal(i2, (org.jetbrains.org.objectweb.asm.tree.analysis.Value)new BasicValue(value2.getType()));
        }
        BasicValue[] stack = new BasicValue[frame.getStackSize()];
        for (int i3 = 0; i3 < frame.getStackSize(); ++i3) {
            stack[i3] = (BasicValue)frame.getStack(i3);
        }
        frame.clearStack();
        for (BasicValue value3 : stack) {
            Class<?> valueClass = value3.getClass();
            if (valueClass != BasicValue.class && valueClass != AbstractValues.ParamValue.class) {
                frame.push((org.jetbrains.org.objectweb.asm.tree.analysis.Value)new BasicValue(value3.getType()));
                continue;
            }
            frame.push((org.jetbrains.org.objectweb.asm.tree.analysis.Value)value3);
        }
        return new Conf(conf.insnIndex, (Frame<BasicValue>)frame);
    }
}

