/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.Analysis;
import com.intellij.codeInspection.bytecodeAnalysis.Conf;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Final;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import com.intellij.codeInspection.bytecodeAnalysis.MakeResult;
import com.intellij.codeInspection.bytecodeAnalysis.NotNullInterpreter;
import com.intellij.codeInspection.bytecodeAnalysis.PResults;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.PendingAction;
import com.intellij.codeInspection.bytecodeAnalysis.ProceedState;
import com.intellij.codeInspection.bytecodeAnalysis.Product;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

class NonNullInAnalysis
extends Analysis<PResults.PResult> {
    private final PendingAction[] pendingActions;
    private final PResults.PResult[] results;
    private final NotNullInterpreter interpreter = new NotNullInterpreter();
    boolean possibleNPE;
    private int id;
    private Frame<BasicValue> nextFrame;
    private PResults.PResult subResult;
    private int pendingTop;

    protected NonNullInAnalysis(RichControlFlow richControlFlow, Direction direction, boolean stable, PendingAction[] pendingActions, PResults.PResult[] results) {
        super(richControlFlow, direction, stable);
        this.pendingActions = pendingActions;
        this.results = results;
    }

    PResults.PResult combineResults(PResults.PResult delta, int[] subResults) throws AnalyzerException {
        PResults.PResult result2 = PResults.Identity;
        for (int subResult : subResults) {
            result2 = PResults.join(result2, this.results[subResult]);
        }
        return PResults.meet(delta, result2);
    }

    @NotNull
    Equation mkEquation(PResults.PResult result2) {
        if (PResults.Identity == result2 || PResults.Return == result2) {
            return new Equation(this.aKey, new Final(Value.Top));
        }
        if (PResults.NPE == result2) {
            return new Equation(this.aKey, new Final(Value.NotNull));
        }
        PResults.ConditionalNPE condNpe = (PResults.ConditionalNPE)result2;
        Set<Product> components = condNpe.sop.stream().map(prod -> new Product(Value.Top, (Set<Key>)prod)).collect(Collectors.toSet());
        return new Equation(this.aKey, new Pending(components));
    }

    @Override
    @NotNull
    protected Equation analyze() throws AnalyzerException {
        this.pendingPush(new ProceedState(this.createStartState()));
        int steps = 0;
        while (this.pendingTop > 0 && this.earlyResult == null) {
            PendingAction action;
            if (++steps >= 30000) {
                throw new AnalyzerException(null, "limit is reached, steps: " + steps + " in method " + this.method);
            }
            if ((action = this.pendingActions[--this.pendingTop]) instanceof MakeResult) {
                MakeResult makeResult = (MakeResult)action;
                PResults.PResult result2 = this.combineResults(makeResult.subResult, makeResult.indices);
                State state = makeResult.state;
                int insnIndex = state.conf.insnIndex;
                this.results[state.index] = result2;
                this.addComputed(insnIndex, state);
                continue;
            }
            if (!(action instanceof ProceedState)) continue;
            ProceedState proceedState = (ProceedState)action;
            State state = proceedState.state;
            int insnIndex = state.conf.insnIndex;
            Conf conf = state.conf;
            List<Conf> history = state.history;
            boolean fold = false;
            if (this.dfsTree.loopEnters[insnIndex]) {
                for (Conf prev : history) {
                    if (!AbstractValues.isInstance(conf, prev)) continue;
                    fold = true;
                    break;
                }
            }
            if (fold) {
                this.results[state.index] = PResults.Identity;
                this.addComputed(insnIndex, state);
                continue;
            }
            State baseState = null;
            List thisComputed = this.computed[insnIndex];
            if (thisComputed != null) {
                for (State prevState : thisComputed) {
                    if (!NonNullInAnalysis.stateEquiv(state, prevState)) continue;
                    baseState = prevState;
                    break;
                }
            }
            if (baseState != null) {
                this.results[state.index] = this.results[baseState.index];
                continue;
            }
            this.processState(state);
        }
        if (this.earlyResult != null) {
            return this.mkEquation((PResults.PResult)this.earlyResult);
        }
        return this.mkEquation(this.results[0]);
    }

    private void processState(State state) throws AnalyzerException {
        int i2;
        boolean notEmptySubResult;
        int stateIndex = state.index;
        Conf conf = state.conf;
        int insnIndex = conf.insnIndex;
        List<Conf> history = state.history;
        boolean taken = state.taken;
        Frame<BasicValue> frame = conf.frame;
        AbstractInsnNode insnNode = this.methodNode.instructions.get(insnIndex);
        List<Conf> nextHistory = this.dfsTree.loopEnters[insnIndex] ? NonNullInAnalysis.append(history, conf) : history;
        boolean hasCompanions = state.hasCompanions;
        this.execute(frame, insnNode);
        boolean bl = notEmptySubResult = this.subResult != PResults.Identity;
        if (this.subResult == PResults.NPE) {
            this.results[stateIndex] = PResults.NPE;
            this.possibleNPE = true;
            this.addComputed(insnIndex, state);
            return;
        }
        int opcode = insnNode.getOpcode();
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                if (!hasCompanions) {
                    this.earlyResult = PResults.Return;
                } else {
                    this.results[stateIndex] = PResults.Return;
                    this.addComputed(insnIndex, state);
                }
                return;
            }
        }
        if (opcode == 191) {
            if (taken) {
                this.results[stateIndex] = PResults.NPE;
                this.possibleNPE = true;
            } else {
                this.results[stateIndex] = PResults.Identity;
            }
            this.addComputed(insnIndex, state);
            return;
        }
        if (opcode == 199 && NonNullInAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
            int nextInsnIndex = insnIndex + 1;
            State nextState = new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, hasCompanions || notEmptySubResult);
            this.pendingPush(new MakeResult(state, this.subResult, new int[]{nextState.index}));
            this.pendingPush(new ProceedState(nextState));
            return;
        }
        if (opcode == 198 && NonNullInAnalysis.popValue(frame) instanceof AbstractValues.ParamValue) {
            int nextInsnIndex = this.methodNode.instructions.indexOf((AbstractInsnNode)((JumpInsnNode)insnNode).label);
            State nextState = new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, hasCompanions || notEmptySubResult);
            this.pendingPush(new MakeResult(state, this.subResult, new int[]{nextState.index}));
            this.pendingPush(new ProceedState(nextState));
            return;
        }
        if (opcode == 153 && NonNullInAnalysis.popValue(frame) == AbstractValues.InstanceOfCheckValue) {
            int nextInsnIndex = this.methodNode.instructions.indexOf((AbstractInsnNode)((JumpInsnNode)insnNode).label);
            State nextState = new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, hasCompanions || notEmptySubResult);
            this.pendingPush(new MakeResult(state, this.subResult, new int[]{nextState.index}));
            this.pendingPush(new ProceedState(nextState));
            return;
        }
        if (opcode == 154 && NonNullInAnalysis.popValue(frame) == AbstractValues.InstanceOfCheckValue) {
            int nextInsnIndex = insnIndex + 1;
            State nextState = new State(++this.id, new Conf(nextInsnIndex, this.nextFrame), nextHistory, true, hasCompanions || notEmptySubResult);
            this.pendingPush(new MakeResult(state, this.subResult, new int[]{nextState.index}));
            this.pendingPush(new ProceedState(nextState));
            return;
        }
        int[] nextInsnIndices = this.controlFlow.transitions[insnIndex];
        int[] subIndices = new int[nextInsnIndices.length];
        for (i2 = 0; i2 < nextInsnIndices.length; ++i2) {
            subIndices[i2] = ++this.id;
        }
        this.pendingPush(new MakeResult(state, this.subResult, subIndices));
        for (i2 = 0; i2 < nextInsnIndices.length; ++i2) {
            int nextInsnIndex = nextInsnIndices[i2];
            Frame nextFrame1 = this.nextFrame;
            if (this.controlFlow.errors[nextInsnIndex] && this.controlFlow.errorTransitions.contains(new ControlFlowGraph.Edge(insnIndex, nextInsnIndex))) {
                nextFrame1 = new Frame(frame);
                nextFrame1.clearStack();
                nextFrame1.push((org.jetbrains.org.objectweb.asm.tree.analysis.Value)ASMUtils.THROWABLE_VALUE);
            }
            this.pendingPush(new ProceedState(new State(subIndices[i2], new Conf(nextInsnIndex, nextFrame1), nextHistory, taken, hasCompanions || notEmptySubResult)));
        }
    }

    private void pendingPush(PendingAction action) throws AnalyzerException {
        if (this.pendingTop >= 30000) {
            throw new AnalyzerException(null, "limit is reached in method " + this.method);
        }
        this.pendingActions[this.pendingTop++] = action;
    }

    private void execute(Frame<BasicValue> frame, AbstractInsnNode insnNode) throws AnalyzerException {
        switch (insnNode.getType()) {
            case 8: 
            case 14: 
            case 15: {
                this.nextFrame = frame;
                this.subResult = PResults.Identity;
                break;
            }
            default: {
                this.nextFrame = new Frame(frame);
                this.interpreter.reset(false);
                this.nextFrame.execute(insnNode, (Interpreter)this.interpreter);
                this.subResult = this.interpreter.getSubResult();
            }
        }
    }
}

