/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisConverter;
import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisIndex;
import com.intellij.codeInspection.bytecodeAnalysis.Bytes;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.EquationsLimitException;
import com.intellij.codeInspection.bytecodeAnalysis.HComponent;
import com.intellij.codeInspection.bytecodeAnalysis.HEffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.HEffects;
import com.intellij.codeInspection.bytecodeAnalysis.HEquation;
import com.intellij.codeInspection.bytecodeAnalysis.HEquations;
import com.intellij.codeInspection.bytecodeAnalysis.HKey;
import com.intellij.codeInspection.bytecodeAnalysis.HPending;
import com.intellij.codeInspection.bytecodeAnalysis.HResult;
import com.intellij.codeInspection.bytecodeAnalysis.MethodAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.ParameterAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.PuritySolver;
import com.intellij.codeInspection.bytecodeAnalysis.Solver;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectBytecodeAnalysis {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.bytecodeAnalysis");
    public static final Key<Boolean> INFERRED_ANNOTATION = Key.create((String)"INFERRED_ANNOTATION");
    public static final String NULLABLE_METHOD = "java.annotations.inference.nullable.method";
    public static final String NULLABLE_METHOD_TRANSITIVITY = "java.annotations.inference.nullable.method.transitivity";
    public static final int EQUATIONS_LIMIT = 1000;
    private final Project myProject;
    private final boolean nullableMethod;
    private final boolean nullableMethodTransitivity;
    private final Map<Bytes, List<HEquations>> myEquationCache = ContainerUtil.createConcurrentSoftValueMap();

    public static ProjectBytecodeAnalysis getInstance(@NotNull Project project2) {
        return (ProjectBytecodeAnalysis)ServiceManager.getService((Project)project2, ProjectBytecodeAnalysis.class);
    }

    public ProjectBytecodeAnalysis(Project project2) {
        this.myProject = project2;
        this.nullableMethod = Registry.is((String)NULLABLE_METHOD);
        this.nullableMethodTransitivity = Registry.is((String)NULLABLE_METHOD_TRANSITIVITY);
        this.myProject.getMessageBus().connect().subscribe(PsiModificationTracker.TOPIC, () -> this.myEquationCache.clear());
    }

    @Nullable
    public PsiAnnotation findInferredAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (!(listOwner instanceof PsiCompiledElement)) {
            return null;
        }
        if (annotationFQN.equals("org.jetbrains.annotations.NotNull") || annotationFQN.equals("org.jetbrains.annotations.Nullable") || annotationFQN.equals(ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT)) {
            PsiAnnotation[] annotations2;
            for (PsiAnnotation annotation : annotations2 = this.findInferredAnnotations(listOwner)) {
                if (!annotationFQN.equals(annotation.getQualifiedName())) continue;
                return annotation;
            }
            return null;
        }
        return null;
    }

    @NotNull
    public PsiAnnotation[] findInferredAnnotations(@NotNull PsiModifierListOwner listOwner) {
        if (!(listOwner instanceof PsiCompiledElement)) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        return (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)listOwner, () -> CachedValueProvider.Result.create((Object)this.collectInferredAnnotations(listOwner), (Object[])new Object[]{listOwner}));
    }

    private static boolean isInsideDummyAndroidJar(@Nullable PsiFile psiFile) {
        VirtualFile file2;
        VirtualFile virtualFile = file2 = psiFile == null ? null : psiFile.getVirtualFile();
        if (file2 == null) {
            return false;
        }
        String path = file2.getPath();
        int index = path.indexOf("/android.jar!/");
        return index > 0 && path.lastIndexOf("platforms/android-", index) > 0;
    }

    @NotNull
    private PsiAnnotation[] collectInferredAnnotations(PsiModifierListOwner listOwner) {
        if (ProjectBytecodeAnalysis.isInsideDummyAndroidJar(listOwner.getContainingFile())) {
            return PsiAnnotation.EMPTY_ARRAY;
        }
        try {
            MessageDigest md = BytecodeAnalysisConverter.getMessageDigest();
            HKey primaryKey = ProjectBytecodeAnalysis.getKey(listOwner, md);
            if (primaryKey == null) {
                return PsiAnnotation.EMPTY_ARRAY;
            }
            if (listOwner instanceof PsiMethod) {
                ArrayList<HKey> allKeys = ProjectBytecodeAnalysis.collectMethodKeys((PsiMethod)listOwner, primaryKey);
                MethodAnnotations methodAnnotations = this.loadMethodAnnotations((PsiMethod)listOwner, primaryKey, allKeys);
                return this.toPsi(primaryKey, methodAnnotations);
            }
            if (listOwner instanceof PsiParameter) {
                ParameterAnnotations parameterAnnotations = this.loadParameterAnnotations(primaryKey);
                return this.toPsi(parameterAnnotations);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        catch (EquationsLimitException e) {
            if (LOG.isDebugEnabled()) {
                String externalName = PsiFormatUtil.getExternalName((PsiModifierListOwner)listOwner, (boolean)false, (int)Integer.MAX_VALUE);
                LOG.debug("Too many equations for " + externalName);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Throwable)e);
            return PsiAnnotation.EMPTY_ARRAY;
        }
    }

    private PsiAnnotation[] toPsi(HKey primaryKey, MethodAnnotations methodAnnotations) {
        PsiAnnotation psiAnnotation;
        boolean notNull = methodAnnotations.notNulls.contains(primaryKey);
        boolean nullable = methodAnnotations.nullables.contains(primaryKey);
        boolean pure = methodAnnotations.pures.contains(primaryKey);
        String contractValues = methodAnnotations.contractsValues.get(primaryKey);
        String contractPsiText = null;
        if (contractValues != null) {
            contractPsiText = pure ? "value=" + contractValues + ",pure=true" : contractValues;
        } else if (pure) {
            contractPsiText = "pure=true";
        }
        PsiAnnotation psiAnnotation2 = psiAnnotation = contractPsiText == null ? null : this.createContractAnnotation(contractPsiText);
        if (notNull && psiAnnotation != null) {
            return new PsiAnnotation[]{this.getNotNullAnnotation(), psiAnnotation};
        }
        if (nullable && psiAnnotation != null) {
            return new PsiAnnotation[]{this.getNullableAnnotation(), psiAnnotation};
        }
        if (notNull) {
            return new PsiAnnotation[]{this.getNotNullAnnotation()};
        }
        if (nullable) {
            return new PsiAnnotation[]{this.getNullableAnnotation()};
        }
        if (psiAnnotation != null) {
            return new PsiAnnotation[]{psiAnnotation};
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    private PsiAnnotation[] toPsi(ParameterAnnotations parameterAnnotations) {
        if (parameterAnnotations.notNull) {
            return new PsiAnnotation[]{this.getNotNullAnnotation()};
        }
        if (parameterAnnotations.nullable) {
            return new PsiAnnotation[]{this.getNullableAnnotation()};
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    public PsiAnnotation getNotNullAnnotation() {
        return (PsiAnnotation)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)this.createAnnotationFromText("@org.jetbrains.annotations.NotNull"), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED}));
    }

    public PsiAnnotation getNullableAnnotation() {
        return (PsiAnnotation)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)this.createAnnotationFromText("@org.jetbrains.annotations.Nullable"), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED}));
    }

    public PsiAnnotation createContractAnnotation(String contractValue) {
        Map cache2 = (Map)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> {
            ConcurrentFactoryMap<String, PsiAnnotation> map2 = new ConcurrentFactoryMap<String, PsiAnnotation>(){

                @Nullable
                protected PsiAnnotation create(String attrs) {
                    return ProjectBytecodeAnalysis.this.createAnnotationFromText("@org.jetbrains.annotations.Contract(" + attrs + ")");
                }
            };
            return CachedValueProvider.Result.create((Object)map2, (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
        });
        return (PsiAnnotation)cache2.get(contractValue);
    }

    @Nullable
    public static HKey getKey(@NotNull PsiModifierListOwner owner, MessageDigest md) {
        PsiElement gParent;
        PsiElement parent;
        LOG.assertTrue(owner instanceof PsiCompiledElement, (Object)owner);
        if (owner instanceof PsiMethod) {
            return BytecodeAnalysisConverter.psiKey((PsiMethod)owner, Direction.Out, md);
        }
        if (owner instanceof PsiParameter && (parent = owner.getParent()) instanceof PsiParameterList && (gParent = parent.getParent()) instanceof PsiMethod) {
            int index = ((PsiParameterList)parent).getParameterIndex((PsiParameter)owner);
            return BytecodeAnalysisConverter.psiKey((PsiMethod)gParent, new Direction.In(index, 0), md);
        }
        return null;
    }

    public static ArrayList<HKey> collectMethodKeys(@NotNull PsiMethod method2, HKey primaryKey) {
        return BytecodeAnalysisConverter.mkInOutKeys(method2, primaryKey);
    }

    private ParameterAnnotations loadParameterAnnotations(@NotNull HKey notNullKey) throws EquationsLimitException {
        Solver notNullSolver = new Solver(new ELattice<Value>(Value.NotNull, Value.Top), Value.Top);
        this.collectEquations(Collections.singletonList(notNullKey), notNullSolver);
        Map<HKey, Value> notNullSolutions = notNullSolver.solve();
        boolean notNull = Value.NotNull == notNullSolutions.get(notNullKey) || Value.NotNull == notNullSolutions.get(notNullKey.mkUnstable());
        Solver nullableSolver = new Solver(new ELattice<Value>(Value.Null, Value.Top), Value.Top);
        HKey nullableKey = new HKey(notNullKey.key, notNullKey.dirKey + 1, true, false);
        this.collectEquations(Collections.singletonList(nullableKey), nullableSolver);
        Map<HKey, Value> nullableSolutions = nullableSolver.solve();
        boolean nullable = Value.Null == nullableSolutions.get(nullableKey) || Value.Null == nullableSolutions.get(nullableKey.mkUnstable());
        return new ParameterAnnotations(notNull, nullable);
    }

    private MethodAnnotations loadMethodAnnotations(@NotNull PsiMethod owner, @NotNull HKey key2, ArrayList<HKey> allKeys) throws EquationsLimitException {
        MethodAnnotations result2 = new MethodAnnotations();
        Solver outSolver = new Solver(new ELattice<Value>(Value.Bot, Value.Top), Value.Top);
        PuritySolver puritySolver = new PuritySolver();
        this.collectEquations(allKeys, outSolver);
        this.collectPurityEquations(key2.updateDirection(BytecodeAnalysisConverter.mkDirectionKey(Direction.Pure)), puritySolver);
        Map<HKey, Value> solutions = outSolver.solve();
        Map<HKey, Set<HEffectQuantum>> puritySolutions = puritySolver.solve();
        int arity = owner.getParameterList().getParameters().length;
        BytecodeAnalysisConverter.addMethodAnnotations(solutions, result2, key2, arity);
        BytecodeAnalysisConverter.addEffectAnnotations(puritySolutions, result2, key2, arity);
        if (this.nullableMethod) {
            Solver nullableMethodSolver = new Solver(new ELattice<Value>(Value.Bot, Value.Null), Value.Bot);
            HKey nullableKey = key2.updateDirection(BytecodeAnalysisConverter.mkDirectionKey(Direction.NullableOut));
            if (this.nullableMethodTransitivity) {
                this.collectEquations(Collections.singletonList(nullableKey), nullableMethodSolver);
            } else {
                this.collectSingleEquation(nullableKey, nullableMethodSolver);
            }
            Map<HKey, Value> nullableSolutions = nullableMethodSolver.solve();
            if (nullableSolutions.get(nullableKey) == Value.Null || nullableSolutions.get(nullableKey.invertStability()) == Value.Null) {
                result2.nullables.add(key2);
            }
        }
        return result2;
    }

    private List<HEquations> getEquations(Bytes key2) {
        List<HEquations> result2 = this.myEquationCache.get(key2);
        if (result2 == null) {
            result2 = BytecodeAnalysisIndex.getEquations(ProjectScope.getLibrariesScope((Project)this.myProject), key2);
            this.myEquationCache.put(key2, result2);
        }
        return result2;
    }

    private void collectPurityEquations(HKey key2, PuritySolver puritySolver) throws EquationsLimitException {
        HashSet<HKey> queued = new HashSet<HKey>();
        Stack queue = new Stack();
        queue.push((Object)key2);
        queued.add(key2);
        while (!queue.empty()) {
            if (queued.size() > 1000) {
                throw new EquationsLimitException();
            }
            ProgressManager.checkCanceled();
            HKey hKey = (HKey)queue.pop();
            Bytes bytes = new Bytes(hKey.key);
            for (HEquations hEquations : this.getEquations(bytes)) {
                boolean stable = hEquations.stable;
                for (DirectionResultPair pair : hEquations.results) {
                    int dirKey = pair.directionKey;
                    if (dirKey != hKey.dirKey) continue;
                    Set<HEffectQuantum> effects = ((HEffects)pair.hResult).effects;
                    puritySolver.addEquation(new HKey(bytes.bytes, dirKey, stable, false), effects);
                    for (HEffectQuantum effect : effects) {
                        HKey depKey;
                        if (!(effect instanceof HEffectQuantum.CallQuantum) || queued.contains(depKey = ((HEffectQuantum.CallQuantum)effect).key)) continue;
                        queue.push((Object)depKey);
                        queued.add(depKey);
                    }
                }
            }
        }
    }

    private void collectEquations(List<HKey> keys, Solver solver) throws EquationsLimitException {
        HashSet<HKey> queued = new HashSet<HKey>();
        Stack queue = new Stack();
        for (HKey key2 : keys) {
            queue.push((Object)key2);
            queued.add(key2);
        }
        while (!queue.empty()) {
            if (queued.size() > 1000) {
                throw new EquationsLimitException();
            }
            ProgressManager.checkCanceled();
            HKey hKey = (HKey)queue.pop();
            Bytes bytes = new Bytes(hKey.key);
            for (HEquations hEquations : this.getEquations(bytes)) {
                boolean stable = hEquations.stable;
                for (DirectionResultPair pair : hEquations.results) {
                    int dirKey = pair.directionKey;
                    if (dirKey != hKey.dirKey) continue;
                    HResult result2 = pair.hResult;
                    solver.addEquation(new HEquation(new HKey(bytes.bytes, dirKey, stable, false), result2));
                    if (!(result2 instanceof HPending)) continue;
                    HPending pending = (HPending)result2;
                    for (HComponent component : pending.delta) {
                        for (HKey depKey : component.ids) {
                            if (queued.contains(depKey)) continue;
                            queue.push((Object)depKey);
                            queued.add(depKey);
                        }
                    }
                }
            }
        }
    }

    private void collectSingleEquation(HKey hKey, Solver solver) throws EquationsLimitException {
        ProgressManager.checkCanceled();
        Bytes bytes = new Bytes(hKey.key);
        for (HEquations hEquations : this.getEquations(bytes)) {
            boolean stable = hEquations.stable;
            for (DirectionResultPair pair : hEquations.results) {
                int dirKey = pair.directionKey;
                if (dirKey != hKey.dirKey) continue;
                HResult result2 = pair.hResult;
                solver.addEquation(new HEquation(new HKey(bytes.bytes, dirKey, stable, false), result2));
            }
        }
    }

    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text) throws IncorrectOperationException {
        PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)this.myProject).createAnnotationFromText(text, null);
        annotation.putUserData(INFERRED_ANNOTATION, (Object)Boolean.TRUE);
        ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
        return annotation;
    }
}

