/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataInterpreter;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.HEffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.HardCodedPurity;
import com.intellij.codeInspection.bytecodeAnalysis.Key;
import com.intellij.codeInspection.bytecodeAnalysis.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

public class PurityAnalysis {
    static final Set<EffectQuantum> topEffect = Collections.singleton(EffectQuantum.TopEffectQuantum);
    static final Set<HEffectQuantum> topHEffect = Collections.singleton(HEffectQuantum.TopEffectQuantum);
    static final int UN_ANALYZABLE_FLAG = 1792;

    @NotNull
    public static Equation analyze(Method method2, MethodNode methodNode, boolean stable) {
        Key key2 = new Key(method2, Direction.Pure, stable);
        Set<EffectQuantum> hardCodedSolution = HardCodedPurity.getHardCodedSolution(key2);
        if (hardCodedSolution != null) {
            return new Equation(key2, new Effects(hardCodedSolution));
        }
        if ((methodNode.access & 0x700) != 0) {
            return new Equation(key2, new Effects(topEffect));
        }
        DataInterpreter dataInterpreter = new DataInterpreter(methodNode);
        try {
            new Analyzer((Interpreter)dataInterpreter).analyze("this", methodNode);
        }
        catch (AnalyzerException e) {
            return new Equation(key2, new Effects(topEffect));
        }
        EffectQuantum[] quanta = dataInterpreter.effects;
        HashSet<EffectQuantum> effects = new HashSet<EffectQuantum>();
        for (EffectQuantum effectQuantum : quanta) {
            if (effectQuantum == null) continue;
            if (effectQuantum == EffectQuantum.TopEffectQuantum) {
                return new Equation(key2, new Effects(topEffect));
            }
            effects.add(effectQuantum);
        }
        return new Equation(key2, new Effects(effects));
    }
}

