/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ParametersUsage;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ParamsValue;
import java.util.List;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

class LeakingParametersCollector
extends ParametersUsage {
    final boolean[] leaking;
    final boolean[] nullableLeaking;

    LeakingParametersCollector(MethodNode methodNode) {
        super(methodNode);
        this.leaking = new boolean[this.arity];
        this.nullableLeaking = new boolean[this.arity];
    }

    @Override
    public ParamsValue unaryOperation(AbstractInsnNode insn, ParamsValue value2) {
        switch (insn.getOpcode()) {
            case 153: 
            case 154: 
            case 172: 
            case 176: 
            case 180: 
            case 190: 
            case 193: 
            case 194: 
            case 198: 
            case 199: {
                boolean[] params = value2.params;
                for (int i2 = 0; i2 < this.arity; ++i2) {
                    int n = i2;
                    this.leaking[n] = this.leaking[n] | params[i2];
                }
                break;
            }
        }
        return super.unaryOperation(insn, value2);
    }

    @Override
    public ParamsValue binaryOperation(AbstractInsnNode insn, ParamsValue value1, ParamsValue value2) {
        switch (insn.getOpcode()) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                boolean[] params = value1.params;
                for (int i2 = 0; i2 < this.arity; ++i2) {
                    int n = i2;
                    this.leaking[n] = this.leaking[n] | params[i2];
                }
                break;
            }
            case 181: {
                int i3;
                boolean[] params = value1.params;
                for (i3 = 0; i3 < this.arity; ++i3) {
                    int n = i3;
                    this.leaking[n] = this.leaking[n] | params[i3];
                }
                params = value2.params;
                for (i3 = 0; i3 < this.arity; ++i3) {
                    int n = i3;
                    this.nullableLeaking[n] = this.nullableLeaking[n] | params[i3];
                }
                break;
            }
        }
        return super.binaryOperation(insn, value1, value2);
    }

    @Override
    public ParamsValue ternaryOperation(AbstractInsnNode insn, ParamsValue value1, ParamsValue value2, ParamsValue value3) {
        switch (insn.getOpcode()) {
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: {
                boolean[] params = value1.params;
                for (int i2 = 0; i2 < this.arity; ++i2) {
                    int n = i2;
                    this.leaking[n] = this.leaking[n] | params[i2];
                }
                break;
            }
            case 83: {
                int i3;
                boolean[] params = value1.params;
                for (i3 = 0; i3 < this.arity; ++i3) {
                    int n = i3;
                    this.leaking[n] = this.leaking[n] | params[i3];
                }
                params = value3.params;
                for (i3 = 0; i3 < this.arity; ++i3) {
                    int n = i3;
                    this.nullableLeaking[n] = this.nullableLeaking[n] | params[i3];
                }
                break;
            }
        }
        return null;
    }

    @Override
    public ParamsValue naryOperation(AbstractInsnNode insn, List<? extends ParamsValue> values) {
        switch (insn.getOpcode()) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                for (ParamsValue paramsValue : values) {
                    boolean[] params = paramsValue.params;
                    for (int i2 = 0; i2 < this.arity; ++i2) {
                        int n = i2;
                        this.leaking[n] = this.leaking[n] | params[i2];
                    }
                }
                break;
            }
        }
        return super.naryOperation(insn, (List)values);
    }
}

