/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class ContractChecker
extends DataFlowRunner {
    private final PsiMethod myMethod;
    private final MethodContract myContract;
    private final Set<PsiElement> myViolations = ContainerUtil.newHashSet();
    private final Set<PsiElement> myNonViolations = ContainerUtil.newHashSet();
    private final Set<PsiElement> myFailures = ContainerUtil.newHashSet();

    private ContractChecker(PsiMethod method2, MethodContract contract, boolean onTheFly) {
        super(false, true, onTheFly);
        this.myMethod = method2;
        this.myContract = contract;
    }

    static Map<PsiElement, String> checkContractClause(PsiMethod method2, MethodContract contract, boolean ignoreAssertions, boolean onTheFly) {
        PsiCodeBlock body2 = method2.getBody();
        if (body2 == null) {
            return Collections.emptyMap();
        }
        ContractChecker checker = new ContractChecker(method2, contract, onTheFly);
        PsiParameter[] parameters2 = method2.getParameterList().getParameters();
        DfaMemoryState initialState = checker.createMemoryState();
        DfaValueFactory factory = checker.getFactory();
        for (int i2 = 0; i2 < contract.arguments.length; ++i2) {
            MethodContract.ValueConstraint constraint = contract.arguments[i2];
            DfaConstValue comparisonValue = constraint.getComparisonValue(factory);
            if (comparisonValue == null) continue;
            boolean negated = constraint.shouldUseNonEqComparison();
            DfaVariableValue dfaParam = factory.getVarFactory().createVariableValue((PsiVariable)parameters2[i2], false);
            initialState.applyCondition(factory.getRelationFactory().createRelation(dfaParam, comparisonValue, JavaTokenType.EQEQ, negated));
        }
        checker.analyzeMethod((PsiElement)body2, new StandardInstructionVisitor(), ignoreAssertions, Arrays.asList(initialState));
        return checker.getErrors();
    }

    @Override
    @NotNull
    protected DfaInstructionState[] acceptInstruction(@NotNull InstructionVisitor visitor, @NotNull DfaInstructionState instructionState) {
        DfaMemoryState memState = instructionState.getMemoryState();
        if (memState.isEphemeral()) {
            return DfaInstructionState.EMPTY_ARRAY;
        }
        Instruction instruction = instructionState.getInstruction();
        if (instruction instanceof CheckReturnValueInstruction) {
            PsiElement anchor = ((CheckReturnValueInstruction)instruction).getReturn();
            DfaValue retValue = memState.pop();
            if (this.breaksContract(retValue, this.myContract.returnValue, memState)) {
                this.myViolations.add(anchor);
            } else {
                this.myNonViolations.add(anchor);
            }
            return InstructionVisitor.nextInstruction(instruction, this, memState);
        }
        if (instruction instanceof ReturnInstruction && ((ReturnInstruction)instruction).isViaException() && this.myContract.returnValue != MethodContract.ValueConstraint.NOT_NULL_VALUE) {
            ContainerUtil.addIfNotNull(this.myFailures, (Object)((ReturnInstruction)instruction).getAnchor());
        }
        if (instruction instanceof MethodCallInstruction && ((MethodCallInstruction)instruction).getMethodType() == MethodCallInstruction.MethodType.REGULAR_METHOD_CALL && this.myContract.returnValue == MethodContract.ValueConstraint.THROW_EXCEPTION) {
            ContainerUtil.addIfNotNull(this.myFailures, (Object)((MethodCallInstruction)instruction).getCallExpression());
            return DfaInstructionState.EMPTY_ARRAY;
        }
        if (instruction instanceof ConditionalGotoInstruction && memState.peek() == DfaUnknownValue.getInstance()) {
            return DfaInstructionState.EMPTY_ARRAY;
        }
        return super.acceptInstruction(visitor, instructionState);
    }

    private Map<PsiElement, String> getErrors() {
        HashMap errors = ContainerUtil.newHashMap();
        for (PsiElement element : this.myViolations) {
            if (this.myNonViolations.contains(element)) continue;
            errors.put(element, "Contract clause '" + this.myContract + "' is violated");
        }
        if (this.myContract.returnValue != MethodContract.ValueConstraint.THROW_EXCEPTION) {
            for (PsiElement element : this.myFailures) {
                errors.put(element, "Contract clause '" + this.myContract + "' is violated: exception might be thrown instead of returning " + (Object)((Object)this.myContract.returnValue));
            }
        } else if (this.myFailures.isEmpty() && errors.isEmpty()) {
            PsiIdentifier nameIdentifier = this.myMethod.getNameIdentifier();
            errors.put(nameIdentifier != null ? nameIdentifier : this.myMethod, "Contract clause '" + this.myContract + "' is violated: no exception is thrown");
        }
        return errors;
    }

    private boolean breaksContract(DfaValue retValue, MethodContract.ValueConstraint constraint, DfaMemoryState state) {
        switch (constraint) {
            case NULL_VALUE: {
                return state.isNotNull(retValue);
            }
            case NOT_NULL_VALUE: {
                return state.isNull(retValue);
            }
            case TRUE_VALUE: {
                return ContractChecker.isEquivalentTo(retValue, this.getFactory().getConstFactory().getFalse(), state);
            }
            case FALSE_VALUE: {
                return ContractChecker.isEquivalentTo(retValue, this.getFactory().getConstFactory().getTrue(), state);
            }
            case THROW_EXCEPTION: {
                return true;
            }
        }
        return false;
    }

    private static boolean isEquivalentTo(DfaValue val, DfaConstValue constValue, DfaMemoryState state) {
        return val == constValue || val instanceof DfaVariableValue && constValue == state.getConstantValue((DfaVariableValue)val);
    }
}

