/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.ContractInferenceInterpreter;
import com.intellij.codeInspection.dataFlow.MethodData;
import com.intellij.codeInspection.dataFlow.MethodDataExternalizer;
import com.intellij.codeInspection.dataFlow.NullityInference;
import com.intellij.codeInspection.dataFlow.NullityInferenceResult;
import com.intellij.codeInspection.dataFlow.PreContract;
import com.intellij.codeInspection.dataFlow.PurityInference;
import com.intellij.codeInspection.dataFlow.PurityInferenceResult;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.impl.source.JavaLightStubBuilder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.io.DataExternalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a4\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u001a\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u0016\u001a\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0016H\u0002\u001a,\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u000b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001a0\u001dH\u0002\"9\u0010\u0000\u001a-\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004 \u0005*\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"gist", "Lcom/intellij/util/gist/PsiFileGist;", "", "", "Lcom/intellij/codeInspection/dataFlow/MethodData;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "calcData", "tree", "Lcom/intellij/lang/LighterAST;", "method", "Lcom/intellij/lang/LighterASTNode;", "createData", "body", "contracts", "", "Lcom/intellij/codeInspection/dataFlow/PreContract;", "nullity", "Lcom/intellij/codeInspection/dataFlow/NullityInferenceResult;", "purity", "Lcom/intellij/codeInspection/dataFlow/PurityInferenceResult;", "getIndexedData", "Lcom/intellij/psi/impl/source/PsiMethodImpl;", "indexFile", "methodIndex", "walkMethodBody", "", "root", "processor", "Lkotlin/Function1;", "java-analysis-impl"})
public final class ContractInferenceIndexKt {
    private static final PsiFileGist<Map<Integer, MethodData>> gist = GistManager.getInstance().newPsiFileGist("contractInference", 1, (DataExternalizer)MethodDataExternalizer.INSTANCE, (NullableFunction)gist.1.INSTANCE);

    private static final Map<Integer, MethodData> indexFile(LighterAST tree) {
        HashMap result2 = new HashMap();
        RecursiveLighterASTNodeWalkingVisitor recursiveLighterASTNodeWalkingVisitor = new RecursiveLighterASTNodeWalkingVisitor(tree, result2, tree){
            private int methodIndex;
            final /* synthetic */ LighterAST $tree;
            final /* synthetic */ HashMap $result;

            public final int getMethodIndex() {
                return this.methodIndex;
            }

            public final void setMethodIndex(int n) {
                this.methodIndex = n;
            }

            public void visitNode(@NotNull LighterASTNode element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                if (element.getTokenType() == JavaElementType.METHOD) {
                    MethodData methodData = ContractInferenceIndexKt.access$calcData(this.$tree, element);
                    if (methodData != null) {
                        MethodData methodData2;
                        MethodData data = methodData2 = methodData;
                        Map map2 = this.$result;
                        Integer n = this.methodIndex;
                        MethodData methodData3 = data;
                        map2.put(n, methodData3);
                    }
                    int n = this.methodIndex;
                    this.methodIndex = n + 1;
                }
                if (JavaLightStubBuilder.isCodeBlockWithoutStubs(element)) {
                    return;
                }
                super.visitNode(element);
            }
            {
                this.$tree = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
        LighterASTNode lighterASTNode = tree.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)lighterASTNode, (String)"tree.root");
        recursiveLighterASTNodeWalkingVisitor.visitNode(lighterASTNode);
        return result2;
    }

    private static final MethodData calcData(LighterAST tree, LighterASTNode method2) {
        LighterASTNode lighterASTNode = LightTreeUtil.firstChildOfType(tree, method2, (IElementType)JavaElementType.CODE_BLOCK);
        if (lighterASTNode == null) {
            return null;
        }
        LighterASTNode body2 = lighterASTNode;
        List<LighterASTNode> statements = ContractInferenceInterpreter.getStatements(body2, tree);
        List<PreContract> contracts2 = new ContractInferenceInterpreter(tree, method2, body2).inferContracts(statements);
        NullityInference.NullityInferenceVisitor nullityVisitor = new NullityInference.NullityInferenceVisitor(tree, body2);
        PurityInference.PurityInferenceVisitor purityVisitor = new PurityInference.PurityInferenceVisitor(tree, body2);
        Iterator<LighterASTNode> iterator = statements.iterator();
        while (iterator.hasNext()) {
            LighterASTNode statement2;
            LighterASTNode lighterASTNode2 = statement2 = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)lighterASTNode2, (String)"statement");
            ContractInferenceIndexKt.walkMethodBody(tree, lighterASTNode2, (Function1<? super LighterASTNode, Unit>)((Function1)new Function1<LighterASTNode, Unit>(nullityVisitor, purityVisitor){
                final /* synthetic */ NullityInference.NullityInferenceVisitor $nullityVisitor;
                final /* synthetic */ PurityInference.PurityInferenceVisitor $purityVisitor;

                public final void invoke(@NotNull LighterASTNode it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.$nullityVisitor.visitNode(it);
                    this.$purityVisitor.visitNode(it);
                }
                {
                    this.$nullityVisitor = nullityInferenceVisitor;
                    this.$purityVisitor = purityInferenceVisitor;
                    super(1);
                }
            }));
        }
        LighterASTNode lighterASTNode3 = body2;
        Intrinsics.checkExpressionValueIsNotNull((Object)lighterASTNode3, (String)"body");
        List<PreContract> list = contracts2;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"contracts");
        return ContractInferenceIndexKt.createData(lighterASTNode3, list, nullityVisitor.getResult(), purityVisitor.getResult());
    }

    private static final void walkMethodBody(LighterAST tree, LighterASTNode root, Function1<? super LighterASTNode, Unit> processor2) {
        new RecursiveLighterASTNodeWalkingVisitor(processor2, tree, tree){
            final /* synthetic */ Function1 $processor;
            final /* synthetic */ LighterAST $tree;

            public void visitNode(@NotNull LighterASTNode element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                IElementType type2 = element.getTokenType();
                if (type2 == JavaElementType.CLASS || type2 == JavaElementType.FIELD || Intrinsics.areEqual((Object)type2, (Object)JavaElementType.METHOD) || Intrinsics.areEqual((Object)type2, (Object)JavaElementType.ANNOTATION_METHOD) || type2 == JavaElementType.LAMBDA_EXPRESSION) {
                    return;
                }
                this.$processor.invoke((Object)element);
                super.visitNode(element);
            }
            {
                this.$processor = $captured_local_variable$0;
                this.$tree = $captured_local_variable$1;
                super($super_call_param$2);
            }
        }.visitNode(root);
    }

    private static final MethodData createData(LighterASTNode body2, List<? extends PreContract> contracts2, NullityInferenceResult nullity2, PurityInferenceResult purity2) {
        Collection collection;
        if (nullity2 == null && purity2 == null && !(!(collection = (Collection)contracts2).isEmpty())) {
            return null;
        }
        return new MethodData(nullity2, purity2, contracts2, body2.getStartOffset(), body2.getEndOffset());
    }

    @Nullable
    public static final MethodData getIndexedData(@NotNull PsiMethodImpl method2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)method2), (String)"method");
        Map map2 = (Map)gist.getFileData(method2.getContainingFile());
        return map2 != null ? (MethodData)map2.get(ContractInferenceIndexKt.methodIndex(method2)) : null;
    }

    private static final int methodIndex(PsiMethodImpl method2) {
        StubElement it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        StubTree stubTree;
        PsiFile psiFile = method2.getContainingFile();
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
        }
        PsiFileImpl file2 = (PsiFileImpl)psiFile;
        try {
            StubTree stubTree2 = file2.getStubTree();
            if (stubTree2 == null) {
                stubTree2 = file2.calcStubTree();
            }
            stubTree = stubTree2;
        }
        catch (RuntimeException e) {
            throw (Throwable)new RuntimeException("While inferring contract for " + PsiUtil.getMemberQualifiedName((PsiMember)((PsiMember)method2)), e);
        }
        StubTree stubTree3 = stubTree;
        Iterable e = $receiver$iv = (Iterable)stubTree3.getPlainList();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (StubElement)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getStubType(), (Object)JavaElementType.METHOD)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (StubElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            PsiElement psiElement = it.getPsi();
            collection.add(psiElement);
        }
        return ((List)destination$iv$iv).indexOf((Object)method2);
    }

    @Nullable
    public static final /* synthetic */ MethodData access$calcData(@NotNull LighterAST tree, @NotNull LighterASTNode method2) {
        return ContractInferenceIndexKt.calcData(tree, method2);
    }

    @NotNull
    public static final /* synthetic */ Map access$indexFile(@NotNull LighterAST tree) {
        return ContractInferenceIndexKt.indexFile(tree);
    }
}

