/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.ContractChecker;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContractInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method2) {
                for (MethodContract contract : ControlFlowAnalyzer.getMethodContracts(method2)) {
                    Map<PsiElement, String> errors = ContractChecker.checkContractClause(method2, contract, false, isOnTheFly);
                    for (Map.Entry<PsiElement, String> entry : errors.entrySet()) {
                        PsiElement element = entry.getKey();
                        holder.registerProblem(element, entry.getValue(), new LocalQuickFix[0]);
                    }
                }
            }

            public void visitAnnotation(PsiAnnotation annotation) {
                String error;
                if (!ControlFlowAnalyzer.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotation.getQualifiedName())) {
                    return;
                }
                PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMethod.class);
                if (method2 == null) {
                    return;
                }
                String text = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, null);
                if (StringUtil.isNotEmpty((String)text) && (error = ContractInspection.checkContract(method2, text)) != null) {
                    PsiAnnotationMemberValue value2 = annotation.findAttributeValue(null);
                    assert (value2 != null);
                    holder.registerProblem((PsiElement)value2, error, new LocalQuickFix[0]);
                    return;
                }
                if (Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)annotation, (String)"pure")) && PsiType.VOID.equals((Object)method2.getReturnType())) {
                    PsiAnnotationMemberValue value3 = annotation.findDeclaredAttributeValue("pure");
                    assert (value3 != null);
                    holder.registerProblem((PsiElement)value3, "Pure methods must return something, void is not allowed as a return type", new LocalQuickFix[0]);
                }
            }
        };
    }

    @Nullable
    public static String checkContract(PsiMethod method2, String text) {
        List<MethodContract> contracts2;
        try {
            contracts2 = MethodContract.parseContract(text);
        }
        catch (MethodContract.ParseException e) {
            return e.getMessage();
        }
        int paramCount = method2.getParameterList().getParametersCount();
        for (int i2 = 0; i2 < contracts2.size(); ++i2) {
            MethodContract contract = contracts2.get(i2);
            if (contract.arguments.length != paramCount) {
                return "Method takes " + paramCount + " parameters, while contract clause number " + (i2 + 1) + " expects " + contract.arguments.length;
            }
            PsiType returnType = method2.getReturnType();
            if (returnType != null && !InferenceFromSourceUtil.isReturnTypeCompatible(returnType, contract.returnValue)) {
                return "Method returns " + returnType.getPresentableText() + " but the contract specifies " + (Object)((Object)contract.returnValue);
            }
            if (!method2.isConstructor() || contract.returnValue == MethodContract.ValueConstraint.THROW_EXCEPTION) continue;
            return "Invalid contract return value for a constructor: " + (Object)((Object)contract.returnValue);
        }
        return null;
    }
}

