/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.ExceptionTransfer;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.codeInspection.dataFlow.InstructionTransfer;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.LiveVariablesAnalyzer;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.ReturnTransfer;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.Trap;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.DupInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyStackInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FieldReferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.LambdaInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.NotInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.instructions.SwapInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.siyeh.ig.numeric.UnnecessaryExplicitNumericCastInspection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowAnalyzer
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer");
    public static final String ORG_JETBRAINS_ANNOTATIONS_CONTRACT = Contract.class.getName();
    private final PsiElement myCodeFragment;
    private boolean myIgnoreAssertions;
    private final Project myProject;
    private final DfaValueFactory myFactory;
    private ControlFlow myCurrentFlow;
    private FList<Trap> myTrapStack = FList.emptyList();
    private final ExceptionTransfer myRuntimeException;
    private final ExceptionTransfer myError;
    private final PsiType myAssertionError;

    ControlFlowAnalyzer(DfaValueFactory valueFactory, @NotNull PsiElement codeFragment, boolean ignoreAssertions) {
        this.myFactory = valueFactory;
        this.myCodeFragment = codeFragment;
        this.myProject = codeFragment.getProject();
        this.myIgnoreAssertions = ignoreAssertions;
        GlobalSearchScope scope = codeFragment.getResolveScope();
        this.myRuntimeException = new ExceptionTransfer(this.myFactory.createTypeValue((PsiType)this.createClassType(scope, "java.lang.RuntimeException"), Nullness.NOT_NULL));
        this.myError = new ExceptionTransfer(this.myFactory.createTypeValue((PsiType)this.createClassType(scope, "java.lang.Error"), Nullness.NOT_NULL));
        this.myAssertionError = this.createClassType(scope, "java.lang.AssertionError");
    }

    @Nullable
    public ControlFlow buildControlFlow() {
        this.myCurrentFlow = new ControlFlow(this.myFactory);
        try {
            this.myCodeFragment.accept((PsiElementVisitor)this);
        }
        catch (CannotAnalyzeException e) {
            return null;
        }
        PsiElement parent = this.myCodeFragment.getParent();
        if (parent instanceof PsiLambdaExpression && this.myCodeFragment instanceof PsiExpression) {
            this.generateBoxingUnboxingInstructionFor((PsiExpression)this.myCodeFragment, LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)parent)));
            this.addInstruction(new CheckReturnValueInstruction(this.myCodeFragment));
        }
        this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(ReturnTransfer.INSTANCE, (FList<Trap>)FList.emptyList()), null));
        if (Registry.is((String)"idea.dfa.live.variables.analysis")) {
            new LiveVariablesAnalyzer(this.myCurrentFlow, this.myFactory).flushDeadVariablesOnStatementFinish();
        }
        return this.myCurrentFlow;
    }

    private PsiClassType createClassType(GlobalSearchScope scope, String fqn) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(fqn, scope);
        if (aClass != null) {
            return JavaPsiFacade.getElementFactory((Project)this.myProject).createType(aClass);
        }
        return JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(fqn, scope);
    }

    private <T extends Instruction> T addInstruction(T i) {
        this.myCurrentFlow.addInstruction(i);
        return i;
    }

    private ControlFlow.ControlFlowOffset getEndOffset(PsiElement element) {
        return this.myCurrentFlow.getEndOffset(element);
    }

    private ControlFlow.ControlFlowOffset getStartOffset(PsiElement element) {
        return this.myCurrentFlow.getStartOffset(element);
    }

    private void startElement(PsiElement element) {
        this.myCurrentFlow.startElement(element);
    }

    private void finishElement(PsiElement element) {
        this.myCurrentFlow.finishElement(element);
        if (element instanceof PsiStatement && !(element instanceof PsiReturnStatement)) {
            this.addInstruction(new FinishElementInstruction(element));
        }
    }

    public void visitErrorElement(PsiErrorElement element) {
        throw new CannotAnalyzeException();
    }

    public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
        PsiExpression lExpr = expression2.getLExpression();
        PsiExpression rExpr = expression2.getRExpression();
        this.startElement((PsiElement)expression2);
        if (rExpr == null) {
            this.pushUnknown();
            this.finishElement((PsiElement)expression2);
            return;
        }
        IElementType op = expression2.getOperationTokenType();
        PsiType type2 = expression2.getType();
        boolean isBoolean = PsiType.BOOLEAN.equals((Object)type2);
        if (op == JavaTokenType.EQ) {
            lExpr.accept((PsiElementVisitor)this);
            rExpr.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(rExpr, type2);
        } else if (op == JavaTokenType.ANDEQ && isBoolean) {
            this.generateBooleanAssignmentExpression(true, lExpr, rExpr, type2);
        } else if (op == JavaTokenType.OREQ && isBoolean) {
            this.generateBooleanAssignmentExpression(false, lExpr, rExpr, type2);
        } else if (op == JavaTokenType.XOREQ && isBoolean) {
            this.generateXorExpression((PsiExpression)expression2, new PsiExpression[]{lExpr, rExpr}, type2, true);
        } else if (op == JavaTokenType.PLUSEQ && type2 != null && type2.equalsToText("java.lang.String")) {
            lExpr.accept((PsiElementVisitor)this);
            this.addInstruction(new DupInstruction());
            rExpr.accept((PsiElementVisitor)this);
            this.addInstruction(new BinopInstruction(JavaTokenType.PLUS, null, this.myProject));
        } else if (ControlFlowAnalyzer.isAssignmentDivision(op) && type2 != null && PsiType.LONG.isAssignableFrom(type2)) {
            lExpr.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(lExpr, type2);
            rExpr.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(rExpr, type2);
            this.checkZeroDivisor();
            this.addInstruction(new PopInstruction());
            this.pushUnknown();
        } else {
            this.generateDefaultAssignmentBinOp(lExpr, rExpr, type2);
        }
        this.addInstruction(new AssignInstruction(rExpr, this.myFactory.createValue(lExpr)));
        this.flushArrayElementsOnUnknownIndexAssignment(lExpr);
        this.finishElement((PsiElement)expression2);
    }

    private void flushArrayElementsOnUnknownIndexAssignment(PsiExpression lExpr) {
        DfaValue arrayVar;
        if (lExpr instanceof PsiArrayAccessExpression && !(this.myFactory.createValue(lExpr) instanceof DfaVariableValue) && (arrayVar = this.myFactory.createValue(((PsiArrayAccessExpression)lExpr).getArrayExpression())) instanceof DfaVariableValue) {
            this.addInstruction(new FlushVariableInstruction((DfaVariableValue)arrayVar, true));
        }
    }

    private void generateDefaultAssignmentBinOp(PsiExpression lExpr, PsiExpression rExpr, PsiType exprType) {
        lExpr.accept((PsiElementVisitor)this);
        this.addInstruction(new DupInstruction());
        this.generateBoxingUnboxingInstructionFor(lExpr, exprType);
        rExpr.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(rExpr, exprType);
        this.addInstruction(new BinopInstruction(null, null, this.myProject));
    }

    public void visitAssertStatement(PsiAssertStatement statement2) {
        if (this.myIgnoreAssertions) {
            return;
        }
        this.startElement((PsiElement)statement2);
        PsiExpression condition2 = statement2.getAssertCondition();
        PsiExpression description = statement2.getAssertDescription();
        if (condition2 != null) {
            condition2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
            this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement2), false, (PsiElement)condition2));
            if (description != null) {
                description.accept((PsiElementVisitor)this);
            }
            this.throwException(this.myAssertionError, (PsiElement)statement2);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitDeclarationStatement(PsiDeclarationStatement statement2) {
        PsiElement[] elements;
        this.startElement((PsiElement)statement2);
        for (PsiElement element : elements = statement2.getDeclaredElements()) {
            PsiVariable variable;
            PsiExpression initializer;
            if (element instanceof PsiClass) {
                this.addInstruction(new EmptyInstruction(element));
                continue;
            }
            if (!(element instanceof PsiVariable) || (initializer = (variable = (PsiVariable)element).getInitializer()) == null) continue;
            this.initializeVariable(variable, initializer);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitField(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            this.initializeVariable((PsiVariable)field, initializer);
        }
    }

    private void initializeVariable(PsiVariable variable, PsiExpression initializer) {
        DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue(variable, false);
        this.addInstruction(new PushInstruction(dfaVariable, initializer));
        initializer.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(initializer, variable.getType());
        this.addInstruction(new AssignInstruction(initializer, dfaVariable));
        this.addInstruction(new PopInstruction());
    }

    public void visitCodeFragment(JavaCodeFragment codeFragment) {
        PsiExpression expression2;
        this.startElement((PsiElement)codeFragment);
        if (codeFragment instanceof PsiExpressionCodeFragment && (expression2 = ((PsiExpressionCodeFragment)codeFragment).getExpression()) != null) {
            expression2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)codeFragment);
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        this.startElement((PsiElement)block);
        for (PsiStatement statement2 : block.getStatements()) {
            statement2.accept((PsiElementVisitor)this);
        }
        this.flushCodeBlockVariables(block);
        this.finishElement((PsiElement)block);
    }

    private void flushCodeBlockVariables(PsiCodeBlock block) {
        block6: {
            PsiResourceList list;
            PsiElement parent;
            block8: {
                block7: {
                    block5: {
                        for (PsiStatement statement2 : block.getStatements()) {
                            if (!(statement2 instanceof PsiDeclarationStatement)) continue;
                            for (PsiElement declaration2 : ((PsiDeclarationStatement)statement2).getDeclaredElements()) {
                                if (!(declaration2 instanceof PsiVariable)) continue;
                                this.myCurrentFlow.removeVariable((PsiVariable)declaration2);
                            }
                        }
                        parent = block.getParent();
                        if (!(parent instanceof PsiCatchSection)) break block5;
                        this.myCurrentFlow.removeVariable((PsiVariable)((PsiCatchSection)parent).getParameter());
                        break block6;
                    }
                    if (!(parent instanceof PsiForeachStatement)) break block7;
                    this.myCurrentFlow.removeVariable((PsiVariable)((PsiForeachStatement)parent).getIterationParameter());
                    break block6;
                }
                if (!(parent instanceof PsiForStatement)) break block8;
                PsiStatement statement3 = ((PsiForStatement)parent).getInitialization();
                if (!(statement3 instanceof PsiDeclarationStatement)) break block6;
                for (PsiElement declaration3 : ((PsiDeclarationStatement)statement3).getDeclaredElements()) {
                    if (!(declaration3 instanceof PsiVariable)) continue;
                    this.myCurrentFlow.removeVariable((PsiVariable)declaration3);
                }
                break block6;
            }
            if (parent instanceof PsiTryStatement && (list = ((PsiTryStatement)parent).getResourceList()) != null) {
                for (PsiResourceListElement resource : list) {
                    if (!(resource instanceof PsiResourceVariable)) continue;
                    this.myCurrentFlow.removeVariable((PsiVariable)resource);
                }
            }
        }
    }

    public void visitBlockStatement(PsiBlockStatement statement2) {
        this.startElement((PsiElement)statement2);
        statement2.getCodeBlock().accept((PsiElementVisitor)this);
        this.finishElement((PsiElement)statement2);
    }

    public void visitBreakStatement(PsiBreakStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiStatement exitedStatement = statement2.findExitedStatement();
        if (exitedStatement != null) {
            this.controlTransfer(new InstructionTransfer(this.getEndOffset((PsiElement)exitedStatement), this.getVariablesInside((PsiElement)exitedStatement)), this.getTrapsInsideStatement(exitedStatement));
        }
        this.finishElement((PsiElement)statement2);
    }

    private void controlTransfer(InstructionTransfer target, FList<Trap> traps) {
        this.addInstruction(new ControlTransferInstruction(this.myFactory.controlTransfer(target, traps)));
    }

    @NotNull
    private FList<Trap> getTrapsInsideStatement(PsiStatement statement2) {
        return FList.createFromReversed((Iterable)ContainerUtil.reverse((List)ContainerUtil.findAll(this.myTrapStack, cd -> PsiTreeUtil.isAncestor((PsiElement)statement2, (PsiElement)cd.getAnchor(), (boolean)true))));
    }

    @NotNull
    private List<DfaVariableValue> getVariablesInside(PsiElement exitedStatement) {
        return ContainerUtil.map((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)exitedStatement, PsiVariable.class), var -> this.myFactory.getVarFactory().createVariableValue((PsiVariable)var, false));
    }

    public void visitContinueStatement(PsiContinueStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiStatement continuedStatement = statement2.findContinuedStatement();
        if (continuedStatement instanceof PsiLoopStatement) {
            PsiStatement body2 = ((PsiLoopStatement)continuedStatement).getBody();
            this.controlTransfer(new InstructionTransfer(this.getEndOffset((PsiElement)body2), this.getVariablesInside((PsiElement)body2)), this.getTrapsInsideStatement(body2));
        } else {
            this.addInstruction(new EmptyInstruction(null));
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiStatement body2 = statement2.getBody();
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
            PsiExpression condition2 = statement2.getCondition();
            if (condition2 != null) {
                condition2.accept((PsiElementVisitor)this);
                this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
                this.addInstruction(new ConditionalGotoInstruction(this.getStartOffset((PsiElement)statement2), false, (PsiElement)condition2));
            }
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitEmptyStatement(PsiEmptyStatement statement2) {
        this.startElement((PsiElement)statement2);
        this.finishElement((PsiElement)statement2);
    }

    public void visitExpressionStatement(PsiExpressionStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiExpression expr = statement2.getExpression();
        expr.accept((PsiElementVisitor)this);
        this.addInstruction(new PopInstruction());
        this.finishElement((PsiElement)statement2);
    }

    public void visitExpressionListStatement(PsiExpressionListStatement statement2) {
        PsiExpression[] expressions2;
        this.startElement((PsiElement)statement2);
        for (PsiExpression expr : expressions2 = statement2.getExpressionList().getExpressions()) {
            expr.accept((PsiElementVisitor)this);
            this.addInstruction(new PopInstruction());
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitForeachStatement(PsiForeachStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiParameter parameter = statement2.getIterationParameter();
        PsiExpression iteratedValue2 = statement2.getIteratedValue();
        if (iteratedValue2 != null) {
            iteratedValue2.accept((PsiElementVisitor)this);
            this.addInstruction(new FieldReferenceInstruction(iteratedValue2, "Collection iterator or array.length"));
        }
        ControlFlow.ControlFlowOffset offset = this.myCurrentFlow.getNextOffset();
        DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue((PsiVariable)parameter, false);
        this.addInstruction(new FlushVariableInstruction(dfaVariable));
        this.pushUnknown();
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement2), true, null));
        PsiStatement body2 = statement2.getBody();
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        this.addInstruction(new GotoInstruction(offset));
        this.finishElement((PsiElement)statement2);
        this.myCurrentFlow.removeVariable((PsiVariable)parameter);
    }

    public void visitForStatement(PsiForStatement statement2) {
        PsiStatement update2;
        PsiExpression condition2;
        this.startElement((PsiElement)statement2);
        final ArrayList declaredVariables = new ArrayList();
        PsiStatement initialization = statement2.getInitialization();
        if (initialization != null) {
            initialization.accept((PsiElementVisitor)this);
            initialization.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    this.visitElement((PsiElement)expression2);
                }

                public void visitDeclarationStatement(PsiDeclarationStatement statement2) {
                    PsiElement[] declaredElements;
                    for (PsiElement element : declaredElements = statement2.getDeclaredElements()) {
                        if (!(element instanceof PsiVariable)) continue;
                        declaredVariables.add(element);
                    }
                }
            });
        }
        if ((condition2 = statement2.getCondition()) != null) {
            condition2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
        } else {
            this.addInstruction(new PushInstruction(statement2.getRParenth() == null ? null : this.myFactory.getConstFactory().getTrue(), null));
        }
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement2), true, (PsiElement)condition2));
        PsiStatement body2 = statement2.getBody();
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        if ((update2 = statement2.getUpdate()) != null) {
            update2.accept((PsiElementVisitor)this);
        }
        ControlFlow.ControlFlowOffset offset = initialization != null ? this.getEndOffset((PsiElement)initialization) : this.getStartOffset((PsiElement)statement2);
        this.addInstruction(new GotoInstruction(offset));
        this.finishElement((PsiElement)statement2);
        for (PsiElement declaredVariable : declaredVariables) {
            PsiVariable psiVariable = (PsiVariable)declaredVariable;
            this.myCurrentFlow.removeVariable(psiVariable);
        }
    }

    public void visitIfStatement(PsiIfStatement statement2) {
        ControlFlow.ControlFlowOffset offset;
        this.startElement((PsiElement)statement2);
        PsiExpression condition2 = statement2.getCondition();
        PsiStatement thenStatement = statement2.getThenBranch();
        PsiStatement elseStatement = statement2.getElseBranch();
        ControlFlow.ControlFlowOffset controlFlowOffset = offset = elseStatement != null ? this.getStartOffset((PsiElement)elseStatement) : this.getEndOffset((PsiElement)statement2);
        if (condition2 != null) {
            condition2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
            this.addInstruction(new ConditionalGotoInstruction(offset, true, (PsiElement)condition2));
        }
        if (thenStatement != null) {
            thenStatement.accept((PsiElementVisitor)this);
        }
        if (elseStatement != null) {
            offset = this.getEndOffset((PsiElement)statement2);
            GotoInstruction instruction = new GotoInstruction(offset);
            this.addInstruction(instruction);
            elseStatement.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitStatement(PsiStatement statement2) {
        this.startElement((PsiElement)statement2);
        this.finishElement((PsiElement)statement2);
    }

    public void visitLabeledStatement(PsiLabeledStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiStatement childStatement = statement2.getStatement();
        if (childStatement != null) {
            childStatement.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitLambdaExpression(PsiLambdaExpression expression2) {
        this.startElement((PsiElement)expression2);
        DfaValue dfaValue = this.myFactory.createValue((PsiExpression)expression2);
        this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression2));
        this.addInstruction(new LambdaInstruction(expression2));
        this.finishElement((PsiElement)expression2);
    }

    public void visitReturnStatement(PsiReturnStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiExpression returnValue = statement2.getReturnValue();
        if (returnValue != null) {
            returnValue.accept((PsiElementVisitor)this);
            PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
            if (method2 != null) {
                this.generateBoxingUnboxingInstructionFor(returnValue, method2.getReturnType());
            } else {
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
                if (lambdaExpression != null) {
                    this.generateBoxingUnboxingInstructionFor(returnValue, LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression));
                }
            }
            this.addInstruction(new CheckReturnValueInstruction((PsiElement)returnValue));
        }
        this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(ReturnTransfer.INSTANCE, this.myTrapStack), (PsiElement)statement2));
        this.finishElement((PsiElement)statement2);
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement2) {
        this.startElement((PsiElement)statement2);
        this.finishElement((PsiElement)statement2);
    }

    public void visitSwitchStatement(PsiSwitchStatement switchStmt) {
        PsiCodeBlock body2;
        this.startElement((PsiElement)switchStmt);
        PsiExpression caseExpression = switchStmt.getExpression();
        HashSet<PsiEnumConstant> enumValues = null;
        if (caseExpression != null) {
            caseExpression.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(caseExpression, (PsiType)PsiType.INT);
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)caseExpression.getType());
            if (psiClass != null) {
                this.addInstruction(new FieldReferenceInstruction(caseExpression, "switch statement expression"));
                if (psiClass.isEnum()) {
                    enumValues = new HashSet<PsiEnumConstant>();
                    for (PsiField f : psiClass.getFields()) {
                        if (!(f instanceof PsiEnumConstant)) continue;
                        enumValues.add((PsiEnumConstant)f);
                    }
                }
            } else {
                this.addInstruction(new PopInstruction());
            }
        }
        if ((body2 = switchStmt.getBody()) != null) {
            PsiStatement[] statements = body2.getStatements();
            PsiSwitchLabelStatement defaultLabel = null;
            for (PsiStatement statement2 : statements) {
                if (!(statement2 instanceof PsiSwitchLabelStatement)) continue;
                PsiSwitchLabelStatement psiLabelStatement = (PsiSwitchLabelStatement)statement2;
                if (psiLabelStatement.isDefaultCase()) {
                    defaultLabel = psiLabelStatement;
                    continue;
                }
                try {
                    boolean alwaysTrue;
                    ControlFlow.ControlFlowOffset offset = this.getStartOffset((PsiElement)statement2);
                    PsiExpression caseValue = psiLabelStatement.getCaseValue();
                    if (enumValues != null && caseValue instanceof PsiReferenceExpression) {
                        enumValues.remove(((PsiReferenceExpression)caseValue).resolve());
                    }
                    boolean bl = alwaysTrue = enumValues != null && enumValues.isEmpty();
                    if (alwaysTrue) {
                        this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
                    } else if (caseValue != null && caseExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)caseExpression).getQualifierExpression() == null) {
                        this.addInstruction(new PushInstruction(this.myFactory.createValue(caseExpression), caseExpression));
                        caseValue.accept((PsiElementVisitor)this);
                        this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, null, this.myProject));
                    } else {
                        this.pushUnknown();
                    }
                    this.addInstruction(new ConditionalGotoInstruction(offset, false, (PsiElement)statement2));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (enumValues == null || !enumValues.isEmpty()) {
                ControlFlow.ControlFlowOffset offset = defaultLabel != null ? this.getStartOffset((PsiElement)defaultLabel) : this.getEndOffset((PsiElement)body2);
                this.addInstruction(new GotoInstruction(offset));
            }
            body2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)switchStmt);
    }

    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression qualifier = expression2.getQualifierExpression();
        if (qualifier != null) {
            qualifier.accept((PsiElementVisitor)this);
            this.addInstruction(new FieldReferenceInstruction(qualifier, "Method reference qualifier"));
        }
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression2.getFunctionalInterfaceType(), Nullness.NOT_NULL), (PsiExpression)expression2));
        this.finishElement((PsiElement)expression2);
    }

    public void visitSynchronizedStatement(PsiSynchronizedStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiExpression lock = statement2.getLockExpression();
        if (lock != null) {
            lock.accept((PsiElementVisitor)this);
            this.addInstruction(new FieldReferenceInstruction(lock, "Synchronized value"));
        }
        this.addInstruction(new FlushVariableInstruction(null));
        PsiCodeBlock body2 = statement2.getBody();
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitThrowStatement(PsiThrowStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiExpression exception = statement2.getException();
        if (exception != null) {
            exception.accept((PsiElementVisitor)this);
            this.addConditionalRuntimeThrow();
            this.addInstruction(new FieldReferenceInstruction(exception, "thrown exception"));
            this.throwException(exception.getType(), (PsiElement)statement2);
        }
        this.finishElement((PsiElement)statement2);
    }

    private void addConditionalRuntimeThrow() {
        if (this.myTrapStack.isEmpty()) {
            return;
        }
        this.pushUnknown();
        ConditionalGotoInstruction ifNoException = this.addInstruction(new ConditionalGotoInstruction(null, false, null));
        this.pushUnknown();
        ConditionalGotoInstruction ifError = this.addInstruction(new ConditionalGotoInstruction(null, false, null));
        this.throwException(this.myRuntimeException, null);
        ifError.setOffset(this.myCurrentFlow.getInstructionCount());
        this.throwException(this.myError, null);
        ifNoException.setOffset(this.myCurrentFlow.getInstructionCount());
    }

    public void visitTryStatement(PsiTryStatement statement2) {
        PsiCatchSection[] sections;
        Trap.TryFinally finallyDescriptor;
        this.startElement((PsiElement)statement2);
        PsiResourceList resourceList = statement2.getResourceList();
        PsiCodeBlock tryBlock = statement2.getTryBlock();
        PsiCodeBlock finallyBlock = statement2.getFinallyBlock();
        Trap.TryFinally tryFinally = finallyDescriptor = finallyBlock != null ? new Trap.TryFinally(finallyBlock, this.getStartOffset((PsiElement)finallyBlock)) : null;
        if (finallyDescriptor != null) {
            this.myTrapStack = this.myTrapStack.prepend((Object)finallyDescriptor);
        }
        if ((sections = statement2.getCatchSections()).length > 0) {
            LinkedHashMap<PsiCatchSection, ControlFlow.ControlFlowOffset> clauses = new LinkedHashMap<PsiCatchSection, ControlFlow.ControlFlowOffset>();
            for (PsiCatchSection section : sections) {
                PsiCodeBlock catchBlock = section.getCatchBlock();
                if (catchBlock == null) continue;
                clauses.put(section, this.getStartOffset((PsiElement)catchBlock));
            }
            this.myTrapStack = this.myTrapStack.prepend((Object)new Trap.TryCatch(statement2, clauses));
        }
        if (resourceList != null) {
            resourceList.accept((PsiElementVisitor)this);
        }
        if (tryBlock != null) {
            tryBlock.accept((PsiElementVisitor)this);
        }
        InstructionTransfer gotoEnd = new InstructionTransfer(this.getEndOffset((PsiElement)statement2), this.getVariablesInside((PsiElement)tryBlock));
        FList singleFinally = FList.createFromReversed((Iterable)ContainerUtil.createMaybeSingletonList((Object)finallyDescriptor));
        this.controlTransfer(gotoEnd, (FList<Trap>)singleFinally);
        if (sections.length > 0) {
            assert (this.myTrapStack.getHead() instanceof Trap.TryCatch);
            this.myTrapStack = this.myTrapStack.getTail();
        }
        for (PsiCatchSection section : sections) {
            PsiCodeBlock catchBlock = section.getCatchBlock();
            if (catchBlock != null) {
                this.visitCodeBlock(catchBlock);
            }
            this.controlTransfer(gotoEnd, (FList<Trap>)singleFinally);
        }
        if (finallyBlock != null) {
            assert (this.myTrapStack.getHead() instanceof Trap.TryFinally);
            this.myTrapStack = this.myTrapStack.getTail().prepend((Object)new Trap.InsideFinally(finallyBlock));
            finallyBlock.accept((PsiElementVisitor)this);
            this.addInstruction(new ControlTransferInstruction(null));
            assert (this.myTrapStack.getHead() instanceof Trap.InsideFinally);
            this.myTrapStack = this.myTrapStack.getTail();
        }
        this.finishElement((PsiElement)statement2);
    }

    public void visitResourceList(PsiResourceList resourceList) {
        for (PsiResourceListElement resource : resourceList) {
            List<PsiClassType> closerExceptions;
            if (resource instanceof PsiResourceVariable) {
                PsiResourceVariable variable = (PsiResourceVariable)resource;
                PsiExpression initializer = variable.getInitializer();
                if (initializer != null) {
                    this.initializeVariable((PsiVariable)variable, initializer);
                }
            } else if (resource instanceof PsiResourceExpression) {
                ((PsiResourceExpression)resource).getExpression().accept((PsiElementVisitor)this);
            }
            if ((closerExceptions = ExceptionUtil.getCloserExceptions(resource)).isEmpty()) continue;
            this.addThrows(null, closerExceptions.toArray(new PsiClassType[closerExceptions.size()]));
        }
    }

    public void visitWhileStatement(PsiWhileStatement statement2) {
        this.startElement((PsiElement)statement2);
        PsiExpression condition2 = statement2.getCondition();
        if (condition2 != null) {
            condition2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
        } else {
            this.pushUnknown();
        }
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement2), true, (PsiElement)condition2));
        PsiStatement body2 = statement2.getBody();
        if (body2 != null) {
            body2.accept((PsiElementVisitor)this);
        }
        this.addInstruction(new GotoInstruction(this.getStartOffset((PsiElement)statement2)));
        this.finishElement((PsiElement)statement2);
    }

    public void visitExpressionList(PsiExpressionList list) {
        PsiExpression[] expressions2;
        this.startElement((PsiElement)list);
        for (PsiExpression expression2 : expressions2 = list.getExpressions()) {
            expression2.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)list);
    }

    public void visitExpression(PsiExpression expression2) {
        this.startElement((PsiElement)expression2);
        DfaValue dfaValue = this.myFactory.createValue(expression2);
        this.addInstruction(new PushInstruction(dfaValue, expression2));
        this.finishElement((PsiElement)expression2);
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
        DfaValue toPush;
        this.startElement((PsiElement)expression2);
        PsiExpression arrayExpression = expression2.getArrayExpression();
        arrayExpression.accept((PsiElementVisitor)this);
        this.addInstruction(new FieldReferenceInstruction((PsiExpression)expression2, null));
        PsiExpression indexExpression = expression2.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(indexExpression, (PsiType)PsiType.INT);
            this.addInstruction(new PopInstruction());
        }
        this.addInstruction(new PushInstruction((toPush = this.myFactory.createValue((PsiExpression)expression2)) != null ? toPush : this.myFactory.createTypeValue(expression2.getType(), Nullness.UNKNOWN), null));
        this.finishElement((PsiElement)expression2);
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
        PsiExpression[] initializers;
        this.startElement((PsiElement)expression2);
        PsiType type2 = expression2.getType();
        for (PsiExpression initializer : initializers = expression2.getInitializers()) {
            initializer.accept((PsiElementVisitor)this);
            if (type2 instanceof PsiArrayType) {
                this.generateBoxingUnboxingInstructionFor(initializer, ((PsiArrayType)type2).getComponentType());
            }
            this.addInstruction(new PopInstruction());
        }
        this.pushUnknown();
        this.finishElement((PsiElement)expression2);
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        this.startElement((PsiElement)expression2);
        DfaValue dfaValue = this.myFactory.createValue((PsiExpression)expression2);
        if (dfaValue != null) {
            this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression2));
            this.finishElement((PsiElement)expression2);
            return;
        }
        IElementType op = expression2.getOperationTokenType();
        PsiExpression[] operands2 = expression2.getOperands();
        if (operands2.length <= 1) {
            this.pushUnknown();
            this.finishElement((PsiElement)expression2);
            return;
        }
        PsiType type2 = expression2.getType();
        if (op == JavaTokenType.ANDAND) {
            this.generateAndExpression(operands2, type2, true);
        } else if (op == JavaTokenType.OROR) {
            this.generateOrExpression(operands2, type2, true);
        } else if (op == JavaTokenType.XOR && PsiType.BOOLEAN.equals((Object)type2)) {
            this.generateXorExpression((PsiExpression)expression2, operands2, type2, false);
        } else if (op == JavaTokenType.AND && PsiType.BOOLEAN.equals((Object)type2)) {
            this.generateAndExpression(operands2, type2, false);
        } else if (op == JavaTokenType.OR && PsiType.BOOLEAN.equals((Object)type2)) {
            this.generateOrExpression(operands2, type2, false);
        } else if (ControlFlowAnalyzer.isBinaryDivision(op) && operands2.length == 2 && type2 != null && PsiType.LONG.isAssignableFrom(type2)) {
            this.generateDivMod(expression2, type2, operands2[0], operands2[1]);
        } else {
            this.generateOther(expression2, op, operands2, type2);
        }
        this.finishElement((PsiElement)expression2);
    }

    static boolean isBinaryDivision(IElementType binaryOp) {
        return binaryOp == JavaTokenType.DIV || binaryOp == JavaTokenType.PERC;
    }

    static boolean isAssignmentDivision(IElementType op) {
        return op == JavaTokenType.PERCEQ || op == JavaTokenType.DIVEQ;
    }

    private void generateDivMod(PsiPolyadicExpression expression2, PsiType type2, PsiExpression left, PsiExpression right) {
        left.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(left, type2);
        right.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(right, type2);
        this.checkZeroDivisor();
        this.addInstruction(new BinopInstruction(expression2.getOperationTokenType(), (PsiElement)(expression2.isPhysical() ? expression2 : null), this.myProject));
    }

    private void checkZeroDivisor() {
        this.addInstruction(new DupInstruction());
        this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().createFromValue(0, (PsiType)PsiType.LONG, null), null));
        this.addInstruction(new BinopInstruction(JavaTokenType.NE, null, this.myProject));
        ConditionalGotoInstruction ifNonZero = new ConditionalGotoInstruction(null, false, null);
        this.addInstruction(ifNonZero);
        this.throwException((PsiType)JavaPsiFacade.getElementFactory((Project)this.myProject).createTypeByFQClassName(ArithmeticException.class.getName()), null);
        ifNonZero.setOffset(this.myCurrentFlow.getInstructionCount());
    }

    private void generateOther(PsiPolyadicExpression expression2, IElementType op, PsiExpression[] operands2, PsiType type2) {
        op = ControlFlowAnalyzer.substituteBinaryOperation(op, type2);
        PsiExpression lExpr = operands2[0];
        lExpr.accept((PsiElementVisitor)this);
        PsiType lType = lExpr.getType();
        for (int i = 1; i < operands2.length; ++i) {
            PsiExpression rExpr = operands2[i];
            PsiType rType = rExpr.getType();
            this.acceptBinaryRightOperand(op, type2, lExpr, lType, rExpr, rType);
            this.addInstruction(new BinopInstruction(op, (PsiElement)(expression2.isPhysical() ? expression2 : null), this.myProject));
            lExpr = rExpr;
            lType = rType;
        }
    }

    @Nullable
    private static IElementType substituteBinaryOperation(IElementType op, PsiType type2) {
        if (!(JavaTokenType.PLUS != op || type2 != null && type2.equalsToText("java.lang.String"))) {
            return null;
        }
        return op;
    }

    private void acceptBinaryRightOperand(@Nullable IElementType op, PsiType type2, PsiExpression lExpr, PsiType lType, PsiExpression rExpr, PsiType rType) {
        PsiType castType;
        boolean comparingPrimitiveNumeric;
        boolean comparing = op == JavaTokenType.EQEQ || op == JavaTokenType.NE;
        boolean comparingRef = comparing && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lType) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rType);
        boolean bl = comparingPrimitiveNumeric = comparing && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lType) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rType) && TypeConversionUtil.isNumericType((PsiType)lType) && TypeConversionUtil.isNumericType((PsiType)rType);
        Object object = comparingPrimitiveNumeric ? (TypeConversionUtil.isFloatOrDoubleType((PsiType)lType) ? PsiType.DOUBLE : PsiType.LONG) : (castType = type2);
        if (!comparingRef) {
            this.generateBoxingUnboxingInstructionFor(lExpr, castType);
        }
        rExpr.accept((PsiElementVisitor)this);
        if (!comparingRef) {
            this.generateBoxingUnboxingInstructionFor(rExpr, castType);
        }
    }

    private void generateBoxingUnboxingInstructionFor(@NotNull PsiExpression expression2, PsiType expectedType) {
        if (PsiType.VOID.equals((Object)expectedType)) {
            return;
        }
        PsiType exprType = expression2.getType();
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expectedType) && TypeConversionUtil.isPrimitiveWrapper((PsiType)exprType)) {
            this.addInstruction(new MethodCallInstruction(expression2, MethodCallInstruction.MethodType.UNBOXING, expectedType));
        } else if (TypeConversionUtil.isAssignableFromPrimitiveWrapper((PsiType)expectedType) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)exprType)) {
            this.addConditionalRuntimeThrow();
            this.addInstruction(new MethodCallInstruction(expression2, MethodCallInstruction.MethodType.BOXING, expectedType));
        } else if (exprType != expectedType && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)exprType) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expectedType) && TypeConversionUtil.isNumericType((PsiType)exprType) && TypeConversionUtil.isNumericType((PsiType)expectedType)) {
            this.addInstruction(new MethodCallInstruction(expression2, MethodCallInstruction.MethodType.CAST, expectedType){

                @Override
                public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
                    return visitor.visitCast(this, runner, stateBefore);
                }
            });
        }
    }

    private void generateXorExpression(PsiExpression expression2, PsiExpression[] operands2, PsiType exprType, boolean forAssignment) {
        PsiExpression operand2 = operands2[0];
        operand2.accept((PsiElementVisitor)this);
        if (forAssignment) {
            this.addInstruction(new DupInstruction());
        }
        this.generateBoxingUnboxingInstructionFor(operand2, exprType);
        for (int i = 1; i < operands2.length; ++i) {
            operand2 = operands2[i];
            operand2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand2, exprType);
            PsiExpression psiAnchor = i == operands2.length - 1 && expression2.isPhysical() ? expression2 : null;
            this.addInstruction(new BinopInstruction(JavaTokenType.NE, (PsiElement)psiAnchor, this.myProject));
        }
    }

    private void generateOrExpression(PsiExpression[] operands2, PsiType exprType, boolean shortCircuit) {
        for (int i = 0; i < operands2.length; ++i) {
            PsiExpression nextOperand;
            PsiExpression operand2 = operands2[i];
            operand2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand2, exprType);
            if (!shortCircuit) {
                if (i <= 0) continue;
                this.combineStackBooleans(false, operand2);
                continue;
            }
            PsiExpression psiExpression = nextOperand = i == operands2.length - 1 ? null : operands2[i + 1];
            if (nextOperand == null) continue;
            this.addInstruction(new ConditionalGotoInstruction(this.getStartOffset((PsiElement)nextOperand), true, (PsiElement)operand2));
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
            this.addInstruction(new GotoInstruction(this.getEndOffset((PsiElement)operands2[operands2.length - 1])));
        }
    }

    private void generateBooleanAssignmentExpression(boolean and, PsiExpression lExpression, PsiExpression rExpression, PsiType exprType) {
        lExpression.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(lExpression, exprType);
        this.addInstruction(new DupInstruction());
        rExpression.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(rExpression, exprType);
        this.addInstruction(new SwapInstruction());
        this.combineStackBooleans(and, lExpression);
    }

    private void combineStackBooleans(boolean and, PsiExpression anchor) {
        ConditionalGotoInstruction toPopAndPushSuccess = new ConditionalGotoInstruction(null, and, (PsiElement)anchor);
        this.addInstruction(toPopAndPushSuccess);
        GotoInstruction overPushSuccess = new GotoInstruction(null);
        this.addInstruction(overPushSuccess);
        PopInstruction pop = new PopInstruction();
        this.addInstruction(pop);
        DfaConstValue constValue = and ? this.myFactory.getConstFactory().getFalse() : this.myFactory.getConstFactory().getTrue();
        PushInstruction pushSuccess = new PushInstruction(constValue, null);
        this.addInstruction(pushSuccess);
        toPopAndPushSuccess.setOffset(pop.getIndex());
        overPushSuccess.setOffset(pushSuccess.getIndex() + 1);
    }

    private void generateAndExpression(PsiExpression[] operands2, PsiType exprType, boolean shortCircuit) {
        ArrayList<ConditionalGotoInstruction> branchToFail = new ArrayList<ConditionalGotoInstruction>();
        for (int i = 0; i < operands2.length; ++i) {
            PsiExpression operand2 = operands2[i];
            operand2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand2, exprType);
            if (!shortCircuit) {
                if (i <= 0) continue;
                this.combineStackBooleans(true, operand2);
                continue;
            }
            ConditionalGotoInstruction onFail = new ConditionalGotoInstruction(null, true, (PsiElement)operand2);
            branchToFail.add(onFail);
            this.addInstruction(onFail);
        }
        if (!shortCircuit) {
            return;
        }
        this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
        GotoInstruction toSuccess = new GotoInstruction(null);
        this.addInstruction(toSuccess);
        PushInstruction pushFalse = new PushInstruction(this.myFactory.getConstFactory().getFalse(), null);
        this.addInstruction(pushFalse);
        for (ConditionalGotoInstruction toFail : branchToFail) {
            toFail.setOffset(pushFalse.getIndex());
        }
        toSuccess.setOffset(pushFalse.getIndex() + 1);
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
        this.startElement((PsiElement)expression2);
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression2.getType(), Nullness.NOT_NULL), (PsiExpression)expression2));
        this.finishElement((PsiElement)expression2);
    }

    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        ControlFlow.ControlFlowOffset elseOffset;
        this.startElement((PsiElement)expression2);
        PsiExpression condition2 = expression2.getCondition();
        PsiExpression thenExpression2 = expression2.getThenExpression();
        PsiExpression elseExpression2 = expression2.getElseExpression();
        ControlFlow.ControlFlowOffset controlFlowOffset = elseOffset = elseExpression2 == null ? ControlFlow.deltaOffset(this.getEndOffset((PsiElement)expression2), -1) : this.getStartOffset((PsiElement)elseExpression2);
        if (thenExpression2 != null) {
            condition2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition2, (PsiType)PsiType.BOOLEAN);
            PsiType type2 = expression2.getType();
            this.addInstruction(new ConditionalGotoInstruction(elseOffset, true, (PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2)));
            thenExpression2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(thenExpression2, type2);
            this.addInstruction(new GotoInstruction(this.getEndOffset((PsiElement)expression2)));
            if (elseExpression2 != null) {
                elseExpression2.accept((PsiElementVisitor)this);
                this.generateBoxingUnboxingInstructionFor(elseExpression2, type2);
            } else {
                this.pushUnknown();
            }
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression2);
    }

    private void pushUnknown() {
        this.addInstruction(new PushInstruction(DfaUnknownValue.getInstance(), null));
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression operand2 = expression2.getOperand();
        PsiTypeElement checkType = expression2.getCheckType();
        if (checkType != null) {
            operand2.accept((PsiElementVisitor)this);
            PsiType type2 = checkType.getType();
            if (type2 instanceof PsiClassType) {
                type2 = ((PsiClassType)type2).rawType();
            }
            this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(type2, Nullness.UNKNOWN), null));
            this.addInstruction(new InstanceofInstruction((PsiElement)expression2, this.myProject, operand2, type2));
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression2);
    }

    private void addMethodThrows(PsiMethod method2, @Nullable PsiElement explicitCall) {
        if (method2 != null) {
            this.addThrows(explicitCall, method2.getThrowsList().getReferencedTypes());
        }
    }

    private void addThrows(@Nullable PsiElement explicitCall, PsiClassType[] refs) {
        for (PsiClassType ref : refs) {
            this.pushUnknown();
            ConditionalGotoInstruction cond = new ConditionalGotoInstruction(null, false, null);
            this.addInstruction(cond);
            this.throwException((PsiType)ref, explicitCall);
            cond.setOffset(this.myCurrentFlow.getInstructionCount());
        }
    }

    private void throwException(PsiType ref, @Nullable PsiElement anchor) {
        this.throwException(new ExceptionTransfer(this.myFactory.createTypeValue(ref, Nullness.NOT_NULL)), anchor);
    }

    private void throwException(ExceptionTransfer kind2, @Nullable PsiElement anchor) {
        this.addInstruction(new EmptyStackInstruction());
        this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(kind2, this.myTrapStack), anchor));
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
        if (qualifierExpression2 != null) {
            qualifierExpression2.accept((PsiElementVisitor)this);
        } else {
            this.pushUnknown();
        }
        PsiExpression[] expressions2 = expression2.getArgumentList().getExpressions();
        JavaResolveResult result2 = methodExpression.advancedResolve(false);
        PsiElement method2 = result2.getElement();
        PsiParameter[] parameters2 = method2 instanceof PsiMethod ? ((PsiMethod)method2).getParameterList().getParameters() : null;
        boolean isEqualsCall = expressions2.length == 1 && method2 instanceof PsiMethod && "equals".equals(((PsiMethod)method2).getName()) && parameters2.length == 1 && parameters2[0].getType().equalsToText("java.lang.Object") && PsiType.BOOLEAN.equals((Object)((PsiMethod)method2).getReturnType());
        for (int i = 0; i < expressions2.length; ++i) {
            PsiExpression paramExpr = expressions2[i];
            paramExpr.accept((PsiElementVisitor)this);
            if (parameters2 != null && i < parameters2.length) {
                this.generateBoxingUnboxingInstructionFor(paramExpr, result2.getSubstitutor().substitute(parameters2[i].getType()));
            }
            if (i != 0 || !isEqualsCall) continue;
            this.addInstruction(new SwapInstruction());
            this.addInstruction(new DupInstruction(2, 1));
            this.addInstruction(new PopInstruction());
        }
        this.addConditionalRuntimeThrow();
        List<MethodContract> contracts2 = method2 instanceof PsiMethod ? ControlFlowAnalyzer.getMethodCallContracts((PsiMethod)method2, expression2) : Collections.emptyList();
        this.addInstruction(new MethodCallInstruction((PsiCall)expression2, this.myFactory.createValue((PsiExpression)expression2), contracts2));
        if (!contracts2.isEmpty()) {
            this.addInstruction(new DupInstruction());
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getContractFail(), null));
            this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, null, this.myProject));
            ConditionalGotoInstruction ifNotFail = new ConditionalGotoInstruction(null, true, null);
            this.addInstruction(ifNotFail);
            this.addInstruction(new EmptyStackInstruction());
            this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(new ExceptionTransfer(DfaUnknownValue.getInstance()), this.myTrapStack), (PsiElement)expression2));
            ifNotFail.setOffset(this.myCurrentFlow.getInstructionCount());
        }
        if (!this.myTrapStack.isEmpty()) {
            this.addMethodThrows(expression2.resolveMethod(), (PsiElement)expression2);
        }
        if (isEqualsCall) {
            ConditionalGotoInstruction ifFalse = this.addInstruction(new ConditionalGotoInstruction(null, true, null));
            this.addInstruction(new ApplyNotNullInstruction(expression2));
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
            this.addInstruction(new GotoInstruction(this.getEndOffset((PsiElement)expression2)));
            ifFalse.setOffset(this.myCurrentFlow.getInstructionCount());
            this.addInstruction(new PopInstruction());
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getFalse(), null));
        }
        this.finishElement((PsiElement)expression2);
    }

    private static List<MethodContract> getMethodCallContracts(@NotNull PsiMethod method2, @NotNull PsiMethodCallExpression call) {
        List<MethodContract> contracts2 = HardcodedContracts.getHardcodedContracts(method2, call);
        return !contracts2.isEmpty() ? contracts2 : ControlFlowAnalyzer.getMethodContracts(method2);
    }

    public static List<MethodContract> getMethodContracts(@NotNull PsiMethod method2) {
        return (List)CachedValuesManager.getCachedValue((PsiElement)method2, () -> {
            String text;
            PsiAnnotation contractAnno = ControlFlowAnalyzer.findContractAnnotation(method2);
            if (contractAnno != null && (text = AnnotationUtil.getStringAttributeValue((PsiAnnotation)contractAnno, null)) != null) {
                try {
                    int paramCount = method2.getParameterList().getParametersCount();
                    List applicable = ContainerUtil.filter(MethodContract.parseContract(text), contract -> contract.arguments.length == paramCount);
                    return CachedValueProvider.Result.create((Object)applicable, (Object[])new Object[]{contractAnno, method2, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{method2, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    @Nullable
    public static PsiAnnotation findContractAnnotation(@NotNull PsiMethod method2) {
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method2, Collections.singleton(ORG_JETBRAINS_ANNOTATIONS_CONTRACT));
    }

    public static boolean isPure(@NotNull PsiMethod method2) {
        PsiAnnotation anno = ControlFlowAnalyzer.findContractAnnotation(method2);
        return anno != null && Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)anno, (String)"pure"));
    }

    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        if (enumConstant.getArgumentList() == null) {
            return;
        }
        this.pushUnknown();
        this.pushConstructorArguments((PsiConstructorCall)enumConstant);
        this.addInstruction(new MethodCallInstruction((PsiCall)enumConstant, null, Collections.emptyList()));
        this.addInstruction(new PopInstruction());
    }

    public void visitNewExpression(PsiNewExpression expression2) {
        this.startElement((PsiElement)expression2);
        this.pushUnknown();
        if (expression2.getType() instanceof PsiArrayType) {
            PsiExpression[] dimensions;
            for (PsiExpression dimension : dimensions = expression2.getArrayDimensions()) {
                dimension.accept((PsiElementVisitor)this);
            }
            for (PsiExpression ignored : dimensions) {
                this.addInstruction(new PopInstruction());
            }
            PsiArrayInitializerExpression arrayInitializer = expression2.getArrayInitializer();
            if (arrayInitializer != null) {
                for (PsiExpression initializer : arrayInitializer.getInitializers()) {
                    initializer.accept((PsiElementVisitor)this);
                    this.addInstruction(new PopInstruction());
                }
            }
            this.addConditionalRuntimeThrow();
            this.addInstruction(new MethodCallInstruction((PsiCall)expression2, null, Collections.emptyList()));
        } else {
            PsiMethod constructor = this.pushConstructorArguments((PsiConstructorCall)expression2);
            this.addConditionalRuntimeThrow();
            this.addInstruction(new MethodCallInstruction((PsiCall)expression2, null, constructor == null ? Collections.emptyList() : ControlFlowAnalyzer.getMethodContracts(constructor)));
            if (!this.myTrapStack.isEmpty()) {
                this.addMethodThrows(constructor, (PsiElement)expression2);
            }
        }
        this.finishElement((PsiElement)expression2);
    }

    @Nullable
    private PsiMethod pushConstructorArguments(PsiConstructorCall call) {
        PsiExpressionList args = call.getArgumentList();
        PsiMethod ctr = call.resolveConstructor();
        if (args != null) {
            PsiExpression[] params = args.getExpressions();
            PsiParameter[] parameters2 = ctr == null ? null : ctr.getParameterList().getParameters();
            for (int i = 0; i < params.length; ++i) {
                PsiExpression param = params[i];
                param.accept((PsiElementVisitor)this);
                if (parameters2 == null || i >= parameters2.length) continue;
                this.generateBoxingUnboxingInstructionFor(param, parameters2[i].getType());
            }
        }
        return ctr;
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression inner = expression2.getExpression();
        if (inner != null) {
            inner.accept((PsiElementVisitor)this);
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression2);
    }

    public void visitPostfixExpression(PsiPostfixExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getOperand());
        if (operand2 != null) {
            operand2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand2, (PsiType)PsiType.INT);
        } else {
            this.pushUnknown();
        }
        this.addInstruction(new PopInstruction());
        this.pushUnknown();
        this.flushIncrementedValue(operand2);
        this.finishElement((PsiElement)expression2);
    }

    public void visitPrefixExpression(PsiPrefixExpression expression2) {
        this.startElement((PsiElement)expression2);
        DfaValue dfaValue = this.myFactory.createValue((PsiExpression)expression2);
        if (dfaValue == null) {
            PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getOperand());
            if (operand2 == null) {
                this.pushUnknown();
            } else {
                operand2.accept((PsiElementVisitor)this);
                PsiType type2 = expression2.getType();
                PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type2);
                this.generateBoxingUnboxingInstructionFor(operand2, (PsiType)(unboxed == null ? type2 : unboxed));
                if (expression2.getOperationTokenType() == JavaTokenType.EXCL) {
                    this.addInstruction(new NotInstruction());
                } else {
                    this.addInstruction(new PopInstruction());
                    this.pushUnknown();
                    this.flushIncrementedValue(operand2);
                }
            }
        } else {
            this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression2));
        }
        this.finishElement((PsiElement)expression2);
    }

    private void flushIncrementedValue(@Nullable PsiExpression operand2) {
        DfaValue dfaVariable;
        DfaValue dfaValue = dfaVariable = operand2 == null ? null : this.myFactory.createValue(operand2);
        if (dfaVariable instanceof DfaVariableValue && PsiUtil.isAccessedForWriting((PsiExpression)operand2)) {
            this.addInstruction(new FlushVariableInstruction((DfaVariableValue)dfaVariable));
            if (((DfaVariableValue)dfaVariable).getPsiVariable() instanceof PsiField) {
                this.addInstruction(new FlushVariableInstruction(null));
            }
        }
    }

    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        this.startElement((PsiElement)expression2);
        PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
        if (qualifierExpression2 != null) {
            qualifierExpression2.accept((PsiElementVisitor)this);
            this.addInstruction(expression2.resolve() instanceof PsiField ? new FieldReferenceInstruction((PsiExpression)expression2, null) : new PopInstruction());
        }
        boolean writing = PsiUtil.isAccessedForWriting((PsiExpression)expression2) && !PsiUtil.isAccessedForReading((PsiExpression)expression2);
        this.addInstruction(new PushInstruction(this.myFactory.createValue((PsiExpression)expression2), (PsiExpression)expression2, writing));
        this.finishElement((PsiElement)expression2);
    }

    public void visitSuperExpression(PsiSuperExpression expression2) {
        this.startElement((PsiElement)expression2);
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression2.getType(), Nullness.NOT_NULL), null));
        this.finishElement((PsiElement)expression2);
    }

    public void visitThisExpression(PsiThisExpression expression2) {
        this.startElement((PsiElement)expression2);
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression2.getType(), Nullness.NOT_NULL), null));
        this.finishElement((PsiElement)expression2);
    }

    public void visitLiteralExpression(PsiLiteralExpression expression2) {
        this.startElement((PsiElement)expression2);
        DfaValue dfaValue = this.myFactory.createLiteralValue(expression2);
        this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression2));
        this.finishElement((PsiElement)expression2);
    }

    public void visitTypeCastExpression(PsiTypeCastExpression castExpression) {
        this.startElement((PsiElement)castExpression);
        PsiExpression operand2 = castExpression.getOperand();
        if (operand2 != null) {
            operand2.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand2, castExpression.getType());
        } else {
            this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(castExpression.getType(), Nullness.UNKNOWN), null));
        }
        PsiTypeElement typeElement = castExpression.getCastType();
        if (typeElement != null && operand2 != null && operand2.getType() != null) {
            if (typeElement.getType() instanceof PsiPrimitiveType && UnnecessaryExplicitNumericCastInspection.isPrimitiveNumericCastNecessary(castExpression)) {
                this.addInstruction(new PopInstruction());
                this.pushUnknown();
            } else {
                this.addInstruction(new TypeCastInstruction(castExpression, operand2, typeElement.getType()));
            }
        }
        this.finishElement((PsiElement)castExpression);
    }

    public void visitClass(PsiClass aClass) {
    }

    private static class ApplyNotNullInstruction
    extends Instruction {
        private final PsiMethodCallExpression myCall;

        private ApplyNotNullInstruction(PsiMethodCallExpression call) {
            this.myCall = call;
        }

        @Override
        public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState state, InstructionVisitor visitor) {
            DfaValue value2 = state.pop();
            DfaValueFactory factory = runner.getFactory();
            if (state.applyCondition(factory.getRelationFactory().createRelation(value2, factory.getConstFactory().getNull(), JavaTokenType.EQEQ, true))) {
                return this.nextInstruction(runner, state);
            }
            if (visitor instanceof StandardInstructionVisitor) {
                ((StandardInstructionVisitor)visitor).skipConstantConditionReporting((PsiElement)this.myCall);
            }
            return DfaInstructionState.EMPTY_ARRAY;
        }
    }

    private static class CannotAnalyzeException
    extends RuntimeException {
        private CannotAnalyzeException() {
        }
    }
}

