/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.LoopAnalyzer;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StateQueue;
import com.intellij.codeInspection.dataFlow.WorkingTimeMeasurer;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataFlowRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.DataFlowRunner");
    private static final Key<Integer> TOO_EXPENSIVE_HASH = Key.create((String)"TOO_EXPENSIVE_HASH");
    private Instruction[] myInstructions;
    private final MultiMap<PsiElement, DfaMemoryState> myNestedClosures = new MultiMap();
    private final List<DfaMemoryState> myStackTopClosures = new ArrayList<DfaMemoryState>();
    @NotNull
    private final DfaValueFactory myValueFactory;
    private final boolean myShouldCheckLimitTime;
    static final int MAX_STATES_PER_BRANCH = 300;

    protected DataFlowRunner() {
        this(false, true, false);
    }

    protected DataFlowRunner(boolean unknownMembersAreNullable, boolean honorFieldInitializers, boolean shouldCheckLimitTime) {
        this.myShouldCheckLimitTime = shouldCheckLimitTime;
        this.myValueFactory = new DfaValueFactory(honorFieldInitializers, unknownMembersAreNullable);
    }

    @NotNull
    public DfaValueFactory getFactory() {
        return this.myValueFactory;
    }

    @Nullable
    private Collection<DfaMemoryState> createInitialStates(@NotNull PsiElement psiBlock, @NotNull InstructionVisitor visitor) {
        PsiElement block;
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)psiBlock, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        if (container != null && (!(container instanceof PsiClass) || PsiUtil.isLocalOrAnonymousClass((PsiClass)((PsiClass)container))) && (block = DfaPsiUtil.getTopmostBlockInSameClass(container.getParent())) != null) {
            Collection closureStates;
            RunnerResult result2 = this.analyzeMethod(block, visitor);
            if (result2 == RunnerResult.OK && !(closureStates = this.myNestedClosures.get((Object)DfaPsiUtil.getTopmostBlockInSameClass(psiBlock))).isEmpty()) {
                return closureStates;
            }
            return null;
        }
        return Collections.singletonList(this.createMemoryState());
    }

    List<DfaMemoryState> getStackTopClosures() {
        return new ArrayList<DfaMemoryState>(this.myStackTopClosures);
    }

    @NotNull
    public final RunnerResult analyzeMethod(@NotNull PsiElement psiBlock, @NotNull InstructionVisitor visitor) {
        Collection<DfaMemoryState> initialStates = this.createInitialStates(psiBlock, visitor);
        return initialStates == null ? RunnerResult.NOT_APPLICABLE : this.analyzeMethod(psiBlock, visitor, false, initialStates);
    }

    @NotNull
    final RunnerResult analyzeMethod(@NotNull PsiElement psiBlock, @NotNull InstructionVisitor visitor, boolean ignoreAssertions, @NotNull Collection<DfaMemoryState> initialStates) {
        try {
            Integer tooExpensiveHash;
            ControlFlow flow = new ControlFlowAnalyzer(this.myValueFactory, psiBlock, ignoreAssertions).buildControlFlow();
            if (flow == null) {
                return RunnerResult.NOT_APPLICABLE;
            }
            int[] loopNumber = LoopAnalyzer.calcInLoop(flow);
            int endOffset = flow.getInstructionCount();
            this.myInstructions = flow.getInstructions();
            this.myNestedClosures.clear();
            this.myStackTopClosures.clear();
            HashSet joinInstructions = ContainerUtil.newHashSet();
            for (int index = 0; index < this.myInstructions.length; ++index) {
                Instruction instruction = this.myInstructions[index];
                if (instruction instanceof GotoInstruction) {
                    joinInstructions.add(this.myInstructions[((GotoInstruction)instruction).getOffset()]);
                    continue;
                }
                if (instruction instanceof ConditionalGotoInstruction) {
                    joinInstructions.add(this.myInstructions[((ConditionalGotoInstruction)instruction).getOffset()]);
                    continue;
                }
                if (instruction instanceof ControlTransferInstruction) {
                    joinInstructions.addAll(((ControlTransferInstruction)instruction).getPossibleTargetInstructions(this.myInstructions));
                    continue;
                }
                if (!(instruction instanceof MethodCallInstruction) || ((MethodCallInstruction)instruction).getContracts().isEmpty()) continue;
                joinInstructions.add(this.myInstructions[index + 1]);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Analyzing code block: " + psiBlock.getText());
                for (int i = 0; i < this.myInstructions.length; ++i) {
                    LOG.trace(i + ": " + this.myInstructions[i]);
                }
            }
            if ((tooExpensiveHash = (Integer)psiBlock.getUserData(TOO_EXPENSIVE_HASH)) != null && tooExpensiveHash.intValue() == psiBlock.getText().hashCode()) {
                LOG.trace("Too complex because hasn't changed since being too complex already");
                return RunnerResult.TOO_COMPLEX;
            }
            StateQueue queue = new StateQueue();
            for (DfaMemoryState initialState : initialStates) {
                queue.offer(new DfaInstructionState(this.myInstructions[0], initialState));
            }
            MultiMap processedStates = MultiMap.createSet();
            MultiMap incomingStates = MultiMap.createSet();
            long msLimit = Registry.intValue((String)(this.shouldCheckTimeLimit() ? "ide.dfa.time.limit.online" : "ide.dfa.time.limit.offline"));
            WorkingTimeMeasurer measurer = new WorkingTimeMeasurer(msLimit * 1000L * 1000L);
            int count = 0;
            while (!queue.isEmpty()) {
                List<DfaInstructionState> states = queue.getNextInstructionStates(joinInstructions);
                for (DfaInstructionState instructionState : states) {
                    DfaInstructionState[] after2;
                    Instruction instruction;
                    if (count++ % 1024 == 0 && measurer.isTimeOver()) {
                        LOG.trace("Too complex because the analysis took too long");
                        psiBlock.putUserData(TOO_EXPENSIVE_HASH, (Object)psiBlock.getText().hashCode());
                        return RunnerResult.TOO_COMPLEX;
                    }
                    ProgressManager.checkCanceled();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace(instructionState.toString());
                    }
                    if ((instruction = instructionState.getInstruction()) instanceof BranchingInstruction) {
                        BranchingInstruction branching = (BranchingInstruction)instruction;
                        Collection processed2 = processedStates.get((Object)branching);
                        if (processed2.contains(instructionState.getMemoryState())) continue;
                        if (processed2.size() > 300) {
                            LOG.trace("Too complex because too many different possible states");
                            return RunnerResult.TOO_COMPLEX;
                        }
                        if (loopNumber[branching.getIndex()] != 0) {
                            processedStates.putValue((Object)branching, (Object)instructionState.getMemoryState().createCopy());
                        }
                    }
                    for (DfaInstructionState state : after2 = this.acceptInstruction(visitor, instructionState)) {
                        Instruction nextInstruction = state.getInstruction();
                        if (nextInstruction.getIndex() >= endOffset) continue;
                        this.handleStepOutOfLoop(instruction, nextInstruction, loopNumber, (MultiMap<BranchingInstruction, DfaMemoryState>)processedStates, (MultiMap<BranchingInstruction, DfaMemoryState>)incomingStates, states, after2, queue);
                        if (nextInstruction instanceof BranchingInstruction) {
                            BranchingInstruction branching = (BranchingInstruction)nextInstruction;
                            if (processedStates.get((Object)branching).contains(state.getMemoryState()) || incomingStates.get((Object)branching).contains(state.getMemoryState())) continue;
                            if (loopNumber[branching.getIndex()] != 0) {
                                incomingStates.putValue((Object)branching, (Object)state.getMemoryState().createCopy());
                            }
                        }
                        queue.offer(state);
                    }
                }
            }
            psiBlock.putUserData(TOO_EXPENSIVE_HASH, null);
            LOG.trace("Analysis ok");
            return RunnerResult.OK;
        }
        catch (ArrayIndexOutOfBoundsException | EmptyStackException e) {
            LOG.error(psiBlock.getText(), (Throwable)e);
            return RunnerResult.ABORTED;
        }
    }

    private void handleStepOutOfLoop(@NotNull Instruction prevInstruction, @NotNull Instruction nextInstruction, @NotNull int[] loopNumber, @NotNull MultiMap<BranchingInstruction, DfaMemoryState> processedStates, @NotNull MultiMap<BranchingInstruction, DfaMemoryState> incomingStates, @NotNull List<DfaInstructionState> inFlightStates, @NotNull DfaInstructionState[] afterStates, @NotNull StateQueue queue) {
        if (loopNumber[prevInstruction.getIndex()] == 0 || DataFlowRunner.inSameLoop(prevInstruction, nextInstruction, loopNumber)) {
            return;
        }
        for (DfaInstructionState state2 : inFlightStates) {
            Instruction instruction = state2.getInstruction();
            if (!DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber)) continue;
            return;
        }
        for (DfaInstructionState state3 : afterStates) {
            Instruction instruction = state3.getInstruction();
            if (!DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber)) continue;
            return;
        }
        if (!queue.processAll((Processor<? super DfaInstructionState>)((Processor)state -> {
            Instruction instruction = state.getInstruction();
            return !DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber);
        }))) {
            return;
        }
        THashSet mayRemoveStatesFor = new THashSet();
        for (Instruction instruction : this.myInstructions) {
            if (!DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber) || !(instruction instanceof BranchingInstruction)) continue;
            mayRemoveStatesFor.add((BranchingInstruction)instruction);
        }
        for (Instruction instruction : mayRemoveStatesFor) {
            processedStates.remove((Object)((BranchingInstruction)instruction));
            incomingStates.remove((Object)((BranchingInstruction)instruction));
        }
    }

    private static boolean inSameLoop(@NotNull Instruction prevInstruction, @NotNull Instruction nextInstruction, @NotNull int[] loopNumber) {
        return loopNumber[nextInstruction.getIndex()] == loopNumber[prevInstruction.getIndex()];
    }

    protected boolean shouldCheckTimeLimit() {
        return this.myShouldCheckLimitTime && !ApplicationManager.getApplication().isUnitTestMode();
    }

    @NotNull
    protected DfaInstructionState[] acceptInstruction(@NotNull InstructionVisitor visitor, @NotNull DfaInstructionState instructionState) {
        Instruction instruction = instructionState.getInstruction();
        DfaInstructionState[] states = instruction.accept(this, instructionState.getMemoryState(), visitor);
        this.myStackTopClosures.clear();
        PsiElement closure = DfaUtil.getClosureInside(instruction);
        if (closure instanceof PsiClass) {
            this.registerNestedClosures(instructionState, (PsiClass)closure);
        } else if (closure instanceof PsiLambdaExpression) {
            this.registerNestedClosures(instructionState, (PsiLambdaExpression)closure);
        }
        return states;
    }

    private void registerNestedClosures(@NotNull DfaInstructionState instructionState, @NotNull PsiClass nestedClass) {
        DfaMemoryState state = instructionState.getMemoryState();
        for (PsiMethod psiMethod : nestedClass.getMethods()) {
            PsiCodeBlock body2 = psiMethod.getBody();
            if (body2 == null) continue;
            this.myNestedClosures.putValue((Object)body2, (Object)this.createClosureState(state));
        }
        for (PsiMethod psiMethod : nestedClass.getInitializers()) {
            this.myNestedClosures.putValue((Object)psiMethod.getBody(), (Object)this.createClosureState(state));
        }
        for (PsiMethod psiMethod : nestedClass.getFields()) {
            this.myNestedClosures.putValue((Object)psiMethod, (Object)this.createClosureState(state));
        }
    }

    private void registerNestedClosures(@NotNull DfaInstructionState instructionState, @NotNull PsiLambdaExpression expr) {
        DfaMemoryState state = instructionState.getMemoryState();
        PsiElement body2 = expr.getBody();
        if (body2 != null) {
            this.myNestedClosures.putValue((Object)body2, (Object)this.createClosureState(state));
        }
    }

    @NotNull
    private DfaMemoryState createClosureState(DfaMemoryState state) {
        DfaMemoryState closureState = state.createClosureState();
        this.myStackTopClosures.add(closureState);
        return closureState;
    }

    @NotNull
    protected DfaMemoryState createMemoryState() {
        return new DfaMemoryStateImpl(this.myValueFactory);
    }

    @NotNull
    public Instruction[] getInstructions() {
        return this.myInstructions;
    }

    @NotNull
    public Instruction getInstruction(int index) {
        return this.myInstructions[index];
    }

    @NotNull
    MultiMap<PsiElement, DfaMemoryState> getNestedClosures() {
        return new MultiMap(this.myNestedClosures);
    }

    @NotNull
    public Pair<Set<Instruction>, Set<Instruction>> getConstConditionalExpressions() {
        BranchingInstruction branchingInstruction;
        HashSet<BranchingInstruction> trueSet = new HashSet<BranchingInstruction>();
        HashSet<BranchingInstruction> falseSet = new HashSet<BranchingInstruction>();
        for (Instruction instruction : this.myInstructions) {
            if (!(instruction instanceof BranchingInstruction) || (branchingInstruction = (BranchingInstruction)instruction).getPsiAnchor() == null || !branchingInstruction.isConditionConst()) continue;
            if (!branchingInstruction.isTrueReachable()) {
                falseSet.add(branchingInstruction);
            }
            if (branchingInstruction.isFalseReachable()) continue;
            trueSet.add(branchingInstruction);
        }
        for (Instruction instruction : this.myInstructions) {
            if (!(instruction instanceof BranchingInstruction)) continue;
            branchingInstruction = (BranchingInstruction)instruction;
            if (branchingInstruction.isTrueReachable()) {
                falseSet.remove(branchingInstruction);
            }
            if (!branchingInstruction.isFalseReachable()) continue;
            trueSet.remove(branchingInstruction);
        }
        return Pair.create(trueSet, falseSet);
    }
}

