/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaOptionalValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TLongArrayList;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongIterator;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaMemoryStateImpl
implements DfaMemoryState {
    private final DfaValueFactory myFactory;
    private final List<EqClass> myEqClasses;
    private final TIntObjectHashMap<int[]> myIdToEqClassesIndices;
    private final Stack<DfaValue> myStack;
    private final TLongHashSet myDistinctClasses;
    private final LinkedHashMap<DfaVariableValue, DfaVariableState> myVariableStates;
    private final Map<DfaVariableValue, DfaVariableState> myDefaultVariableStates;
    private final LinkedHashSet<DfaVariableValue> myUnknownVariables;
    private boolean myEphemeral;
    private LinkedHashSet<UnorderedPair<EqClass>> myCachedDistinctClassPairs;
    private LinkedHashSet<EqClass> myCachedNonTrivialEqClasses;
    private Integer myCachedHash;

    protected DfaMemoryStateImpl(DfaValueFactory factory) {
        this.myFactory = factory;
        this.myDefaultVariableStates = ContainerUtil.newTroveMap();
        this.myEqClasses = ContainerUtil.newArrayList();
        this.myUnknownVariables = ContainerUtil.newLinkedHashSet();
        this.myVariableStates = ContainerUtil.newLinkedHashMap();
        this.myDistinctClasses = new TLongHashSet();
        this.myStack = new Stack();
        this.myIdToEqClassesIndices = new MyIdMap(20);
    }

    protected DfaMemoryStateImpl(DfaMemoryStateImpl toCopy) {
        this.myFactory = toCopy.myFactory;
        this.myEphemeral = toCopy.myEphemeral;
        this.myDefaultVariableStates = toCopy.myDefaultVariableStates;
        this.myStack = new Stack(toCopy.myStack);
        this.myDistinctClasses = new TLongHashSet(toCopy.myDistinctClasses.toArray());
        this.myUnknownVariables = ContainerUtil.newLinkedHashSet(toCopy.myUnknownVariables);
        this.myEqClasses = ContainerUtil.newArrayList(toCopy.myEqClasses);
        this.myIdToEqClassesIndices = new MyIdMap(toCopy.myIdToEqClassesIndices.size());
        toCopy.myIdToEqClassesIndices.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<int[]>(){

            public boolean execute(int id, int[] set2) {
                DfaMemoryStateImpl.this.myIdToEqClassesIndices.put(id, (Object)set2);
                return true;
            }
        });
        this.myVariableStates = ContainerUtil.newLinkedHashMap(toCopy.myVariableStates);
        this.myCachedDistinctClassPairs = toCopy.myCachedDistinctClassPairs;
        this.myCachedNonTrivialEqClasses = toCopy.myCachedNonTrivialEqClasses;
        this.myCachedHash = toCopy.myCachedHash;
    }

    @NotNull
    public DfaValueFactory getFactory() {
        return this.myFactory;
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createCopy() {
        return new DfaMemoryStateImpl(this);
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createClosureState() {
        DfaMemoryStateImpl copy = this.createCopy();
        copy.flushFields();
        HashSet<DfaVariableValue> vars = new HashSet<DfaVariableValue>(copy.getVariableStates().keySet());
        for (DfaVariableValue value2 : vars) {
            copy.flushDependencies(value2);
        }
        copy.emptyStack();
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaMemoryStateImpl)) {
            return false;
        }
        DfaMemoryStateImpl that = (DfaMemoryStateImpl)obj;
        if (this.myCachedHash != null && that.myCachedHash != null && !this.myCachedHash.equals(that.myCachedHash)) {
            return false;
        }
        return this.equalsSuperficially(that) && this.equalsByUnknownVariables(that) && this.equalsByRelations(that) && this.equalsByVariableStates(that);
    }

    private boolean equalsByUnknownVariables(DfaMemoryStateImpl that) {
        return this.myUnknownVariables.equals(that.myUnknownVariables);
    }

    Object getSuperficialKey() {
        return Pair.create((Object)this.myEphemeral, this.myStack);
    }

    private boolean equalsSuperficially(DfaMemoryStateImpl other) {
        return this.myEphemeral == other.myEphemeral && this.myStack.equals(other.myStack);
    }

    boolean equalsByRelations(DfaMemoryStateImpl that) {
        return this.getNonTrivialEqClasses().equals(that.getNonTrivialEqClasses()) && this.getDistinctClassPairs().equals(that.getDistinctClassPairs());
    }

    boolean equalsByVariableStates(DfaMemoryStateImpl that) {
        return this.myVariableStates.equals(that.myVariableStates);
    }

    LinkedHashSet<UnorderedPair<EqClass>> getDistinctClassPairs() {
        if (this.myCachedDistinctClassPairs != null) {
            return this.myCachedDistinctClassPairs;
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        for (long encodedPair : this.myDistinctClasses.toArray()) {
            result2.add(new UnorderedPair((Object)this.myEqClasses.get(DfaMemoryStateImpl.low(encodedPair)), (Object)this.myEqClasses.get(DfaMemoryStateImpl.high(encodedPair))));
        }
        this.myCachedDistinctClassPairs = result2;
        return this.myCachedDistinctClassPairs;
    }

    LinkedHashSet<EqClass> getNonTrivialEqClasses() {
        if (this.myCachedNonTrivialEqClasses != null) {
            return this.myCachedNonTrivialEqClasses;
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        for (EqClass eqClass : this.myEqClasses) {
            if (eqClass == null || eqClass.size() <= 1) continue;
            result2.add(eqClass);
        }
        this.myCachedNonTrivialEqClasses = result2;
        return this.myCachedNonTrivialEqClasses;
    }

    public int hashCode() {
        if (this.myCachedHash != null) {
            return this.myCachedHash;
        }
        int hash = this.getPartialHashCode(true, true);
        this.myCachedHash = hash;
        return hash;
    }

    int getPartialHashCode(boolean unknowns, boolean varStates) {
        int hash = (this.getNonTrivialEqClasses().hashCode() * 31 + this.getDistinctClassPairs().hashCode()) * 31 + this.myStack.hashCode();
        if (varStates) {
            hash = hash * 31 + this.myVariableStates.hashCode();
        }
        if (unknowns && !this.myUnknownVariables.isEmpty()) {
            hash = hash * 31 + this.myUnknownVariables.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append('<');
        if (this.myEphemeral) {
            result2.append("ephemeral, ");
        }
        for (EqClass eqClass : this.getNonTrivialEqClasses()) {
            result2.append(eqClass);
        }
        if (!this.myDistinctClasses.isEmpty()) {
            result2.append("\n  distincts: ");
            ArrayList<String> distincts = new ArrayList<String>();
            for (UnorderedPair unorderedPair : this.getDistinctClassPairs()) {
                distincts.add("{" + unorderedPair.first + ", " + unorderedPair.second + "}");
            }
            Collections.sort(distincts);
            result2.append(StringUtil.join(distincts, (String)" "));
        }
        if (!this.myStack.isEmpty()) {
            result2.append("\n  stack: ").append(StringUtil.join(this.myStack, (String)","));
        }
        if (!this.myVariableStates.isEmpty()) {
            result2.append("\n  vars: ");
            for (Map.Entry entry : this.myVariableStates.entrySet()) {
                result2.append("[").append(entry.getKey()).append("->").append(entry.getValue()).append("] ");
            }
        }
        if (!this.myUnknownVariables.isEmpty()) {
            result2.append("\n  unknowns: ").append(new HashSet<DfaVariableValue>(this.myUnknownVariables));
        }
        result2.append('>');
        return result2.toString();
    }

    @Override
    public DfaValue pop() {
        this.myCachedHash = null;
        return (DfaValue)this.myStack.pop();
    }

    @Override
    public DfaValue peek() {
        return (DfaValue)this.myStack.peek();
    }

    @Override
    public void push(@NotNull DfaValue value2) {
        this.myCachedHash = null;
        this.myStack.push((Object)value2);
    }

    @Override
    public void emptyStack() {
        this.myCachedHash = null;
        while (!this.myStack.isEmpty() && !(this.myStack.peek() instanceof DfaControlTransferValue)) {
            this.myStack.pop();
        }
    }

    @Override
    public void setVarValue(DfaVariableValue var, DfaValue value2) {
        if (var == value2) {
            return;
        }
        value2 = this.handleFlush(var, value2);
        this.flushVariable(var);
        if (value2 instanceof DfaUnknownValue) {
            this.setVariableState(var, this.getVariableState(var).withNullable(false));
            return;
        }
        this.setVariableState(var, this.withValueNullability(value2, this.getVariableState(var).withValue(value2)));
        if (value2 instanceof DfaTypeValue) {
            DfaRelationValue dfaInstanceof = this.myFactory.getRelationFactory().createRelation(var, value2, JavaTokenType.INSTANCEOF_KEYWORD, false);
            if (((DfaTypeValue)value2).isNotNull()) {
                this.applyCondition(dfaInstanceof);
            } else {
                this.applyInstanceofOrNull(dfaInstanceof);
            }
        } else {
            DfaRelationValue dfaEqual = this.myFactory.getRelationFactory().createRelation(var, value2, JavaTokenType.EQEQ, false);
            if (dfaEqual == null) {
                return;
            }
            this.applyCondition(dfaEqual);
            if (value2 instanceof DfaVariableValue) {
                this.setVariableState(var, this.getVariableState((DfaVariableValue)value2));
            }
        }
        if (this.getVariableState(var).isNotNull()) {
            this.applyCondition(this.compareToNull(var, true));
        }
    }

    private DfaVariableState withValueNullability(DfaValue value2, DfaVariableState state) {
        if (value2 instanceof DfaTypeValue) {
            return state.withNullability(((DfaTypeValue)value2).getNullness());
        }
        if (this.isNull(value2)) {
            return state.withNullability(Nullness.NULLABLE);
        }
        return state;
    }

    private DfaValue handleFlush(DfaVariableValue flushed, DfaValue value2) {
        if (value2 instanceof DfaVariableValue && (value2 == flushed || this.myFactory.getVarFactory().getAllQualifiedBy(flushed).contains(value2))) {
            Nullness nullability = this.isNotNull(value2) ? Nullness.NOT_NULL : ((DfaVariableValue)value2).getInherentNullability();
            return this.myFactory.createTypeValue(((DfaVariableValue)value2).getVariableType(), nullability);
        }
        return value2;
    }

    @Nullable(value="for boxed values which can't be compared by ==")
    private Integer getOrCreateEqClassIndex(@NotNull DfaValue dfaValue) {
        int i = this.getEqClassIndex(dfaValue);
        if (i != -1) {
            return i;
        }
        if (!DfaMemoryStateImpl.canBeInRelation(dfaValue) || !this.canBeReused(dfaValue) && !(((DfaBoxedValue)dfaValue).getWrappedValue() instanceof DfaConstValue)) {
            return null;
        }
        int freeIndex = this.myEqClasses.indexOf(null);
        int resultIndex = freeIndex >= 0 ? freeIndex : this.myEqClasses.size();
        EqClass aClass = new EqClass(this.myFactory);
        aClass.add(dfaValue.getID());
        if (freeIndex >= 0) {
            this.myEqClasses.set(freeIndex, aClass);
        } else {
            this.myEqClasses.add(aClass);
        }
        this.addToMap(dfaValue.getID(), resultIndex);
        return resultIndex;
    }

    private void addToMap(int id, int index) {
        int[] classes2 = (int[])this.myIdToEqClassesIndices.get(id = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID());
        if (classes2 == null) {
            classes2 = new int[]{index};
            this.myIdToEqClassesIndices.put(id, (Object)classes2);
        } else {
            classes2 = ArrayUtil.append((int[])classes2, (int)index);
            this.myIdToEqClassesIndices.put(id, (Object)classes2);
        }
    }

    private void removeFromMap(int id, int index) {
        int i;
        int[] classes2 = (int[])this.myIdToEqClassesIndices.get(id = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID());
        if (classes2 != null && (i = ArrayUtil.indexOf((int[])classes2, (int)index)) != -1) {
            classes2 = ArrayUtil.remove((int[])classes2, (int)i);
            this.myIdToEqClassesIndices.put(id, (Object)classes2);
        }
    }

    private void removeAllFromMap(int id) {
        if (id < 0) {
            return;
        }
        id = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID();
        this.myIdToEqClassesIndices.remove(id);
    }

    private static boolean canBeInRelation(@NotNull DfaValue dfaValue) {
        DfaValue unwrapped = DfaMemoryStateImpl.unwrap(dfaValue);
        return unwrapped instanceof DfaVariableValue || unwrapped instanceof DfaConstValue;
    }

    @NotNull
    List<DfaValue> getEquivalentValues(@NotNull DfaValue dfaValue) {
        EqClass set2;
        int index = this.getEqClassIndex(dfaValue);
        EqClass eqClass = set2 = index == -1 ? null : this.myEqClasses.get(index);
        if (set2 == null) {
            return Collections.emptyList();
        }
        return set2.getMemberValues();
    }

    private boolean canBeNaN(@NotNull DfaValue dfaValue) {
        for (DfaValue eq : this.getEquivalentValues(dfaValue)) {
            if (eq instanceof DfaBoxedValue) {
                eq = ((DfaBoxedValue)eq).getWrappedValue();
            }
            if (!(eq instanceof DfaConstValue) || DfaMemoryStateImpl.isNaN(eq)) continue;
            return false;
        }
        return dfaValue instanceof DfaVariableValue && TypeConversionUtil.isFloatOrDoubleType((PsiType)((DfaVariableValue)dfaValue).getVariableType());
    }

    private boolean isEffectivelyNaN(@NotNull DfaValue dfaValue) {
        for (DfaValue eqClass : this.getEquivalentValues(dfaValue)) {
            if (!DfaMemoryStateImpl.isNaN(eqClass)) continue;
            return true;
        }
        return false;
    }

    private int getEqClassIndex(@NotNull DfaValue dfaValue) {
        int id = DfaMemoryStateImpl.unwrap(dfaValue).getID();
        int[] classes2 = (int[])this.myIdToEqClassesIndices.get(id);
        int result2 = -1;
        if (classes2 != null) {
            for (int index : classes2) {
                EqClass aClass = this.myEqClasses.get(index);
                if (!aClass.contains(dfaValue.getID())) continue;
                if (!this.canBeReused(dfaValue) && aClass.size() > 1) break;
                result2 = index;
                break;
            }
        }
        return result2;
    }

    private boolean canBeReused(@NotNull DfaValue dfaValue) {
        if (dfaValue instanceof DfaBoxedValue) {
            DfaValue valueToWrap = ((DfaBoxedValue)dfaValue).getWrappedValue();
            if (valueToWrap instanceof DfaConstValue) {
                return DfaMemoryStateImpl.cacheable((DfaConstValue)valueToWrap);
            }
            if (valueToWrap instanceof DfaVariableValue) {
                if (PsiType.BOOLEAN.equals((Object)((DfaVariableValue)valueToWrap).getVariableType())) {
                    return true;
                }
                for (DfaValue value2 : this.getEquivalentValues(valueToWrap)) {
                    if (!(value2 instanceof DfaConstValue) || !DfaMemoryStateImpl.cacheable((DfaConstValue)value2)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean cacheable(@NotNull DfaConstValue dfaConstValue) {
        Object value2 = dfaConstValue.getValue();
        return DfaMemoryStateImpl.box(value2) == DfaMemoryStateImpl.box(value2);
    }

    private static Object box(Object value2) {
        Constable newBoxedValue;
        if (value2 instanceof Integer) {
            newBoxedValue = (int)((Integer)value2);
        } else if (value2 instanceof Byte) {
            newBoxedValue = (byte)((Byte)value2);
        } else if (value2 instanceof Short) {
            newBoxedValue = (short)((Short)value2);
        } else if (value2 instanceof Long) {
            newBoxedValue = (long)((Long)value2);
        } else if (value2 instanceof Boolean) {
            newBoxedValue = (Boolean)value2;
        } else if (value2 instanceof Character) {
            newBoxedValue = Character.valueOf(((Character)value2).charValue());
        } else {
            return new Object();
        }
        return newBoxedValue;
    }

    private boolean uniteClasses(int c1Index, int c2Index) {
        int i;
        long[] distincts;
        EqClass c1 = this.myEqClasses.get(c1Index);
        EqClass c2 = this.myEqClasses.get(c2Index);
        THashSet vars = ContainerUtil.newTroveSet();
        THashSet negatedVars = ContainerUtil.newTroveSet();
        int[] cs = new int[c1.size() + c2.size()];
        c1.set(0, cs, 0, c1.size());
        c2.set(0, cs, c1.size(), c2.size());
        int nConst = 0;
        for (int c : cs) {
            DfaValue dfaValue = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(c));
            if (dfaValue instanceof DfaConstValue) {
                ++nConst;
            }
            if (dfaValue instanceof DfaVariableValue) {
                DfaVariableValue variableValue = (DfaVariableValue)dfaValue;
                if (variableValue.isNegated()) {
                    negatedVars.add(variableValue.createNegated());
                } else {
                    vars.add(variableValue);
                }
            }
            if (nConst <= 1) continue;
            return false;
        }
        if (ContainerUtil.intersects((Collection)vars, (Collection)negatedVars)) {
            return false;
        }
        TLongArrayList c2Pairs = new TLongArrayList();
        for (long distinct : distincts = this.myDistinctClasses.toArray()) {
            int pc1 = DfaMemoryStateImpl.low(distinct);
            int pc2 = DfaMemoryStateImpl.high(distinct);
            boolean addedToC1 = false;
            if (pc1 == c1Index || pc2 == c1Index) {
                addedToC1 = true;
            }
            if (pc1 != c2Index && pc2 != c2Index) continue;
            if (addedToC1) {
                return false;
            }
            c2Pairs.add(distinct);
        }
        EqClass newClass = new EqClass(c1);
        this.myEqClasses.set(c1Index, newClass);
        for (i = 0; i < c2.size(); ++i) {
            int c = c2.get(i);
            newClass.add(c);
            this.removeFromMap(c, c2Index);
            this.addToMap(c, c1Index);
        }
        for (i = 0; i < c2Pairs.size(); ++i) {
            long c = c2Pairs.get(i);
            this.myDistinctClasses.remove(c);
            this.myDistinctClasses.add(DfaMemoryStateImpl.createPair(c1Index, DfaMemoryStateImpl.low(c) == c2Index ? DfaMemoryStateImpl.high(c) : DfaMemoryStateImpl.low(c)));
        }
        this.myEqClasses.set(c2Index, null);
        return true;
    }

    private static int low(long l) {
        return (int)l;
    }

    private static int high(long l) {
        return (int)((l & 0xFFFFFFFF00000000L) >> 32);
    }

    private static long createPair(int i1, int i2) {
        if (i1 < i2) {
            long l = i1;
            l <<= 32;
            return l += (long)i2;
        }
        long l = i2;
        l <<= 32;
        return l += (long)i1;
    }

    private void makeClassesDistinct(int c1Index, int c2Index) {
        this.myDistinctClasses.add(DfaMemoryStateImpl.createPair(c1Index, c2Index));
    }

    @Override
    public boolean isNull(DfaValue dfaValue) {
        if (dfaValue instanceof DfaConstValue) {
            return ((DfaConstValue)dfaValue).getValue() == null;
        }
        if (dfaValue instanceof DfaVariableValue) {
            int c1Index = this.getEqClassIndex(dfaValue);
            return c1Index >= 0 && c1Index == this.getEqClassIndex(this.myFactory.getConstFactory().getNull());
        }
        return false;
    }

    @Override
    public boolean isNotNull(DfaValue dfaVar) {
        long[] pairs;
        if (dfaVar instanceof DfaConstValue) {
            return ((DfaConstValue)dfaVar).getValue() != null;
        }
        if (dfaVar instanceof DfaBoxedValue) {
            return true;
        }
        if (dfaVar instanceof DfaTypeValue) {
            return ((DfaTypeValue)dfaVar).isNotNull();
        }
        if (dfaVar instanceof DfaVariableValue) {
            if (this.getVariableState((DfaVariableValue)dfaVar).isNotNull()) {
                return true;
            }
            DfaConstValue constantValue = this.getConstantValue((DfaVariableValue)dfaVar);
            if (constantValue != null && constantValue.getValue() != null) {
                return true;
            }
        }
        DfaConstValue dfaNull = this.myFactory.getConstFactory().getNull();
        int c1Index = this.getEqClassIndex(dfaVar);
        int c2Index = this.getEqClassIndex(dfaNull);
        if (c1Index < 0 || c2Index < 0) {
            return false;
        }
        for (long pair : pairs = this.myDistinctClasses.toArray()) {
            if ((c1Index != DfaMemoryStateImpl.low(pair) || c2Index != DfaMemoryStateImpl.high(pair)) && (c1Index != DfaMemoryStateImpl.high(pair) || c2Index != DfaMemoryStateImpl.low(pair))) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public DfaConstValue getConstantValue(@NotNull DfaVariableValue value2) {
        int index = this.getEqClassIndex(value2);
        EqClass ec = index == -1 ? null : this.myEqClasses.get(index);
        return ec == null ? null : (DfaConstValue)DfaMemoryStateImpl.unwrap(ec.findConstant(true));
    }

    @Override
    public void markEphemeral() {
        this.myEphemeral = true;
    }

    @Override
    public boolean isEphemeral() {
        return this.myEphemeral;
    }

    @Override
    public boolean applyInstanceofOrNull(@NotNull DfaRelationValue dfaCond) {
        DfaValue left = DfaMemoryStateImpl.unwrap(dfaCond.getLeftOperand());
        if (!(left instanceof DfaVariableValue)) {
            return true;
        }
        DfaVariableValue dfaVar = (DfaVariableValue)left;
        DfaTypeValue dfaType = (DfaTypeValue)dfaCond.getRightOperand();
        if (this.isUnknownState(dfaVar) || this.isNull(dfaVar)) {
            return true;
        }
        DfaVariableState newState = this.getVariableState(dfaVar).withInstanceofValue(dfaType);
        if (newState != null) {
            this.setVariableState(dfaVar, newState);
            return true;
        }
        return false;
    }

    @Override
    public void applyIsPresentCheck(boolean present, DfaValue qualifier) {
        if (qualifier instanceof DfaVariableValue && !this.isUnknownState(qualifier)) {
            this.setVariableState((DfaVariableValue)qualifier, this.getVariableState((DfaVariableValue)qualifier).withOptionalPresense(present));
        }
    }

    static DfaValue unwrap(DfaValue value2) {
        if (value2 instanceof DfaBoxedValue) {
            return ((DfaBoxedValue)value2).getWrappedValue();
        }
        if (value2 instanceof DfaUnboxedValue) {
            return ((DfaUnboxedValue)value2).getVariable();
        }
        return value2;
    }

    @Override
    public boolean applyCondition(DfaValue dfaCond) {
        if (dfaCond instanceof DfaUnknownValue) {
            return true;
        }
        if (dfaCond instanceof DfaUnboxedValue) {
            DfaVariableValue dfaVar = ((DfaUnboxedValue)dfaCond).getVariable();
            boolean isNegated = dfaVar.isNegated();
            DfaVariableValue dfaNormalVar = isNegated ? dfaVar.createNegated() : dfaVar;
            DfaValue boxedTrue = this.myFactory.getBoxedFactory().createBoxed(this.myFactory.getConstFactory().getTrue());
            return this.applyRelationCondition(this.myFactory.getRelationFactory().createRelation(dfaNormalVar, boxedTrue, JavaTokenType.EQEQ, isNegated));
        }
        if (dfaCond instanceof DfaVariableValue) {
            DfaVariableValue dfaVar = (DfaVariableValue)dfaCond;
            boolean isNegated = dfaVar.isNegated();
            DfaVariableValue dfaNormalVar = isNegated ? dfaVar.createNegated() : dfaVar;
            DfaConstValue dfaTrue = this.myFactory.getConstFactory().getTrue();
            return this.applyRelationCondition(this.myFactory.getRelationFactory().createRelation(dfaNormalVar, dfaTrue, JavaTokenType.EQEQ, isNegated));
        }
        if (dfaCond instanceof DfaConstValue) {
            return dfaCond == this.myFactory.getConstFactory().getTrue() || dfaCond != this.myFactory.getConstFactory().getFalse();
        }
        if (!(dfaCond instanceof DfaRelationValue)) {
            return true;
        }
        return this.applyRelationCondition((DfaRelationValue)dfaCond);
    }

    private boolean applyRelationCondition(@NotNull DfaRelationValue dfaRelation) {
        DfaValue dfaLeft = dfaRelation.getLeftOperand();
        DfaValue dfaRight = dfaRelation.getRightOperand();
        if (dfaLeft instanceof DfaUnknownValue || dfaRight instanceof DfaUnknownValue) {
            return true;
        }
        boolean isNegated = dfaRelation.isNegated();
        if (dfaLeft instanceof DfaTypeValue && ((DfaTypeValue)dfaLeft).isNotNull() && dfaRight == this.myFactory.getConstFactory().getNull()) {
            return isNegated;
        }
        if (dfaRight instanceof DfaTypeValue) {
            if (dfaLeft instanceof DfaVariableValue) {
                DfaVariableState newState;
                DfaVariableValue dfaVar = (DfaVariableValue)dfaLeft;
                if (this.isUnknownState(dfaVar)) {
                    return true;
                }
                if (!dfaRelation.isInstanceOf()) {
                    if (((DfaTypeValue)dfaRight).isNotNull() && this.isNull(dfaVar)) {
                        return isNegated;
                    }
                    return true;
                }
                if (isNegated) {
                    DfaVariableState newState2 = this.getVariableState(dfaVar).withNotInstanceofValue((DfaTypeValue)dfaRight);
                    if (newState2 != null) {
                        this.setVariableState(dfaVar, newState2);
                        return true;
                    }
                    return !this.getVariableState(dfaVar).isNotNull() && this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), false);
                }
                if (this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), true) && (newState = this.getVariableState(dfaVar).withInstanceofValue((DfaTypeValue)dfaRight)) != null) {
                    this.setVariableState(dfaVar, newState);
                    return true;
                }
                return false;
            }
            return true;
        }
        if (this.isEffectivelyNaN(dfaLeft) || this.isEffectivelyNaN(dfaRight)) {
            this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
            return isNegated;
        }
        if (this.canBeNaN(dfaLeft) && this.canBeNaN(dfaRight)) {
            if (dfaLeft == dfaRight && dfaLeft instanceof DfaVariableValue && !(((DfaVariableValue)dfaLeft).getVariableType() instanceof PsiPrimitiveType)) {
                return !isNegated;
            }
            this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
            return true;
        }
        return this.applyEquivalenceRelation(dfaRelation, dfaLeft, dfaRight);
    }

    private void updateVarStateOnComparison(@NotNull DfaVariableValue dfaVar, DfaValue value2) {
        if (!this.isUnknownState(dfaVar)) {
            if (value2 instanceof DfaConstValue && ((DfaConstValue)value2).getValue() == null) {
                this.setVariableState(dfaVar, this.getVariableState(dfaVar).withNullability(Nullness.NULLABLE));
            } else if (this.isNotNull(value2) && !this.isNotNull(dfaVar)) {
                this.setVariableState(dfaVar, this.getVariableState(dfaVar).withNullability(Nullness.UNKNOWN));
                this.applyRelation(dfaVar, this.myFactory.getConstFactory().getNull(), true);
            }
        }
    }

    private boolean applyEquivalenceRelation(@NotNull DfaRelationValue dfaRelation, DfaValue dfaLeft, DfaValue dfaRight) {
        boolean containsCalls;
        boolean isNegated = dfaRelation.isNonEquality();
        if (!isNegated && !dfaRelation.isEquality()) {
            return true;
        }
        boolean bl = containsCalls = dfaLeft instanceof DfaVariableValue && ((DfaVariableValue)dfaLeft).containsCalls();
        if (containsCalls && !this.isNotNull(dfaLeft) && this.isNull(dfaRight) && !isNegated) {
            return true;
        }
        if (dfaLeft == dfaRight) {
            return containsCalls || !isNegated;
        }
        if (this.isNull(dfaLeft) && this.isNotNull(dfaRight) || this.isNull(dfaRight) && this.isNotNull(dfaLeft)) {
            return isNegated;
        }
        if (!isNegated) {
            if (dfaLeft instanceof DfaVariableValue) {
                this.updateVarStateOnComparison((DfaVariableValue)dfaLeft, dfaRight);
            }
            if (dfaRight instanceof DfaVariableValue) {
                this.updateVarStateOnComparison((DfaVariableValue)dfaRight, dfaLeft);
            }
        }
        if (!this.applyRelation(dfaLeft, dfaRight, isNegated)) {
            return false;
        }
        if (!this.checkCompareWithBooleanLiteral(dfaLeft, dfaRight, isNegated)) {
            return false;
        }
        if (dfaLeft instanceof DfaVariableValue) {
            if (!this.applyUnboxedRelation((DfaVariableValue)dfaLeft, dfaRight, isNegated)) {
                return false;
            }
            if (!this.applyBoxedRelation((DfaVariableValue)dfaLeft, dfaRight, isNegated)) {
                return false;
            }
        }
        if (!isNegated && dfaRight instanceof DfaOptionalValue) {
            this.applyIsPresentCheck(((DfaOptionalValue)dfaRight).isPresent(), dfaLeft);
        }
        return true;
    }

    private boolean applyBoxedRelation(@NotNull DfaVariableValue dfaLeft, DfaValue dfaRight, boolean negated) {
        if (!TypeConversionUtil.isPrimitiveAndNotNull((PsiType)dfaLeft.getVariableType())) {
            return true;
        }
        DfaBoxedValue.Factory boxedFactory = this.myFactory.getBoxedFactory();
        DfaValue boxedLeft = boxedFactory.createBoxed(dfaLeft);
        DfaValue boxedRight = boxedFactory.createBoxed(dfaRight);
        return boxedLeft == null || boxedRight == null || this.applyRelation(boxedLeft, boxedRight, negated);
    }

    private boolean applyUnboxedRelation(@NotNull DfaVariableValue dfaLeft, DfaValue dfaRight, boolean negated) {
        DfaValue unboxedRight;
        PsiType type2 = dfaLeft.getVariableType();
        if (!TypeConversionUtil.isPrimitiveWrapper((PsiType)type2)) {
            return true;
        }
        if (negated) {
            return true;
        }
        DfaBoxedValue.Factory boxedFactory = this.myFactory.getBoxedFactory();
        DfaValue unboxedLeft = boxedFactory.createUnboxed(dfaLeft);
        return this.applyRelation(unboxedLeft, unboxedRight = boxedFactory.createUnboxed(dfaRight), false) && this.checkCompareWithBooleanLiteral(unboxedLeft, unboxedRight, false);
    }

    private boolean checkCompareWithBooleanLiteral(DfaValue dfaLeft, DfaValue dfaRight, boolean negated) {
        Object constVal;
        if (dfaRight instanceof DfaConstValue && (constVal = ((DfaConstValue)dfaRight).getValue()) instanceof Boolean) {
            DfaConstValue negVal = this.myFactory.getConstFactory().createFromValue((Boolean)constVal == false, (PsiType)PsiType.BOOLEAN, null);
            if (!this.applyRelation(dfaLeft, negVal, !negated)) {
                return false;
            }
            if (!this.applyRelation(dfaLeft.createNegated(), negVal, negated)) {
                return false;
            }
        }
        return true;
    }

    static boolean isNaN(DfaValue dfa) {
        if (dfa instanceof DfaConstValue) {
            Object value2 = ((DfaConstValue)dfa).getValue();
            if (value2 instanceof Double && ((Double)value2).isNaN()) {
                return true;
            }
            if (value2 instanceof Float && ((Float)value2).isNaN()) {
                return true;
            }
        }
        return false;
    }

    private boolean applyRelation(@NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight, boolean isNegated) {
        if (this.isUnknownState(dfaLeft) || this.isUnknownState(dfaRight)) {
            return true;
        }
        Integer c1Index = this.getOrCreateEqClassIndex(dfaLeft);
        Integer c2Index = this.getOrCreateEqClassIndex(dfaRight);
        if (c1Index == null || c2Index == null) {
            return true;
        }
        if (!isNegated) {
            if (c1Index.equals(c2Index) || this.areCompatibleConstants(c1Index, c2Index)) {
                return true;
            }
            if (!this.uniteClasses(c1Index, c2Index)) {
                return false;
            }
            for (long encodedPair : this.myDistinctClasses.toArray()) {
                EqClass c1 = this.myEqClasses.get(DfaMemoryStateImpl.low(encodedPair));
                EqClass c2 = this.myEqClasses.get(DfaMemoryStateImpl.high(encodedPair));
                DfaConstValue const1 = (DfaConstValue)c1.findConstant(false);
                DfaConstValue const2 = (DfaConstValue)c2.findConstant(false);
                if (const1 == null || const2 == null || DfaMemoryStateImpl.preserveConstantDistinction(const1.getValue(), const2.getValue())) continue;
                this.myDistinctClasses.remove(encodedPair);
            }
            this.myCachedDistinctClassPairs = null;
            this.myCachedNonTrivialEqClasses = null;
            this.myCachedHash = null;
        } else {
            if (c1Index.equals(c2Index) || this.areCompatibleConstants(c1Index, c2Index)) {
                return false;
            }
            if (this.isNull(dfaLeft) && DfaMemoryStateImpl.isPrimitive(dfaRight) || this.isNull(dfaRight) && DfaMemoryStateImpl.isPrimitive(dfaLeft)) {
                return true;
            }
            this.makeClassesDistinct(c1Index, c2Index);
            this.myCachedDistinctClassPairs = null;
            this.myCachedHash = null;
        }
        return true;
    }

    private static boolean isPrimitive(DfaValue value2) {
        return value2 instanceof DfaVariableValue && ((DfaVariableValue)value2).getVariableType() instanceof PsiPrimitiveType;
    }

    private static boolean preserveConstantDistinction(Object c1, Object c2) {
        return c1 == null && c2 instanceof PsiEnumConstant || c2 == null && c1 instanceof PsiEnumConstant;
    }

    private boolean areCompatibleConstants(int i1, int i2) {
        Double dv1 = this.getDoubleValue(i1);
        return dv1 != null && dv1.equals(this.getDoubleValue(i2));
    }

    @Nullable
    private Double getDoubleValue(int eqClassIndex) {
        EqClass ec = this.myEqClasses.get(eqClassIndex);
        DfaValue dfaConst = ec == null ? null : ec.findConstant(false);
        Object constValue = dfaConst instanceof DfaConstValue ? ((DfaConstValue)dfaConst).getValue() : null;
        return constValue instanceof Number ? Double.valueOf(((Number)constValue).doubleValue()) : null;
    }

    private boolean isUnknownState(DfaValue val) {
        if ((val = DfaMemoryStateImpl.unwrap(val)) instanceof DfaVariableValue) {
            if (this.myUnknownVariables.contains(val)) {
                return true;
            }
            DfaVariableValue negatedValue = ((DfaVariableValue)val).getNegatedValue();
            if (negatedValue != null && this.myUnknownVariables.contains(negatedValue)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkNotNullable(DfaValue value2) {
        if (value2 == this.myFactory.getConstFactory().getNull()) {
            return false;
        }
        if (value2 instanceof DfaTypeValue && ((DfaTypeValue)value2).isNullable()) {
            return false;
        }
        if (value2 instanceof DfaVariableValue) {
            DfaVariableValue varValue = (DfaVariableValue)value2;
            if (varValue.getVariableType() instanceof PsiPrimitiveType) {
                return true;
            }
            if (this.isNotNull(varValue)) {
                return true;
            }
            if (this.getVariableState(varValue).isNullable()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public ThreeState checkOptional(DfaValue value2) {
        if (value2 instanceof DfaVariableValue) {
            DfaVariableValue var = (DfaVariableValue)value2;
            DfaVariableState state = this.getVariableState(var);
            return state.getOptionalPresense();
        }
        return value2 instanceof DfaOptionalValue ? ThreeState.fromBoolean((boolean)((DfaOptionalValue)value2).isPresent()) : ThreeState.UNSURE;
    }

    @Nullable
    private DfaRelationValue compareToNull(DfaValue dfaVar, boolean negated) {
        DfaConstValue dfaNull = this.myFactory.getConstFactory().getNull();
        return this.myFactory.getRelationFactory().createRelation(dfaVar, dfaNull, JavaTokenType.EQEQ, negated);
    }

    void setVariableState(DfaVariableValue dfaVar, DfaVariableState state) {
        assert (!this.myUnknownVariables.contains(dfaVar));
        if (state.equals(this.myDefaultVariableStates.get(dfaVar))) {
            this.myVariableStates.remove(dfaVar);
        } else {
            this.myVariableStates.put(dfaVar, state);
        }
        this.myCachedHash = null;
    }

    DfaVariableState getVariableState(DfaVariableValue dfaVar) {
        DfaVariableState state = this.myVariableStates.get(dfaVar);
        if (state == null) {
            state = this.myDefaultVariableStates.get(dfaVar);
            if (state == null) {
                state = this.createVariableState(dfaVar);
                DfaTypeValue initialType = dfaVar.getTypeValue();
                if (initialType != null) {
                    state = state.withInstanceofValue(initialType);
                    assert (state != null);
                }
                this.myDefaultVariableStates.put(dfaVar, state);
            }
            if (this.isUnknownState(dfaVar)) {
                return state.withNullable(false);
            }
        }
        return state;
    }

    @NotNull
    Map<DfaVariableValue, DfaVariableState> getVariableStates() {
        return this.myVariableStates;
    }

    @NotNull
    protected DfaVariableState createVariableState(@NotNull DfaVariableValue var) {
        return new DfaVariableState(var);
    }

    @Override
    public void flushFields() {
        LinkedHashSet vars = ContainerUtil.newLinkedHashSet(this.getChangedVariables());
        for (EqClass aClass : this.myEqClasses) {
            if (aClass == null) continue;
            vars.addAll(aClass.getVariables(true));
        }
        for (DfaVariableValue value2 : vars) {
            if (!value2.isFlushableByCalls()) continue;
            this.doFlush(value2, this.shouldMarkUnknown(value2));
        }
    }

    private boolean shouldMarkUnknown(@NotNull DfaVariableValue value2) {
        int eqClassIndex = this.getEqClassIndex(value2);
        if (eqClassIndex < 0) {
            return false;
        }
        EqClass eqClass = this.myEqClasses.get(eqClassIndex);
        if (eqClass == null) {
            return false;
        }
        if (eqClass.findConstant(true) != null) {
            return true;
        }
        for (UnorderedPair unorderedPair : this.getDistinctClassPairs()) {
            if ((unorderedPair.first != eqClass || ((EqClass)unorderedPair.second).findConstant(true) == null) && (unorderedPair.second != eqClass || ((EqClass)unorderedPair.first).findConstant(true) == null)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    Set<DfaVariableValue> getChangedVariables() {
        return this.myVariableStates.keySet();
    }

    @Override
    public void flushVariable(@NotNull DfaVariableValue variable) {
        List updatedStack = ContainerUtil.map(this.myStack, value2 -> this.handleFlush(variable, (DfaValue)value2));
        this.myStack.clear();
        for (DfaValue value3 : updatedStack) {
            this.myStack.push((Object)value3);
        }
        this.doFlush(variable, false);
        this.flushDependencies(variable);
        this.myUnknownVariables.remove(variable);
        this.myUnknownVariables.removeAll(this.myFactory.getVarFactory().getAllQualifiedBy(variable));
        this.myCachedHash = null;
    }

    void flushDependencies(@NotNull DfaVariableValue variable) {
        for (DfaVariableValue dependent : this.myFactory.getVarFactory().getAllQualifiedBy(variable)) {
            this.doFlush(dependent, false);
        }
    }

    @NotNull
    Set<DfaVariableValue> getUnknownVariables() {
        return this.myUnknownVariables;
    }

    void doFlush(@NotNull DfaVariableValue varPlain, boolean markUnknown) {
        DfaVariableValue varNegated = varPlain.getNegatedValue();
        int idPlain = varPlain.getID();
        int idNegated = varNegated == null ? -1 : varNegated.getID();
        int[] classes2 = (int[])this.myIdToEqClassesIndices.get(idPlain);
        int[] negatedClasses = (int[])this.myIdToEqClassesIndices.get(idNegated);
        int[] result2 = ArrayUtil.mergeArrays((int[])((int[])ObjectUtils.notNull((Object)classes2, (Object)ArrayUtil.EMPTY_INT_ARRAY)), (int[])((int[])ObjectUtils.notNull((Object)negatedClasses, (Object)ArrayUtil.EMPTY_INT_ARRAY)));
        int interruptCount = 0;
        for (int varClassIndex : result2) {
            TLongIterator iterator;
            EqClass varClass = this.myEqClasses.get(varClassIndex);
            if ((++interruptCount & 0xF) == 0) {
                ProgressManager.checkCanceled();
            }
            varClass = new EqClass(varClass);
            this.myEqClasses.set(varClassIndex, varClass);
            for (int id : varClass.toNativeArray()) {
                int idUnwrapped;
                if (id != idPlain && id != idNegated && (idUnwrapped = DfaMemoryStateImpl.unwrap(this.myFactory.getValue(id)).getID()) != idPlain && idUnwrapped != idNegated) continue;
                varClass.removeValue(id);
            }
            if (varClass.isEmpty()) {
                this.myEqClasses.set(varClassIndex, null);
                iterator = this.myDistinctClasses.iterator();
                while (iterator.hasNext()) {
                    long pair = iterator.next();
                    if (DfaMemoryStateImpl.low(pair) != varClassIndex && DfaMemoryStateImpl.high(pair) != varClassIndex) continue;
                    iterator.remove();
                }
                continue;
            }
            if (!varClass.containsConstantsOnly()) continue;
            iterator = this.myDistinctClasses.iterator();
            while (iterator.hasNext()) {
                long pair = iterator.next();
                if ((DfaMemoryStateImpl.low(pair) != varClassIndex || !this.myEqClasses.get(DfaMemoryStateImpl.high(pair)).containsConstantsOnly()) && (DfaMemoryStateImpl.high(pair) != varClassIndex || !this.myEqClasses.get(DfaMemoryStateImpl.low(pair)).containsConstantsOnly())) continue;
                iterator.remove();
            }
        }
        this.removeAllFromMap(idPlain);
        this.removeAllFromMap(idNegated);
        this.myVariableStates.remove(varPlain);
        if (varNegated != null) {
            this.myVariableStates.remove(varNegated);
        }
        if (markUnknown) {
            this.myUnknownVariables.add(varPlain);
        }
        this.myCachedNonTrivialEqClasses = null;
        this.myCachedDistinctClassPairs = null;
        this.myCachedHash = null;
    }

    private class MyIdMap
    extends TIntObjectHashMap<int[]> {
        private MyIdMap(int initialCapacity) {
            super(initialCapacity);
        }

        public String toString() {
            final StringBuilder s = new StringBuilder("{");
            this.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<int[]>(){

                public boolean execute(int id, int[] set2) {
                    DfaValue value2 = DfaMemoryStateImpl.this.myFactory.getValue(id);
                    s.append(value2).append(" -> ").append(Arrays.toString(set2)).append(", ");
                    return true;
                }
            });
            s.append("}");
            return s.toString();
        }
    }
}

