/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaOptionalSupport {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.DfaOptionalSupport");
    private static final String GUAVA_OPTIONAL = "com.google.common.base.Optional";

    @Nullable
    static LocalQuickFix registerReplaceOptionalOfWithOfNullableFix(@NotNull PsiExpression qualifier) {
        PsiClass containingClass;
        PsiMethodCallExpression call = DfaOptionalSupport.findCallExpression((PsiElement)qualifier);
        PsiMethod method2 = call == null ? null : call.resolveMethod();
        PsiClass psiClass = containingClass = method2 == null ? null : method2.getContainingClass();
        if (containingClass != null && "of".equals(method2.getName())) {
            String qualifiedName = containingClass.getQualifiedName();
            if ("java.util.Optional".equals(qualifiedName)) {
                return new ReplaceOptionalCallFix("ofNullable", false);
            }
            if (GUAVA_OPTIONAL.equals(qualifiedName)) {
                return new ReplaceOptionalCallFix("fromNullable", false);
            }
        }
        return null;
    }

    private static PsiMethodCallExpression findCallExpression(@NotNull PsiElement anchor) {
        PsiElement parent;
        PsiElement argList = PsiUtil.skipParenthesizedExprUp((PsiElement)anchor).getParent();
        if (argList instanceof PsiExpressionList && (parent = argList.getParent()) instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)parent;
        }
        return null;
    }

    private static boolean isJdkOptional(@NotNull PsiElement anchor) {
        PsiMethodCallExpression parent = DfaOptionalSupport.findCallExpression(anchor);
        PsiMethod method2 = parent == null ? null : DfaOptionalSupport.resolveOfNullable(DfaOptionalSupport.findCallExpression(anchor));
        return method2 != null && "ofNullable".equals(method2.getName());
    }

    @NotNull
    static LocalQuickFix createReplaceOptionalOfNullableWithEmptyFix(@NotNull PsiElement anchor) {
        return new ReplaceOptionalCallFix(DfaOptionalSupport.isJdkOptional(anchor) ? "empty" : "absent", true);
    }

    @NotNull
    static LocalQuickFix createReplaceOptionalOfNullableWithOfFix() {
        return new ReplaceOptionalCallFix("of", false);
    }

    @Nullable
    public static PsiMethod resolveOfNullable(@NotNull PsiMethodCallExpression expression2) {
        String name = expression2.getMethodExpression().getReferenceName();
        if ("ofNullable".equals(name) || "fromNullable".equals(name)) {
            String qname;
            PsiMethod method2 = expression2.resolveMethod();
            PsiClass psiClass = method2 == null ? null : method2.getContainingClass();
            String string = qname = psiClass == null ? null : psiClass.getQualifiedName();
            if ("java.util.Optional".equals(qname) || GUAVA_OPTIONAL.equals(qname)) {
                return method2;
            }
        }
        return null;
    }

    private static class ReplaceOptionalCallFix
    implements LocalQuickFix {
        private final String myTargetMethodName;
        private final boolean myClearArguments;

        public ReplaceOptionalCallFix(String targetMethodName, boolean clearArguments) {
            this.myTargetMethodName = targetMethodName;
            this.myClearArguments = clearArguments;
        }

        @NotNull
        public String getFamilyName() {
            return "Replace with '." + this.myTargetMethodName + "()'";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethodCallExpression.class);
            if (methodCallExpression != null) {
                PsiExpressionList argList;
                PsiExpression[] args;
                PsiReferenceExpression ofNullableExprName = ((PsiMethodCallExpression)JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText("Optional." + this.myTargetMethodName + "(null)", null)).getMethodExpression();
                PsiElement referenceNameElement = methodCallExpression.getMethodExpression().getReferenceNameElement();
                if (referenceNameElement != null) {
                    PsiElement ofNullableNameElement = ofNullableExprName.getReferenceNameElement();
                    LOG.assertTrue(ofNullableNameElement != null);
                    referenceNameElement.replace(ofNullableNameElement);
                }
                if (this.myClearArguments && (args = (argList = methodCallExpression.getArgumentList()).getExpressions()).length > 0) {
                    argList.deleteChildRange((PsiElement)args[0], (PsiElement)args[args.length - 1]);
                }
            }
        }
    }
}

