/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.search.JavaNullMethodArgumentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class NullParameterConstraintChecker
extends DataFlowRunner {
    private final Set<PsiParameter> myPossiblyViolatedParameters;
    private final Set<PsiParameter> myUsedParameters;

    private NullParameterConstraintChecker(Collection<PsiParameter> parameters2, boolean isOnTheFly) {
        super(false, true, isOnTheFly);
        this.myPossiblyViolatedParameters = new THashSet(parameters2);
        this.myUsedParameters = new THashSet();
    }

    @NotNull
    static PsiParameter[] checkMethodParameters(PsiMethod method2) {
        if (method2.getBody() == null) {
            return PsiParameter.EMPTY_ARRAY;
        }
        SmartList nullableParameters = new SmartList();
        PsiParameter[] parameters2 = method2.getParameterList().getParameters();
        for (int index = 0; index < parameters2.length; ++index) {
            PsiParameter parameter = parameters2[index];
            if (parameter.getType() instanceof PsiPrimitiveType || NullableNotNullManager.isNotNull((PsiModifierListOwner)parameter) || NullableNotNullManager.isNullable((PsiModifierListOwner)parameter) || !JavaNullMethodArgumentUtil.hasNullArgument(method2, index)) continue;
            nullableParameters.add(parameter);
        }
        if (nullableParameters.isEmpty()) {
            return PsiParameter.EMPTY_ARRAY;
        }
        NullParameterConstraintChecker checker = new NullParameterConstraintChecker((Collection<PsiParameter>)nullableParameters, true);
        checker.analyzeMethod((PsiElement)method2.getBody(), new StandardInstructionVisitor());
        return (PsiParameter[])checker.myPossiblyViolatedParameters.stream().filter(checker.myUsedParameters::contains).toArray(PsiParameter[]::new);
    }

    @Override
    @NotNull
    protected DfaInstructionState[] acceptInstruction(@NotNull InstructionVisitor visitor, @NotNull DfaInstructionState instructionState) {
        PsiModifierListOwner psiVariable;
        DfaValue value2;
        PsiModifierListOwner psiVar;
        DfaValue var;
        Instruction instruction = instructionState.getInstruction();
        if (instruction instanceof PushInstruction && (var = ((PushInstruction)instruction).getValue()) instanceof DfaVariableValue && (psiVar = ((DfaVariableValue)var).getPsiVariable()) instanceof PsiParameter) {
            this.myUsedParameters.add((PsiParameter)psiVar);
        }
        if (instruction instanceof AssignInstruction && (value2 = ((AssignInstruction)instruction).getAssignedValue()) instanceof DfaVariableValue && (psiVariable = ((DfaVariableValue)value2).getPsiVariable()) instanceof PsiParameter) {
            this.myPossiblyViolatedParameters.remove(psiVariable);
        }
        if (instruction instanceof ReturnInstruction && !((ReturnInstruction)instruction).isViaException()) {
            DfaMemoryState memState = instructionState.getMemoryState();
            for (PsiParameter parameter : this.myPossiblyViolatedParameters.toArray(new PsiParameter[this.myPossiblyViolatedParameters.size()])) {
                DfaVariableValue dfaVar = this.getFactory().getVarFactory().createVariableValue((PsiVariable)parameter, false);
                if (memState.isNotNull(dfaVar)) continue;
                this.myPossiblyViolatedParameters.remove(parameter);
            }
        }
        return super.acceptInstruction(visitor, instructionState);
    }

    @Override
    @NotNull
    protected DfaMemoryState createMemoryState() {
        return new MyDfaMemoryState(this.getFactory());
    }

    private class MyDfaMemoryState
    extends DfaMemoryStateImpl {
        protected MyDfaMemoryState(DfaValueFactory factory) {
            super(factory);
            for (PsiParameter parameter : NullParameterConstraintChecker.this.myPossiblyViolatedParameters) {
                this.setVariableState(this.getFactory().getVarFactory().createVariableValue((PsiVariable)parameter, false), new DfaVariableState(Collections.emptySet(), Collections.emptySet(), Nullness.NULLABLE, ThreeState.UNSURE));
            }
        }

        protected MyDfaMemoryState(MyDfaMemoryState toCopy) {
            super(toCopy);
        }

        @Override
        public void flushVariable(@NotNull DfaVariableValue variable) {
            PsiModifierListOwner psi = variable.getPsiVariable();
            if (psi instanceof PsiParameter && NullParameterConstraintChecker.this.myPossiblyViolatedParameters.contains(psi)) {
                return;
            }
            super.flushVariable(variable);
        }

        @Override
        @NotNull
        public DfaMemoryStateImpl createCopy() {
            return new MyDfaMemoryState(this);
        }
    }
}

