/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReplaceWithObjectsEqualsFix
implements LocalQuickFix {
    private final String myQualifierText;
    private final String myReplacementText;

    private ReplaceWithObjectsEqualsFix(String qualifierText, String replacementText) {
        this.myQualifierText = qualifierText;
        this.myReplacementText = replacementText;
    }

    @Nls
    @NotNull
    public String getName() {
        return "Replace '" + this.myQualifierText + ".equals(...)' with 'Objects.equals(" + this.myReplacementText + ", ...)'";
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Replace '.equals()' with 'Objects.equals()'";
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethodCallExpression.class);
        if (call == null) {
            return;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != 1) {
            return;
        }
        String replacementText = "java.util.Objects.equals(" + this.myReplacementText + ", " + args[0].getText() + ")";
        PsiElement replaced = call.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(replacementText, (PsiElement)call));
        JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)((PsiMethodCallExpression)replaced).getMethodExpression());
    }

    @Nullable
    static ReplaceWithObjectsEqualsFix createFix(@NotNull PsiMethodCallExpression call, @NotNull PsiReferenceExpression methodExpression) {
        if (!"equals".equals(methodExpression.getReferenceName()) || call.getArgumentList().getExpressions().length != 1 || !PsiUtil.getLanguageLevel((PsiElement)call).isAtLeast(LanguageLevel.JDK_1_7)) {
            return null;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        PsiExpression noParens = PsiUtil.skipParenthesizedExprDown((PsiExpression)qualifier);
        if (noParens == null) {
            return null;
        }
        PsiMethod method2 = call.resolveMethod();
        if (method2 != null && method2.getParameterList().getParametersCount() == 1 && method2.getParameterList().getParameters()[0].getType().equalsToText("java.lang.Object")) {
            return new ReplaceWithObjectsEqualsFix(qualifier.getText(), noParens.getText());
        }
        return null;
    }
}

