/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityProblem;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FieldReferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardInstructionVisitor
extends InstructionVisitor {
    private static final Set<String> OPTIONAL_METHOD_NAMES = ContainerUtil.set((Object[])new String[]{"isPresent", "of", "ofNullable", "fromNullable", "empty", "absent", "or", "orElseGet", "ifPresent", "map", "flatMap", "filter", "transform"});
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.StandardInstructionVisitor");
    private static final Object ANY_VALUE = new Object();
    private final Set<BinopInstruction> myReachable = new THashSet();
    private final Set<BinopInstruction> myCanBeNullInInstanceof = new THashSet();
    private final MultiMap<PushInstruction, Object> myPossibleVariableValues = MultiMap.createSet();
    private final Set<PsiElement> myNotToReportReachability = new THashSet();
    private final Set<InstanceofInstruction> myUsefulInstanceofs = new THashSet();
    private final FactoryMap<MethodCallInstruction, Nullness> myReturnTypeNullability = new FactoryMap<MethodCallInstruction, Nullness>(){

        protected Nullness create(MethodCallInstruction key2) {
            PsiCall callExpression = key2.getCallExpression();
            if (callExpression instanceof PsiNewExpression) {
                return Nullness.NOT_NULL;
            }
            return callExpression != null ? DfaPsiUtil.getElementNullability(key2.getResultType(), (PsiModifierListOwner)callExpression.resolveMethod()) : null;
        }
    };

    @Override
    public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaSource = memState.pop();
        DfaValue dfaDest = memState.pop();
        if (dfaDest instanceof DfaVariableValue) {
            boolean forceDeclaredNullity;
            DfaVariableValue var = (DfaVariableValue)dfaDest;
            PsiModifierListOwner psi = var.getPsiVariable();
            boolean bl = forceDeclaredNullity = !(psi instanceof PsiParameter) || !(psi.getParent() instanceof PsiParameterList);
            if (forceDeclaredNullity && var.getInherentNullability() == Nullness.NOT_NULL) {
                this.checkNotNullable(memState, dfaSource, NullabilityProblem.assigningToNotNull, (PsiElement)instruction.getRExpression());
            }
            if (!(psi instanceof PsiField) || !psi.hasModifierProperty("volatile")) {
                memState.setVarValue(var, dfaSource);
            }
            if (var.getInherentNullability() == Nullness.NULLABLE && !memState.isNotNull(dfaSource) && instruction.isVariableInitializer()) {
                DfaMemoryStateImpl stateImpl = (DfaMemoryStateImpl)memState;
                stateImpl.setVariableState(var, stateImpl.getVariableState(var).withNullability(Nullness.NULLABLE));
            }
        } else if (dfaDest instanceof DfaTypeValue && ((DfaTypeValue)dfaDest).isNotNull()) {
            this.checkNotNullable(memState, dfaSource, NullabilityProblem.assigningToNotNull, (PsiElement)instruction.getRExpression());
        }
        memState.push(dfaDest);
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitCheckReturnValue(CheckReturnValueInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue retValue = memState.pop();
        this.checkNotNullable(memState, retValue, NullabilityProblem.nullableReturn, instruction.getReturn());
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitFieldReference(FieldReferenceInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue qualifier = memState.pop();
        if (!this.checkNotNullable(memState, qualifier, NullabilityProblem.fieldAccessNPE, (PsiElement)instruction.getElementToAssert())) {
            StandardInstructionVisitor.forceNotNull(runner, memState, qualifier);
        }
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitPush(PushInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dfaValue;
        PsiExpression place = instruction.getPlace();
        if (!instruction.isReferenceWrite() && place instanceof PsiReferenceExpression && (dfaValue = instruction.getValue()) instanceof DfaVariableValue) {
            DfaConstValue constValue = memState.getConstantValue((DfaVariableValue)dfaValue);
            boolean report = constValue != null && StandardInstructionVisitor.shouldReportConstValue(constValue.getValue(), (PsiElement)place);
            this.myPossibleVariableValues.putValue((Object)instruction, report ? constValue : ANY_VALUE);
        }
        return super.visitPush(instruction, runner, memState);
    }

    private static boolean shouldReportConstValue(Object value2, PsiElement place) {
        return value2 == null || value2 instanceof Boolean || value2.equals(new Long(0L)) && StandardInstructionVisitor.isDivider(PsiUtil.skipParenthesizedExprUp((PsiElement)place));
    }

    private static boolean isDivider(PsiElement expr) {
        PsiElement parent = expr.getParent();
        if (parent instanceof PsiBinaryExpression) {
            return ControlFlowAnalyzer.isBinaryDivision(((PsiBinaryExpression)parent).getOperationTokenType()) && ((PsiBinaryExpression)parent).getROperand() == expr;
        }
        if (parent instanceof PsiAssignmentExpression) {
            return ControlFlowAnalyzer.isAssignmentDivision(((PsiAssignmentExpression)parent).getOperationTokenType()) && ((PsiAssignmentExpression)parent).getRExpression() == expr;
        }
        return false;
    }

    public List<Pair<PsiReferenceExpression, DfaConstValue>> getConstantReferenceValues() {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (PushInstruction instruction : this.myPossibleVariableValues.keySet()) {
            Object singleValue;
            Collection values = this.myPossibleVariableValues.get((Object)instruction);
            if (values.size() != 1 || (singleValue = values.iterator().next()) == ANY_VALUE) continue;
            result2.add(Pair.create((Object)((PsiReferenceExpression)instruction.getPlace()), (Object)((DfaConstValue)singleValue)));
        }
        return result2;
    }

    @Override
    public DfaInstructionState[] visitTypeCast(TypeCastInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValueFactory factory = runner.getFactory();
        DfaValue dfaExpr = factory.createValue(instruction.getCasted());
        if (dfaExpr != null) {
            DfaTypeValue dfaType = (DfaTypeValue)factory.createTypeValue(instruction.getCastTo(), Nullness.UNKNOWN);
            DfaRelationValue dfaInstanceof = factory.getRelationFactory().createRelation(dfaExpr, dfaType, JavaTokenType.INSTANCEOF_KEYWORD, false);
            if (dfaInstanceof != null && !memState.applyInstanceofOrNull(dfaInstanceof)) {
                this.onInstructionProducesCCE(instruction);
            }
        }
        if (instruction.getCastTo() instanceof PsiPrimitiveType) {
            memState.push(runner.getFactory().getBoxedFactory().createUnboxed(memState.pop()));
        }
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    protected void onInstructionProducesCCE(TypeCastInstruction instruction) {
    }

    @Override
    public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        LinkedHashSet finalStates = ContainerUtil.newLinkedHashSet();
        finalStates.addAll(this.handleOptionalMethods(instruction, runner, memState));
        if (finalStates.isEmpty()) {
            DfaValue[] argValues = this.popCallArguments(instruction, runner, memState);
            DfaValue qualifier = this.popQualifier(instruction, runner, memState);
            LinkedHashSet currentStates = ContainerUtil.newLinkedHashSet((Object[])new DfaMemoryState[]{memState});
            if (argValues != null) {
                for (MethodContract contract : instruction.getContracts()) {
                    currentStates = this.addContractResults(argValues, contract, currentStates, instruction, runner.getFactory(), finalStates);
                    if (currentStates.size() + finalStates.size() <= 300) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Too complex contract on " + instruction.getContext() + ", skipping contract processing");
                    }
                    finalStates.clear();
                    currentStates = ContainerUtil.newLinkedHashSet((Object[])new DfaMemoryState[]{memState});
                    break;
                }
            }
            for (DfaMemoryState state : currentStates) {
                state.push(this.getMethodResultValue(instruction, qualifier, runner.getFactory()));
                finalStates.add(state);
            }
        }
        DfaInstructionState[] result2 = new DfaInstructionState[finalStates.size()];
        int i = 0;
        for (DfaMemoryState state : finalStates) {
            if (instruction.shouldFlushFields()) {
                state.flushFields();
            }
            result2[i++] = new DfaInstructionState(runner.getInstruction(instruction.getIndex() + 1), state);
        }
        return result2;
    }

    @NotNull
    private List<DfaMemoryState> handleOptionalMethods(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)instruction.getCallExpression(), PsiMethodCallExpression.class);
        if (call == null) {
            return Collections.emptyList();
        }
        String methodName = call.getMethodExpression().getReferenceName();
        if (methodName == null || !OPTIONAL_METHOD_NAMES.contains(methodName)) {
            return Collections.emptyList();
        }
        PsiMethod method2 = call.resolveMethod();
        if (method2 == null || !TypeUtils.isOptional(method2.getContainingClass())) {
            return Collections.emptyList();
        }
        List<DfaMemoryState> closures = runner.getStackTopClosures();
        DfaValue[] argValues = this.popCallArguments(instruction, runner, memState);
        DfaValue qualifier = this.popQualifier(instruction, runner, memState);
        switch (methodName) {
            case "isPresent": {
                ThreeState state = memState.checkOptional(qualifier);
                DfaConstValue.Factory constFactory = runner.getFactory().getConstFactory();
                if (state == ThreeState.UNSURE) {
                    DfaMemoryState falseState = memState.createCopy();
                    memState.push(constFactory.getTrue());
                    memState.applyIsPresentCheck(true, qualifier);
                    falseState.push(constFactory.getFalse());
                    falseState.applyIsPresentCheck(false, qualifier);
                    return Arrays.asList(memState, falseState);
                }
                memState.push(state == ThreeState.YES ? constFactory.getTrue() : constFactory.getFalse());
                break;
            }
            case "of": 
            case "ofNullable": 
            case "fromNullable": {
                if ("of".equals(methodName) || argValues != null && argValues.length == 1 && memState.isNotNull(argValues[0])) {
                    memState.push(runner.getFactory().getOptionalFactory().getOptional(true));
                    break;
                }
                memState.push(this.getMethodResultValue(instruction, qualifier, runner.getFactory()));
                break;
            }
            case "empty": 
            case "absent": {
                memState.push(runner.getFactory().getOptionalFactory().getOptional(false));
                break;
            }
            case "filter": 
            case "flatMap": 
            case "ifPresent": 
            case "map": 
            case "or": 
            case "orElseGet": 
            case "transform": {
                for (DfaMemoryState closure : closures) {
                    closure.applyIsPresentCheck(!methodName.startsWith("or"), qualifier);
                }
                memState.push(this.getMethodResultValue(instruction, qualifier, runner.getFactory()));
                break;
            }
            default: {
                memState.push(this.getMethodResultValue(instruction, qualifier, runner.getFactory()));
            }
        }
        return Collections.singletonList(memState);
    }

    @Nullable
    private DfaValue[] popCallArguments(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue[] argValues;
        PsiExpression[] args = instruction.getArgs();
        PsiMethod method2 = instruction.getTargetMethod();
        boolean varargCall = instruction.isVarArgCall();
        if (method2 == null || instruction.getContracts().isEmpty()) {
            argValues = null;
        } else {
            PsiParameterList paramList = method2.getParameterList();
            int paramCount = paramList.getParametersCount();
            if (paramCount == args.length || method2.isVarArgs() && args.length >= paramCount - 1) {
                argValues = new DfaValue[paramCount];
                if (varargCall) {
                    argValues[paramCount - 1] = runner.getFactory().createTypeValue(paramList.getParameters()[paramCount - 1].getType(), Nullness.NOT_NULL);
                }
            } else {
                argValues = null;
            }
        }
        for (int i = 0; i < args.length; ++i) {
            PsiExpression expr;
            Nullness requiredNullability;
            DfaValue arg = memState.pop();
            int paramIndex = args.length - i - 1;
            if (!(argValues == null || paramIndex >= argValues.length - 1 && varargCall)) {
                argValues[paramIndex] = arg;
            }
            if ((requiredNullability = instruction.getArgRequiredNullability(expr = args[paramIndex])) == Nullness.NOT_NULL) {
                if (this.checkNotNullable(memState, arg, NullabilityProblem.passingNullableToNotNullParameter, (PsiElement)expr)) continue;
                StandardInstructionVisitor.forceNotNull(runner, memState, arg);
                continue;
            }
            if (instruction.updateOfNullable(memState, arg) || requiredNullability != Nullness.UNKNOWN) continue;
            this.checkNotNullable(memState, arg, NullabilityProblem.passingNullableArgumentToNonAnnotatedParameter, (PsiElement)expr);
        }
        return argValues;
    }

    private DfaValue popQualifier(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        PsiElement anchor;
        DfaValue qualifier = memState.pop();
        boolean unboxing = instruction.getMethodType() == MethodCallInstruction.MethodType.UNBOXING;
        NullabilityProblem problem = unboxing ? NullabilityProblem.unboxingNullable : NullabilityProblem.callNPE;
        Object object = anchor = unboxing ? instruction.getContext() : instruction.getCallExpression();
        if (!this.checkNotNullable(memState, qualifier, problem, anchor)) {
            StandardInstructionVisitor.forceNotNull(runner, memState, qualifier);
        }
        return qualifier;
    }

    private LinkedHashSet<DfaMemoryState> addContractResults(DfaValue[] argValues, MethodContract contract, LinkedHashSet<DfaMemoryState> states, MethodCallInstruction instruction, DfaValueFactory factory, Set<DfaMemoryState> finalStates) {
        DfaConstValue.Factory constFactory = factory.getConstFactory();
        LinkedHashSet falseStates = ContainerUtil.newLinkedHashSet();
        for (int i = 0; i < argValues.length; ++i) {
            DfaValue argValue = argValues[i];
            MethodContract.ValueConstraint constraint = contract.arguments[i];
            DfaConstValue expectedValue = constraint.getComparisonValue(factory);
            if (expectedValue == null) continue;
            boolean nullContract = expectedValue == constFactory.getNull();
            boolean invertCondition = constraint.shouldUseNonEqComparison();
            DfaValue condition2 = factory.getRelationFactory().createRelation(argValue, expectedValue, JavaTokenType.EQEQ, invertCondition);
            if (condition2 == null) {
                if (!(argValue instanceof DfaConstValue)) {
                    for (DfaMemoryState state : states) {
                        DfaMemoryState falseCopy = state.createCopy();
                        if (nullContract) {
                            (invertCondition ? falseCopy : state).markEphemeral();
                        }
                        falseStates.add(falseCopy);
                    }
                    continue;
                }
                condition2 = constFactory.createFromValue(argValue == expectedValue != invertCondition, (PsiType)PsiType.BOOLEAN, null);
            }
            LinkedHashSet nextStates = ContainerUtil.newLinkedHashSet();
            for (DfaMemoryState state : states) {
                boolean unknownVsNull = nullContract && argValue instanceof DfaVariableValue && ((DfaMemoryStateImpl)state).getVariableState((DfaVariableValue)argValue).getNullability() == Nullness.UNKNOWN;
                DfaMemoryState falseCopy = state.createCopy();
                if (state.applyCondition(condition2)) {
                    if (unknownVsNull && !invertCondition) {
                        state.markEphemeral();
                    }
                    nextStates.add(state);
                }
                if (!falseCopy.applyCondition(condition2.createNegated())) continue;
                if (unknownVsNull && invertCondition) {
                    falseCopy.markEphemeral();
                }
                falseStates.add(falseCopy);
            }
            states = nextStates;
        }
        for (DfaMemoryState state : states) {
            state.push(this.getDfaContractReturnValue(contract, instruction, factory));
            finalStates.add(state);
        }
        return falseStates;
    }

    private DfaValue getDfaContractReturnValue(MethodContract contract, MethodCallInstruction instruction, DfaValueFactory factory) {
        switch (contract.returnValue) {
            case NULL_VALUE: {
                return factory.getConstFactory().getNull();
            }
            case NOT_NULL_VALUE: {
                return factory.createTypeValue(instruction.getResultType(), Nullness.NOT_NULL);
            }
            case TRUE_VALUE: {
                return factory.getConstFactory().getTrue();
            }
            case FALSE_VALUE: {
                return factory.getConstFactory().getFalse();
            }
            case THROW_EXCEPTION: {
                return factory.getConstFactory().getContractFail();
            }
        }
        return this.getMethodResultValue(instruction, null, factory);
    }

    private static void forceNotNull(DataFlowRunner runner, DfaMemoryState memState, DfaValue arg) {
        if (arg instanceof DfaVariableValue) {
            DfaVariableValue var = (DfaVariableValue)arg;
            memState.setVarValue(var, runner.getFactory().createTypeValue(var.getVariableType(), Nullness.NOT_NULL));
        }
    }

    @NotNull
    private DfaValue getMethodResultValue(MethodCallInstruction instruction, @Nullable DfaValue qualifierValue, DfaValueFactory factory) {
        DfaValue precalculated = instruction.getPrecalculatedReturnValue();
        if (precalculated != null) {
            return precalculated;
        }
        PsiType type2 = instruction.getResultType();
        MethodCallInstruction.MethodType methodType = instruction.getMethodType();
        if (methodType == MethodCallInstruction.MethodType.UNBOXING) {
            return factory.getBoxedFactory().createUnboxed(qualifierValue);
        }
        if (methodType == MethodCallInstruction.MethodType.BOXING) {
            DfaValue boxed = factory.getBoxedFactory().createBoxed(qualifierValue);
            return boxed == null ? factory.createTypeValue(type2, Nullness.NOT_NULL) : boxed;
        }
        if (methodType == MethodCallInstruction.MethodType.CAST) {
            assert (qualifierValue != null);
            if (qualifierValue instanceof DfaConstValue) {
                Object casted = TypeConversionUtil.computeCastTo((Object)((DfaConstValue)qualifierValue).getValue(), (PsiType)type2);
                return factory.getConstFactory().createFromValue(casted, type2, ((DfaConstValue)qualifierValue).getConstant());
            }
            return qualifierValue;
        }
        if (type2 != null && !(type2 instanceof PsiPrimitiveType)) {
            Nullness nullability = (Nullness)((Object)this.myReturnTypeNullability.get((Object)instruction));
            if (nullability == Nullness.UNKNOWN && factory.isUnknownMembersAreNullable()) {
                nullability = Nullness.NULLABLE;
            }
            return factory.createTypeValue(type2, nullability);
        }
        return DfaUnknownValue.getInstance();
    }

    protected boolean checkNotNullable(DfaMemoryState state, DfaValue value2, NullabilityProblem problem, PsiElement anchor) {
        boolean notNullable = state.checkNotNullable(value2);
        if (notNullable && problem != NullabilityProblem.passingNullableArgumentToNonAnnotatedParameter) {
            DfaValueFactory factory = ((DfaMemoryStateImpl)state).getFactory();
            state.applyCondition(factory.getRelationFactory().createRelation(value2, factory.getConstFactory().getNull(), JavaTokenType.NE, false));
        }
        return notNullable;
    }

    @Override
    public DfaInstructionState[] visitBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        this.myReachable.add(instruction);
        DfaValue dfaRight = memState.pop();
        DfaValue dfaLeft = memState.pop();
        IElementType opSign = instruction.getOperationSign();
        if (opSign != null) {
            DfaInstructionState[] states = StandardInstructionVisitor.handleConstantComparison(instruction, runner, memState, dfaRight, dfaLeft, opSign);
            if (states == null) {
                states = this.handleRelationBinop(instruction, runner, memState, dfaRight, dfaLeft);
            }
            if (states != null) {
                return states;
            }
            if (JavaTokenType.PLUS == opSign) {
                memState.push(instruction.getNonNullStringValue(runner.getFactory()));
            } else {
                if (instruction instanceof InstanceofInstruction) {
                    this.handleInstanceof((InstanceofInstruction)instruction, dfaRight, dfaLeft);
                }
                memState.push(DfaUnknownValue.getInstance());
            }
        } else {
            memState.push(DfaUnknownValue.getInstance());
        }
        instruction.setTrueReachable();
        instruction.setFalseReachable();
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    @Nullable
    private DfaInstructionState[] handleRelationBinop(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaRight, DfaValue dfaLeft) {
        DfaMemoryState falseCopy;
        DfaValueFactory factory = runner.getFactory();
        Instruction next = runner.getInstruction(instruction.getIndex() + 1);
        DfaRelationValue dfaRelation = factory.getRelationFactory().createRelation(dfaLeft, dfaRight, instruction.getOperationSign(), false);
        if (dfaRelation == null) {
            return null;
        }
        this.myCanBeNullInInstanceof.add(instruction);
        ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>();
        DfaMemoryState trueCopy = memState.createCopy();
        if (trueCopy.applyCondition(dfaRelation)) {
            trueCopy.push(factory.getConstFactory().getTrue());
            instruction.setTrueReachable();
            states.add(new DfaInstructionState(next, trueCopy));
        }
        if ((falseCopy = memState).applyCondition(dfaRelation.createNegated())) {
            falseCopy.push(factory.getConstFactory().getFalse());
            instruction.setFalseReachable();
            states.add(new DfaInstructionState(next, falseCopy));
            if (instruction instanceof InstanceofInstruction && !falseCopy.isNull(dfaLeft)) {
                this.myUsefulInstanceofs.add((InstanceofInstruction)instruction);
            }
        }
        return states.toArray(new DfaInstructionState[states.size()]);
    }

    public void skipConstantConditionReporting(@Nullable PsiElement anchor) {
        ContainerUtil.addIfNotNull(this.myNotToReportReachability, (Object)anchor);
    }

    private void handleInstanceof(InstanceofInstruction instruction, DfaValue dfaRight, DfaValue dfaLeft) {
        if (dfaLeft instanceof DfaTypeValue && dfaRight instanceof DfaTypeValue) {
            if (!((DfaTypeValue)dfaLeft).isNotNull()) {
                this.myCanBeNullInInstanceof.add(instruction);
            }
            if (((DfaTypeValue)dfaRight).getDfaType().isAssignableFrom(((DfaTypeValue)dfaLeft).getDfaType())) {
                return;
            }
        }
        this.myUsefulInstanceofs.add(instruction);
    }

    @Nullable
    private static DfaInstructionState[] handleConstantComparison(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaValue dfaRight, DfaValue dfaLeft, IElementType opSign) {
        DfaInstructionState[] result2;
        Object value2;
        if (dfaLeft instanceof DfaVariableValue && dfaRight instanceof DfaVariableValue) {
            Number leftValue = StandardInstructionVisitor.getKnownNumberValue(memState, (DfaVariableValue)dfaLeft);
            Number rightValue = StandardInstructionVisitor.getKnownNumberValue(memState, (DfaVariableValue)dfaRight);
            if (leftValue != null && rightValue != null) {
                return StandardInstructionVisitor.checkComparisonWithKnownValue(instruction, runner, memState, opSign, leftValue, rightValue);
            }
        }
        if (dfaRight instanceof DfaConstValue && dfaLeft instanceof DfaVariableValue && (value2 = ((DfaConstValue)dfaRight).getValue()) instanceof Number && (result2 = StandardInstructionVisitor.checkComparingWithConstant(instruction, runner, memState, (DfaVariableValue)dfaLeft, opSign, (Number)value2)) != null) {
            return result2;
        }
        if (dfaRight instanceof DfaVariableValue && dfaLeft instanceof DfaConstValue) {
            return StandardInstructionVisitor.handleConstantComparison(instruction, runner, memState, dfaLeft, dfaRight, DfaRelationValue.getSymmetricOperation(opSign));
        }
        if (JavaTokenType.EQEQ != opSign && JavaTokenType.NE != opSign) {
            return null;
        }
        if (dfaLeft instanceof DfaConstValue && dfaRight instanceof DfaConstValue || dfaLeft == runner.getFactory().getConstFactory().getContractFail() || dfaRight == runner.getFactory().getConstFactory().getContractFail()) {
            boolean negated;
            if (dfaLeft == dfaRight ^ (negated = JavaTokenType.NE == opSign ^ (DfaMemoryStateImpl.isNaN(dfaLeft) || DfaMemoryStateImpl.isNaN(dfaRight)))) {
                return StandardInstructionVisitor.alwaysTrue(instruction, runner, memState);
            }
            return StandardInstructionVisitor.alwaysFalse(instruction, runner, memState);
        }
        return null;
    }

    @Nullable
    private static DfaInstructionState[] checkComparingWithConstant(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, DfaVariableValue var, IElementType opSign, Number comparedWith) {
        double minValue;
        Number knownValue = StandardInstructionVisitor.getKnownNumberValue(memState, var);
        if (knownValue != null) {
            return StandardInstructionVisitor.checkComparisonWithKnownValue(instruction, runner, memState, opSign, knownValue, comparedWith);
        }
        PsiType varType = var.getVariableType();
        if (!(varType instanceof PsiPrimitiveType)) {
            return null;
        }
        if (PsiType.FLOAT.equals((Object)varType) || PsiType.DOUBLE.equals((Object)varType)) {
            return null;
        }
        double d = PsiType.BYTE.equals((Object)varType) ? -128.0 : (PsiType.SHORT.equals((Object)varType) ? -32768.0 : (PsiType.INT.equals((Object)varType) ? -2.147483648E9 : (minValue = PsiType.CHAR.equals((Object)varType) ? 0.0 : -9.223372036854776E18)));
        double maxValue = PsiType.BYTE.equals((Object)varType) ? 127.0 : (PsiType.SHORT.equals((Object)varType) ? 32767.0 : (PsiType.INT.equals((Object)varType) ? 2.147483647E9 : (PsiType.CHAR.equals((Object)varType) ? 65535.0 : 9.223372036854776E18)));
        return StandardInstructionVisitor.checkComparisonWithKnownRange(instruction, runner, memState, opSign, comparedWith, minValue, maxValue);
    }

    @Nullable
    private static Number getKnownNumberValue(DfaMemoryState memState, DfaVariableValue var) {
        DfaConstValue knownConstantValue = memState.getConstantValue(var);
        return knownConstantValue != null && knownConstantValue.getValue() instanceof Number ? (Number)((Number)knownConstantValue.getValue()) : (Number)null;
    }

    private static DfaInstructionState[] checkComparisonWithKnownValue(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, IElementType opSign, Number leftValue, Number rightValue) {
        return StandardInstructionVisitor.checkComparisonWithKnownRange(instruction, runner, memState, opSign, rightValue, leftValue, leftValue);
    }

    private static int compare(Number a, Number b) {
        long bLong;
        long aLong = a.longValue();
        if (aLong != (bLong = b.longValue())) {
            return aLong > bLong ? 1 : -1;
        }
        return Double.compare(a.doubleValue(), b.doubleValue());
    }

    @Nullable
    private static DfaInstructionState[] checkComparisonWithKnownRange(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState, IElementType opSign, Number comparedWith, Number rangeMin, Number rangeMax) {
        if (StandardInstructionVisitor.compare(comparedWith, rangeMin) < 0 || StandardInstructionVisitor.compare(comparedWith, rangeMax) > 0) {
            if (opSign == JavaTokenType.EQEQ) {
                return StandardInstructionVisitor.alwaysFalse(instruction, runner, memState);
            }
            if (opSign == JavaTokenType.NE) {
                return StandardInstructionVisitor.alwaysTrue(instruction, runner, memState);
            }
        }
        if (opSign == JavaTokenType.LT && StandardInstructionVisitor.compare(comparedWith, rangeMin) <= 0) {
            return StandardInstructionVisitor.alwaysFalse(instruction, runner, memState);
        }
        if (opSign == JavaTokenType.LT && StandardInstructionVisitor.compare(comparedWith, rangeMax) > 0) {
            return StandardInstructionVisitor.alwaysTrue(instruction, runner, memState);
        }
        if (opSign == JavaTokenType.LE && StandardInstructionVisitor.compare(comparedWith, rangeMax) >= 0) {
            return StandardInstructionVisitor.alwaysTrue(instruction, runner, memState);
        }
        if (opSign == JavaTokenType.LE && StandardInstructionVisitor.compare(comparedWith, rangeMin) < 0) {
            return StandardInstructionVisitor.alwaysFalse(instruction, runner, memState);
        }
        if (opSign == JavaTokenType.GT && StandardInstructionVisitor.compare(comparedWith, rangeMax) >= 0) {
            return StandardInstructionVisitor.alwaysFalse(instruction, runner, memState);
        }
        if (opSign == JavaTokenType.GT && StandardInstructionVisitor.compare(comparedWith, rangeMin) < 0) {
            return StandardInstructionVisitor.alwaysTrue(instruction, runner, memState);
        }
        if (opSign == JavaTokenType.GE && StandardInstructionVisitor.compare(comparedWith, rangeMin) <= 0) {
            return StandardInstructionVisitor.alwaysTrue(instruction, runner, memState);
        }
        if (opSign == JavaTokenType.GE && StandardInstructionVisitor.compare(comparedWith, rangeMax) > 0) {
            return StandardInstructionVisitor.alwaysFalse(instruction, runner, memState);
        }
        return null;
    }

    private static DfaInstructionState[] alwaysFalse(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.push(runner.getFactory().getConstFactory().getFalse());
        instruction.setFalseReachable();
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    private static DfaInstructionState[] alwaysTrue(BinopInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        memState.push(runner.getFactory().getConstFactory().getTrue());
        instruction.setTrueReachable();
        return StandardInstructionVisitor.nextInstruction(instruction, runner, memState);
    }

    public boolean isInstanceofRedundant(InstanceofInstruction instruction) {
        return !this.myUsefulInstanceofs.contains(instruction) && !instruction.isConditionConst() && this.myReachable.contains(instruction);
    }

    public boolean canBeNull(BinopInstruction instruction) {
        return this.myCanBeNullInInstanceof.contains(instruction);
    }

    public boolean silenceConstantCondition(@Nullable PsiElement element) {
        for (PsiElement skipped : this.myNotToReportReachability) {
            if (!PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)skipped, (boolean)false)) continue;
            return true;
        }
        return false;
    }
}

