/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaVariableState;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.psi.JavaTokenType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StateMerger {
    private final Map<DfaMemoryStateImpl, Set<Fact>> myFacts = ContainerUtil.newIdentityHashMap();
    private final Map<DfaMemoryState, Map<DfaVariableValue, DfaMemoryStateImpl>> myCopyCache = ContainerUtil.newIdentityHashMap();

    StateMerger() {
    }

    @Nullable
    List<DfaMemoryStateImpl> mergeByFacts(@NotNull List<DfaMemoryStateImpl> states) {
        MultiMap statesByFact = MultiMap.createLinked();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            for (Fact fact : this.getFacts(state)) {
                statesByFact.putValue((Object)fact, (Object)state);
            }
        }
        for (Fact fact : statesByFact.keySet()) {
            Collection statesWithNegations;
            if (statesByFact.get((Object)fact).size() == states.size() || fact.myPositive || (statesWithNegations = statesByFact.get((Object)fact.getPositiveCounterpart())).isEmpty()) continue;
            ProgressManager.checkCanceled();
            MultiMap<Set<Fact>, DfaMemoryStateImpl> statesByUnrelatedFacts1 = this.mapByUnrelatedFacts(fact, statesByFact.get((Object)fact));
            MultiMap<Set<Fact>, DfaMemoryStateImpl> statesByUnrelatedFacts2 = this.mapByUnrelatedFacts(fact, statesWithNegations);
            Replacements replacements = new Replacements(states);
            for (Set key2 : statesByUnrelatedFacts1.keySet()) {
                Collection group1 = statesByUnrelatedFacts1.get((Object)key2);
                Collection group2 = statesByUnrelatedFacts2.get((Object)key2);
                if (group1.isEmpty() || group2.isEmpty()) continue;
                ArrayList group = ContainerUtil.newArrayList((Iterable)ContainerUtil.concat((Iterable[])new Iterable[]{group1, group2}));
                Set<DfaVariableValue> unknowns = StateMerger.getAllUnknownVariables(group);
                replacements.stripAndMerge(group, (Function<DfaMemoryStateImpl, DfaMemoryStateImpl>)original -> {
                    DfaMemoryStateImpl copy = StateMerger.withUnknownVariables(original, unknowns);
                    fact.removeFromState(copy);
                    if (fact.myType == FactType.equality) {
                        this.restoreOtherInequalities(fact, group, copy);
                    }
                    return copy;
                });
            }
            if (!replacements.hasMerges()) continue;
            return replacements.getMergeResult();
        }
        return null;
    }

    @NotNull
    private MultiMap<Set<Fact>, DfaMemoryStateImpl> mapByUnrelatedFacts(@NotNull Fact fact, @NotNull Collection<DfaMemoryStateImpl> states1) {
        MultiMap statesByUnrelatedFacts1 = MultiMap.createLinked();
        for (DfaMemoryStateImpl state : states1) {
            statesByUnrelatedFacts1.putValue(this.getUnrelatedFacts(fact, state), (Object)state);
        }
        return statesByUnrelatedFacts1;
    }

    @NotNull
    private LinkedHashSet<Fact> getUnrelatedFacts(@NotNull Fact fact, @NotNull DfaMemoryStateImpl state) {
        return new LinkedHashSet<Fact>(ContainerUtil.filter(this.getFacts(state), another -> !fact.invalidatesFact((Fact)another)));
    }

    private void restoreOtherInequalities(@NotNull Fact removedFact, @NotNull Collection<DfaMemoryStateImpl> mergedGroup, @NotNull DfaMemoryStateImpl state) {
        Set<DfaConstValue> inequalitiesToRestore = null;
        for (DfaMemoryStateImpl member : mergedGroup) {
            Set<Fact> memberFacts = this.getFacts(member);
            if (!memberFacts.contains(removedFact)) continue;
            Set<DfaConstValue> otherInequalities = StateMerger.getOtherInequalities(removedFact, memberFacts, member);
            if (inequalitiesToRestore == null) {
                inequalitiesToRestore = otherInequalities;
                continue;
            }
            inequalitiesToRestore.retainAll(otherInequalities);
        }
        if (inequalitiesToRestore != null) {
            DfaRelationValue.Factory relationFactory = state.getFactory().getRelationFactory();
            for (DfaConstValue toRestore : inequalitiesToRestore) {
                state.applyCondition(relationFactory.createRelation(removedFact.myVar, toRestore, JavaTokenType.EQEQ, true));
            }
        }
    }

    @NotNull
    private static Set<DfaConstValue> getOtherInequalities(@NotNull Fact removedFact, @NotNull Set<Fact> memberFacts, @NotNull DfaMemoryStateImpl state) {
        LinkedHashSet otherInequalities = ContainerUtil.newLinkedHashSet();
        HashSet eqValues = ContainerUtil.newHashSet(state.getEquivalentValues((DfaValue)removedFact.myArg));
        for (Fact candidate : memberFacts) {
            if (candidate.myType != FactType.equality || candidate.myPositive || candidate.myVar != removedFact.myVar || eqValues.contains((DfaValue)candidate.myArg) || !(candidate.myArg instanceof DfaConstValue)) continue;
            otherInequalities.add((DfaConstValue)candidate.myArg);
        }
        return otherInequalities;
    }

    @NotNull
    private static Set<DfaVariableValue> getAllUnknownVariables(@NotNull Collection<DfaMemoryStateImpl> complementary) {
        LinkedHashSet toFlush = ContainerUtil.newLinkedHashSet();
        for (DfaMemoryStateImpl removedState : complementary) {
            toFlush.addAll(removedState.getUnknownVariables());
        }
        return toFlush;
    }

    @NotNull
    private static DfaMemoryStateImpl withUnknownVariables(@NotNull DfaMemoryStateImpl original, @NotNull Set<DfaVariableValue> toFlush) {
        DfaMemoryStateImpl copy = original.createCopy();
        for (DfaVariableValue value2 : toFlush) {
            copy.doFlush(value2, true);
        }
        return copy;
    }

    @Nullable
    List<DfaMemoryStateImpl> mergeByUnknowns(@NotNull List<DfaMemoryStateImpl> states) {
        MultiMap byHash = new MultiMap();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            byHash.putValue((Object)state.getPartialHashCode(false, true), (Object)state);
        }
        Replacements replacements = new Replacements(states);
        block1: for (Integer key2 : byHash.keySet()) {
            Collection similarStates = byHash.get((Object)key2);
            if (similarStates.size() < 2) continue;
            for (DfaMemoryStateImpl state1 : similarStates) {
                ProgressManager.checkCanceled();
                List complementary = ContainerUtil.filter((Collection)similarStates, state2 -> state1.equalsByRelations((DfaMemoryStateImpl)state2) && state1.equalsByVariableStates((DfaMemoryStateImpl)state2));
                if (!StateMerger.mergeUnknowns(replacements, complementary)) continue;
                continue block1;
            }
        }
        return replacements.getMergeResult();
    }

    @Nullable
    List<DfaMemoryStateImpl> mergeByNullability(List<DfaMemoryStateImpl> states) {
        MultiMap byHash = new MultiMap();
        for (DfaMemoryStateImpl state : states) {
            ProgressManager.checkCanceled();
            byHash.putValue((Object)state.getPartialHashCode(false, false), (Object)state);
        }
        Replacements replacements = new Replacements(states);
        block1: for (Integer key2 : byHash.keySet()) {
            Collection similarStates = byHash.get((Object)key2);
            if (similarStates.size() < 2) continue;
            for (DfaMemoryStateImpl state1 : similarStates) {
                ProgressManager.checkCanceled();
                for (DfaVariableValue var : state1.getChangedVariables()) {
                    List complementary;
                    if (state1.getVariableState(var).getNullability() != Nullness.NULLABLE || !StateMerger.mergeUnknowns(replacements, complementary = ContainerUtil.filter((Collection)similarStates, state2 -> state1.equalsByRelations((DfaMemoryStateImpl)state2) && this.areEquivalentModuloVar(state1, (DfaMemoryStateImpl)state2, var) && StateMerger.areVarStatesEqualModuloNullability(state1, state2, var)))) continue;
                    continue block1;
                }
            }
        }
        return replacements.getMergeResult();
    }

    private static boolean mergeUnknowns(@NotNull Replacements replacements, @NotNull List<DfaMemoryStateImpl> complementary) {
        if (complementary.size() < 2) {
            return false;
        }
        Set<DfaVariableValue> toFlush = StateMerger.getAllUnknownVariables(complementary);
        if (toFlush.isEmpty()) {
            return false;
        }
        return replacements.stripAndMerge(complementary, (Function<DfaMemoryStateImpl, DfaMemoryStateImpl>)original -> StateMerger.withUnknownVariables(original, toFlush));
    }

    private boolean areEquivalentModuloVar(@NotNull DfaMemoryStateImpl state1, @NotNull DfaMemoryStateImpl state2, @NotNull DfaVariableValue var) {
        DfaMemoryStateImpl copy1 = this.copyWithoutVar(state1, var);
        DfaMemoryStateImpl copy2 = this.copyWithoutVar(state2, var);
        return copy2.equalsByRelations(copy1) && copy2.equalsByVariableStates(copy1);
    }

    @NotNull
    private DfaMemoryStateImpl copyWithoutVar(@NotNull DfaMemoryStateImpl state, @NotNull DfaVariableValue var) {
        DfaMemoryStateImpl copy;
        IdentityHashMap map2 = this.myCopyCache.get(state);
        if (map2 == null) {
            map2 = ContainerUtil.newIdentityHashMap();
            this.myCopyCache.put(state, map2);
        }
        if ((copy = map2.get(var)) == null) {
            copy = state.createCopy();
            copy.flushVariable(var);
            map2.put(var, copy);
        }
        return copy;
    }

    private static boolean areVarStatesEqualModuloNullability(@NotNull DfaMemoryStateImpl state1, @NotNull DfaMemoryStateImpl state2, @NotNull DfaVariableValue var) {
        return state1.getVariableState(var).withNullability(Nullness.UNKNOWN).equals(state2.getVariableState(var).withNullability(Nullness.UNKNOWN));
    }

    @NotNull
    private Set<Fact> getFacts(@NotNull DfaMemoryStateImpl state) {
        LinkedHashSet result2 = this.myFacts.get(state);
        if (result2 != null) {
            return result2;
        }
        result2 = ContainerUtil.newLinkedHashSet();
        for (EqClass eqClass : state.getNonTrivialEqClasses()) {
            DfaValue constant = eqClass.findConstant(true);
            List<DfaVariableValue> vars = eqClass.getVariables(false);
            for (DfaVariableValue var : vars) {
                if (constant != null) {
                    result2.add(Fact.createEqualityFact(var, constant, true));
                }
                for (DfaVariableValue eqVar : vars) {
                    if (var == eqVar) continue;
                    result2.add(Fact.createEqualityFact(var, eqVar, true));
                }
            }
        }
        for (UnorderedPair unorderedPair : state.getDistinctClassPairs()) {
            List<DfaVariableValue> vars1 = ((EqClass)unorderedPair.first).getVariables(false);
            List<DfaVariableValue> vars2 = ((EqClass)unorderedPair.second).getVariables(false);
            LinkedHashSet<DfaVariableValue> firstSet = new LinkedHashSet<DfaVariableValue>(vars1);
            ContainerUtil.addIfNotNull(firstSet, (Object)((EqClass)unorderedPair.first).findConstant(true));
            LinkedHashSet<DfaVariableValue> secondSet = new LinkedHashSet<DfaVariableValue>(vars2);
            ContainerUtil.addIfNotNull(secondSet, (Object)((EqClass)unorderedPair.second).findConstant(true));
            for (DfaVariableValue var : vars1) {
                for (DfaValue dfaValue : secondSet) {
                    result2.add(new Fact(FactType.equality, var, false, dfaValue));
                }
            }
            for (DfaVariableValue var : vars2) {
                for (DfaValue dfaValue : firstSet) {
                    result2.add(new Fact(FactType.equality, var, false, dfaValue));
                }
            }
        }
        Map<DfaVariableValue, DfaVariableState> states = state.getVariableStates();
        for (DfaVariableValue var : states.keySet()) {
            DfaVariableState variableState = states.get(var);
            for (DfaPsiType type2 : variableState.getInstanceofValues()) {
                result2.add(new Fact(FactType.instanceOf, var, true, type2));
            }
            for (DfaPsiType type2 : variableState.getNotInstanceofValues()) {
                result2.add(new Fact(FactType.instanceOf, var, false, type2));
            }
        }
        this.myFacts.put(state, result2);
        return result2;
    }

    private static class Replacements {
        @NotNull
        private final List<DfaMemoryStateImpl> myAllStates;
        private final Set<DfaMemoryStateImpl> myRemovedStates = ContainerUtil.newIdentityTroveSet();
        private final List<DfaMemoryStateImpl> myMerged = ContainerUtil.newArrayList();

        private Replacements(@NotNull List<DfaMemoryStateImpl> allStates) {
            this.myAllStates = allStates;
        }

        private boolean hasMerges() {
            return !this.myMerged.isEmpty();
        }

        @Nullable
        private List<DfaMemoryStateImpl> getMergeResult() {
            if (this.hasMerges()) {
                ArrayList result2 = ContainerUtil.newArrayList(this.myMerged);
                for (DfaMemoryStateImpl state : this.myAllStates) {
                    if (this.myRemovedStates.contains(state)) continue;
                    result2.add(state);
                }
                return result2;
            }
            return null;
        }

        private boolean stripAndMerge(@NotNull Collection<DfaMemoryStateImpl> group, @NotNull Function<DfaMemoryStateImpl, DfaMemoryStateImpl> stripper) {
            if (group.size() <= 1) {
                return false;
            }
            MultiMap strippedToOriginals = MultiMap.create();
            for (DfaMemoryStateImpl original : group) {
                strippedToOriginals.putValue(stripper.fun((Object)original), (Object)original);
            }
            boolean hasMerges = false;
            for (Map.Entry entry : strippedToOriginals.entrySet()) {
                Collection merged = (Collection)entry.getValue();
                if (merged.size() <= 1) continue;
                this.myRemovedStates.addAll(merged);
                this.myMerged.add((DfaMemoryStateImpl)entry.getKey());
                hasMerges = true;
            }
            return hasMerges;
        }
    }

    private static class Fact {
        @NotNull
        final FactType myType;
        @NotNull
        private final DfaVariableValue myVar;
        private final boolean myPositive;
        @NotNull
        private final Object myArg;

        private Fact(@NotNull FactType type2, @NotNull DfaVariableValue var, boolean positive, @NotNull Object arg) {
            this.myType = type2;
            this.myVar = var;
            this.myPositive = positive;
            this.myArg = arg;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Fact)) {
                return false;
            }
            Fact fact = (Fact)o;
            if (this.myPositive != fact.myPositive) {
                return false;
            }
            if (!this.myArg.equals(fact.myArg)) {
                return false;
            }
            if (this.myType != fact.myType) {
                return false;
            }
            return this.myVar.equals(fact.myVar);
        }

        public int hashCode() {
            int result2 = this.myType.hashCode();
            result2 = 31 * result2 + this.myVar.hashCode();
            result2 = 31 * result2 + (this.myPositive ? 1 : 0);
            result2 = 31 * result2 + this.myArg.hashCode();
            return result2;
        }

        public String toString() {
            return this.myVar + " " + (this.myPositive ? "" : "!") + (Object)((Object)this.myType) + " " + this.myArg;
        }

        @NotNull
        private static Fact createEqualityFact(@NotNull DfaVariableValue var, @NotNull DfaValue val, boolean equal) {
            if (val instanceof DfaVariableValue && val.getID() < var.getID()) {
                return new Fact(FactType.equality, (DfaVariableValue)val, equal, var);
            }
            return new Fact(FactType.equality, var, equal, val);
        }

        @NotNull
        private Fact getPositiveCounterpart() {
            return new Fact(this.myType, this.myVar, true, this.myArg);
        }

        boolean invalidatesFact(@NotNull Fact another) {
            if (another.myType != this.myType) {
                return false;
            }
            if (this.myType == FactType.equality) {
                return Fact.aboutSame(this.myVar, another.myVar) || Fact.aboutSame(this.myVar, another.myArg);
            }
            return Fact.aboutSame(this.myVar, another.myVar) && Fact.aboutSame(this.myArg, another.myArg);
        }

        private static boolean aboutSame(Object v1, Object v2) {
            return Fact.normalize(v1) == Fact.normalize(v2);
        }

        private static Object normalize(Object value2) {
            if (value2 instanceof DfaVariableValue && ((DfaVariableValue)value2).isNegated()) {
                return ((DfaVariableValue)value2).createNegated();
            }
            return value2;
        }

        void removeFromState(@NotNull DfaMemoryStateImpl state) {
            DfaVariableState varState = state.getVariableState(this.myVar);
            if (this.myType == FactType.equality) {
                state.flushVariable(this.myVar);
                state.setVariableState(this.myVar, varState);
            } else {
                state.setVariableState(this.myVar, varState.withoutType((DfaPsiType)this.myArg));
            }
        }
    }

    private static enum FactType {
        equality,
        instanceOf;

    }
}

