/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringExpressionHelper {
    @Nullable
    public static Pair<PsiElement, String> evaluateExpression(@NotNull PsiElement expression2) {
        return StringExpressionHelper.evaluateExpression(expression2, (Collection<PsiElement>)new com.intellij.util.containers.hash.HashSet());
    }

    @Nullable
    public static Pair<PsiElement, String> evaluateExpression(@NotNull PsiElement expression2, @NotNull Collection<PsiElement> visited) {
        Pair<PsiElement, String> expr;
        PsiExpression initializer;
        PsiElement resolve2;
        if (!visited.add(expression2)) {
            return null;
        }
        if (expression2 instanceof PsiLiteralExpression) {
            return StringExpressionHelper.evaluatePsiLiteralExpression(expression2);
        }
        if (expression2 instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)expression2).resolve()) instanceof PsiVariable && (initializer = ((PsiVariable)resolve2).getInitializer()) != null && (expr = StringExpressionHelper.evaluateExpression((PsiElement)initializer, visited)) != null) {
            return expr;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiElement element = ((PsiMethodCallExpression)expression2).getMethodExpression().resolve();
            if (element instanceof PsiMethod) {
                PsiCodeBlock body2 = ((PsiMethod)element).getBody();
                if (body2 != null) {
                    HashSet returns = new HashSet();
                    body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Set)returns){
                        final /* synthetic */ Set val$returns;
                        {
                            this.val$returns = set2;
                        }

                        public void visitClass(PsiClass aClass) {
                        }

                        public void visitLambdaExpression(PsiLambdaExpression expression2) {
                        }

                        public void visitReturnStatement(PsiReturnStatement statement2) {
                            PsiExpression returnValue = statement2.getReturnValue();
                            if (returnValue != null) {
                                this.val$returns.add(returnValue);
                            }
                        }
                    });
                    for (PsiExpression psiExpression : returns) {
                        Pair<PsiElement, String> pair = StringExpressionHelper.evaluateExpression((PsiElement)psiExpression, visited);
                        if (pair == null) continue;
                        return pair;
                    }
                }
                return StringExpressionHelper.evaluateExpression(element, visited);
            }
            return null;
        }
        Pair<PsiElement, String> constantExpression = StringExpressionHelper.evaluateConstantExpression(expression2);
        if (constantExpression != null) {
            return constantExpression;
        }
        if (expression2 instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            return StringExpressionHelper.evaluatePolyadicExpressions(expression2, visited, binaryExpression.getLOperand(), binaryExpression.getROperand());
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            return StringExpressionHelper.evaluatePolyadicExpressions(expression2, visited, ((PsiPolyadicExpression)expression2).getOperands());
        }
        Collection<? extends PsiElement> elements = DfaUtil.getPossibleInitializationElements(expression2);
        for (PsiElement psiElement : elements) {
            Pair<PsiElement, String> expr2 = StringExpressionHelper.evaluateExpression(psiElement, visited);
            if (expr2 == null) continue;
            return expr2;
        }
        return null;
    }

    @Nullable
    private static Pair<PsiElement, String> evaluatePolyadicExpressions(@NotNull PsiElement expression2, @NotNull Collection<PsiElement> visited, PsiExpression ... operands2) {
        StringBuilder sb = new StringBuilder();
        for (PsiExpression operand2 : operands2) {
            Pair<PsiElement, String> pair = StringExpressionHelper.evaluateExpression((PsiElement)operand2, visited);
            if (pair == null) {
                return null;
            }
            sb.append((String)pair.second);
        }
        return Pair.create((Object)expression2, (Object)sb.toString());
    }

    @Nullable
    private static Pair<PsiElement, String> evaluatePsiLiteralExpression(@NotNull PsiElement expression2) {
        return Pair.create((Object)expression2, (Object)ElementManipulators.getValueText((PsiElement)expression2));
    }

    @Nullable
    public static Pair<PsiElement, String> evaluateConstantExpression(@NotNull PsiElement expression2) {
        PsiConstantEvaluationHelper helper = JavaPsiFacade.getInstance((Project)expression2.getProject()).getConstantEvaluationHelper();
        Object result2 = helper.computeConstantExpression(expression2);
        if (result2 instanceof String) {
            return Pair.create((Object)expression2, (Object)((String)result2));
        }
        return null;
    }

    @NotNull
    public static Set<Pair<PsiElement, String>> searchStringExpressions(@NotNull PsiMethod psiMethod, @NotNull SearchScope searchScope, int expNum) {
        HashSet pairs = new HashSet();
        for (PsiMethodCallExpression methodCallExpression : StringExpressionHelper.searchMethodCalls(psiMethod, searchScope)) {
            PsiExpression expression2;
            Pair<PsiElement, String> pair;
            PsiExpression[] expressions2 = methodCallExpression.getArgumentList().getExpressions();
            if (expressions2.length <= expNum || (pair = StringExpressionHelper.evaluateExpression((PsiElement)(expression2 = expressions2[expNum]))) == null) continue;
            pairs.add(pair);
        }
        return pairs;
    }

    @NotNull
    public static Set<PsiMethodCallExpression> searchMethodCalls(@NotNull PsiMethod psiMethod, @NotNull SearchScope searchScope) {
        HashSet callExpressions = new HashSet();
        CommonProcessors.CollectUniquesProcessor consumer2 = new CommonProcessors.CollectUniquesProcessor();
        MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)searchScope, (boolean)true).forEach((Processor)consumer2);
        for (PsiReference psiReference : consumer2.getResults()) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class);
            if (methodCallExpression == null) continue;
            callExpressions.add(methodCallExpression);
        }
        return callExpressions;
    }
}

