/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.annotations.Nullable;

public abstract class BranchingInstruction
extends Instruction {
    private boolean myIsTrueReachable = false;
    private boolean myIsFalseReachable = false;
    private final boolean isConstTrue;
    private final PsiElement myExpression;

    protected BranchingInstruction(@Nullable PsiElement psiAnchor) {
        this.myExpression = psiAnchor;
        this.isConstTrue = psiAnchor != null && BranchingInstruction.isBoolConst(psiAnchor);
    }

    public boolean isTrueReachable() {
        return this.myIsTrueReachable;
    }

    public boolean isFalseReachable() {
        return this.myIsFalseReachable;
    }

    public PsiElement getPsiAnchor() {
        return this.myExpression;
    }

    public void setTrueReachable() {
        this.myIsTrueReachable = true;
    }

    public void setFalseReachable() {
        this.myIsFalseReachable = true;
    }

    public boolean isConditionConst() {
        return !this.isConstTrue && this.myIsTrueReachable != this.myIsFalseReachable;
    }

    public static boolean isBoolConst(PsiElement condition2) {
        if (!(condition2 instanceof PsiLiteralExpression)) {
            return false;
        }
        String text = condition2.getText();
        return "true".equals(text) || "false".equals(text);
    }
}

