/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.value.DfaPsiType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DfaTypeValue
extends DfaValue {
    @NotNull
    private final DfaPsiType myType;
    @NotNull
    private final Nullness myNullness;

    private DfaTypeValue(@NotNull DfaPsiType type2, @NotNull Nullness nullness, @NotNull DfaValueFactory factory) {
        super(factory);
        this.myType = type2;
        this.myNullness = nullness;
    }

    @NotNull
    public DfaPsiType getDfaType() {
        return this.myType;
    }

    public boolean isNullable() {
        return this.myNullness == Nullness.NULLABLE;
    }

    public boolean isNotNull() {
        return this.myNullness == Nullness.NOT_NULL;
    }

    @NotNull
    public Nullness getNullness() {
        return this.myNullness;
    }

    @NonNls
    public String toString() {
        return this.myType + ", nullable=" + (Object)((Object)this.myNullness);
    }

    public static class Factory {
        private final Map<DfaPsiType, ArrayList<DfaTypeValue>> myCache = ContainerUtil.newHashMap();
        @NotNull
        private final DfaValueFactory myFactory;

        Factory(@NotNull DfaValueFactory factory) {
            this.myFactory = factory;
        }

        @NotNull
        DfaTypeValue createTypeValue(@NotNull DfaPsiType type2, @NotNull Nullness nullness) {
            ArrayList<DfaTypeValue> conditions = this.myCache.get(type2);
            if (conditions == null) {
                conditions = new ArrayList();
                this.myCache.put(type2, conditions);
            } else {
                for (DfaTypeValue aType : conditions) {
                    if (aType.myNullness != nullness) continue;
                    return aType;
                }
            }
            DfaTypeValue result2 = new DfaTypeValue(type2, nullness, this.myFactory);
            conditions.add(result2);
            return result2;
        }
    }
}

