/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.deadCode.DeadHTMLComposer;
import com.intellij.codeInspection.deadCode.RefEntryPointFilter;
import com.intellij.codeInspection.deadCode.UnusedDeclarationPresentation;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.util.RefFilter;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DummyEntryPointsPresentation
extends UnusedDeclarationPresentation {
    private static final RefEntryPointFilter myFilter = new RefEntryPointFilter();
    private QuickFixAction[] myQuickFixActions;

    public DummyEntryPointsPresentation(@NotNull InspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextImpl context) {
        super(toolWrapper, context);
    }

    @Override
    public RefFilter getFilter() {
        return myFilter;
    }

    @Override
    public QuickFixAction[] getQuickFixes(@NotNull RefEntity[] refElements, @Nullable InspectionTree tree) {
        if (this.myQuickFixActions == null) {
            this.myQuickFixActions = new QuickFixAction[]{new MoveEntriesToSuspicious(this.getToolWrapper())};
        }
        return this.myQuickFixActions;
    }

    @Override
    protected String getSeverityDelegateName() {
        return "unused";
    }

    @Override
    public void createToolNode(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionNode node, @NotNull InspectionRVContentProvider provider2, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupByStructure) {
        this.myToolNode = node;
    }

    @Override
    protected boolean skipEntryPoints(RefJavaElement refElement) {
        return false;
    }

    @Override
    @NotNull
    public DeadHTMLComposer getComposer() {
        return new DeadHTMLComposer(this);
    }

    @Override
    public boolean isDummy() {
        return true;
    }

    private class MoveEntriesToSuspicious
    extends QuickFixAction {
        private MoveEntriesToSuspicious(InspectionToolWrapper toolWrapper) {
            super(InspectionsBundle.message((String)"inspection.dead.code.remove.user.defined.entry.point.quickfix", (Object[])new Object[0]), null, null, toolWrapper);
        }

        @Override
        public void update(AnActionEvent e) {
            super.update(e);
            if (e.getPresentation().isEnabled()) {
                InspectionResultsView view = MoveEntriesToSuspicious.getInvoker(e);
                boolean permanentFound = false;
                for (RefEntity point : view.getTree().getSelectedElements()) {
                    if (!(point instanceof RefJavaElement) || !((RefJavaElement)point).isEntry() || !((RefJavaElement)point).isPermanentEntry()) continue;
                    permanentFound = true;
                    break;
                }
                if (!permanentFound) {
                    e.getPresentation().setEnabled(false);
                }
            }
        }

        @Override
        protected boolean applyFix(@NotNull RefEntity[] refElements) {
            EntryPointsManager entryPointsManager = ((GlobalJavaInspectionContext)DummyEntryPointsPresentation.this.getContext().getExtension(GlobalJavaInspectionContext.CONTEXT)).getEntryPointsManager(DummyEntryPointsPresentation.this.getContext().getRefManager());
            for (RefEntity refElement : refElements) {
                if (!(refElement instanceof RefJavaElement) || !((RefJavaElement)refElement).isEntry() || !((RefJavaElement)refElement).isPermanentEntry()) continue;
                entryPointsManager.removeEntryPoint((RefElement)refElement);
            }
            return true;
        }
    }
}

