/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dependencyViolation;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.dependencyViolation.DependencyInspectionBase;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.ui.DependencyConfigurable;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DependencyInspection
extends DependencyInspectionBase {
    @Override
    protected LocalQuickFix[] createEditDependencyFixes(DependencyRule dependencyRule) {
        return new LocalQuickFix[]{new EditDependencyRulesAction(dependencyRule)};
    }

    public JComponent createOptionsPanel() {
        final JButton editDependencies = new JButton(InspectionsBundle.message((String)"inspection.dependency.configure.button.text", (Object[])new Object[0]));
        editDependencies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editDependencies));
                if (project2 == null) {
                    project2 = ProjectManager.getInstance().getDefaultProject();
                }
                ShowSettingsUtil.getInstance().editConfigurable((Component)editDependencies, (Configurable)new DependencyConfigurable(project2));
            }
        });
        JPanel depPanel = new JPanel(new FlowLayout(0));
        depPanel.add(editDependencies);
        return depPanel;
    }

    private static class EditDependencyRulesAction
    implements LocalQuickFix {
        private final DependencyRule myRule;

        public EditDependencyRulesAction(DependencyRule rule) {
            this.myRule = rule;
        }

        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"edit.dependency.rules.text", (Object[])new Object[]{this.myRule.getDisplayText()});
        }

        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"edit.dependency.rules.family", (Object[])new Object[0]);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)new DependencyConfigurable(project2));
        }
    }
}

