/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dependencyViolation;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.ERROR;
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.DEPENDENCY_GROUP_NAME;
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"illegal.package.dependencies", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "Dependency";
    }

    @Nullable
    public ProblemDescriptor[] checkFile(final @NotNull PsiFile file2, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        if (file2.getViewProvider().getPsi((Language)JavaLanguage.INSTANCE) == null) {
            return null;
        }
        final DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)file2.getProject());
        if (!validationManager.hasRules() || validationManager.getApplicableRules(file2).length == 0) {
            return null;
        }
        final List problems = ContainerUtil.newSmartList();
        DependenciesBuilder.analyzeFileDependencies(file2, new DependenciesBuilder.DependencyProcessor(){
            private final Map<PsiFile, DependencyRule[]> violations = new FactoryMap<PsiFile, DependencyRule[]>(){

                @Nullable
                protected DependencyRule[] create(PsiFile dependencyFile) {
                    return validationManager.getViolatorDependencyRules(file2, dependencyFile);
                }
            };

            @Override
            public void process(PsiElement place, PsiElement dependency) {
                PsiFile dependencyFile = dependency.getContainingFile();
                if (dependencyFile != null && dependencyFile.isPhysical() && dependencyFile.getVirtualFile() != null) {
                    for (DependencyRule dependencyRule : this.violations.get(dependencyFile)) {
                        String message2 = InspectionsBundle.message((String)"inspection.dependency.violator.problem.descriptor", (Object[])new Object[]{dependencyRule.getDisplayText()});
                        LocalQuickFix[] fixes = DependencyInspectionBase.this.createEditDependencyFixes(dependencyRule);
                        problems.add(manager.createProblemDescriptor(place, message2, isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                    }
                }
            }
        });
        return problems.isEmpty() ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    protected LocalQuickFix[] createEditDependencyFixes(DependencyRule dependencyRule) {
        return null;
    }
}

