/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateThrows;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.DeleteThrowsFix;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateThrowsInspection
extends BaseJavaBatchLocalInspectionTool
implements CleanupLocalInspectionTool {
    public boolean ignoreSubclassing;

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"inspection.duplicate.throws.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.DECLARATION_REDUNDANCY;
    }

    @NotNull
    public String getShortName() {
        return "DuplicateThrows";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionsBundle.message((String)"inspection.duplicate.throws.ignore.subclassing.option", (Object[])new Object[0]), (InspectionProfileEntry)this, "ignoreSubclassing");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method2) {
                PsiReferenceList throwsList = method2.getThrowsList();
                PsiJavaCodeReferenceElement[] refs = throwsList.getReferenceElements();
                PsiClassType[] types = throwsList.getReferencedTypes();
                for (int i = 0; i < types.length; ++i) {
                    for (int j = i + 1; j < types.length; ++j) {
                        PsiClassType type2 = types[i];
                        PsiClassType otherType = types[j];
                        String problem = null;
                        PsiJavaCodeReferenceElement ref = refs[i];
                        if (type2.equals((Object)otherType)) {
                            problem = InspectionsBundle.message((String)"inspection.duplicate.throws.problem", (Object[])new Object[0]);
                        } else if (!DuplicateThrowsInspection.this.ignoreSubclassing) {
                            if (otherType.isAssignableFrom((PsiType)type2)) {
                                problem = InspectionsBundle.message((String)"inspection.duplicate.throws.more.general.problem", (Object[])new Object[]{otherType.getCanonicalText()});
                            } else if (type2.isAssignableFrom((PsiType)otherType)) {
                                problem = InspectionsBundle.message((String)"inspection.duplicate.throws.more.general.problem", (Object[])new Object[]{type2.getCanonicalText()});
                                ref = refs[j];
                                type2 = otherType;
                            }
                        }
                        if (problem == null) continue;
                        holder.registerProblem((PsiElement)ref, problem, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new DeleteThrowsFix(method2, type2)});
                    }
                }
            }
        };
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

