/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import gnu.trove.THashSet;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class InspectionProfileWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionProfileWrapper");
    public static final Key<Function<InspectionProfileImpl, InspectionProfileWrapper>> CUSTOMIZATION_KEY = Key.create((String)"Inspection Profile Wrapper Customization");
    private static boolean alreadyChecked;
    protected final InspectionProfileImpl myProfile;

    public InspectionProfileWrapper(@NotNull InspectionProfileImpl profile2) {
        this.myProfile = profile2;
    }

    public static void checkInspectionsDuplicates(@NotNull InspectionToolWrapper[] toolWrappers) {
        if (alreadyChecked) {
            return;
        }
        alreadyChecked = true;
        THashSet uniqueTools = new THashSet(toolWrappers.length);
        for (InspectionToolWrapper toolWrapper : toolWrappers) {
            ProgressManager.checkCanceled();
            if (uniqueTools.add(toolWrapper.getTool())) continue;
            LOG.error("Inspection " + toolWrapper.getDisplayName() + " (" + toolWrapper.getTool().getClass() + ") already registered");
        }
    }

    public boolean isToolEnabled(HighlightDisplayKey key2, PsiElement element) {
        return this.myProfile.isToolEnabled(key2, element);
    }

    public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey inspectionToolKey, PsiElement element) {
        return this.myProfile.getErrorLevel(inspectionToolKey, element);
    }

    public InspectionToolWrapper getInspectionTool(String shortName, PsiElement element) {
        return this.myProfile.getInspectionTool(shortName, element);
    }

    @NotNull
    public InspectionProfileImpl getInspectionProfile() {
        return this.myProfile;
    }
}

