/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.TripleFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalDescriptorsUtil {
    private static final TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement> CONVERT = (tool, element, context) -> {
        PsiNamedElement problemElement = tool.getProblemElement(element);
        RefElement refElement = context.getRefManager().getReference((PsiElement)problemElement);
        if (refElement == null && problemElement != null) {
            refElement = GlobalInspectionContextUtil.retrieveRefElement(element, context);
        }
        return refElement;
    };

    static void addProblemDescriptors(@NotNull List<ProblemDescriptor> descriptors, boolean filterSuppressed, @NotNull GlobalInspectionContext context, @Nullable LocalInspectionTool tool, @NotNull TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement> getProblemElementFunction, @NotNull InspectionToolPresentation dpi) {
        RefElement refElement;
        if (descriptors.isEmpty()) {
            return;
        }
        HashMap<RefElement, ArrayList<ProblemDescriptor>> problems = new HashMap<RefElement, ArrayList<ProblemDescriptor>>();
        RefManagerImpl refManager = (RefManagerImpl)context.getRefManager();
        for (ProblemDescriptor problemDescriptor : descriptors) {
            String alternativeId;
            String id;
            PsiElement element = problemDescriptor.getPsiElement();
            if (element == null || filterSuppressed && (refManager.isDeclarationsFound() && (context.isSuppressed(element, id = tool.getID()) || (alternativeId = tool.getAlternativeID()) != null && !alternativeId.equals(id) && context.isSuppressed(element, alternativeId)) || SuppressionUtil.inspectionResultSuppressed(element, tool))) continue;
            refElement = (RefElement)getProblemElementFunction.fun((Object)tool, (Object)element, (Object)context);
            ArrayList<ProblemDescriptor> elementProblems = (ArrayList<ProblemDescriptor>)problems.get(refElement);
            if (elementProblems == null) {
                elementProblems = new ArrayList<ProblemDescriptor>();
                problems.put(refElement, elementProblems);
            }
            elementProblems.add(problemDescriptor);
        }
        for (Map.Entry entry : problems.entrySet()) {
            List problemDescriptors = (List)entry.getValue();
            refElement = (RefElement)entry.getKey();
            CommonProblemDescriptor[] descriptions = problemDescriptors.toArray(new CommonProblemDescriptor[problemDescriptors.size()]);
            dpi.addProblemElement((RefEntity)refElement, filterSuppressed, descriptions);
        }
    }

    public static void addProblemDescriptors(@NotNull List<ProblemDescriptor> descriptors, @NotNull InspectionToolPresentation dpi, boolean filterSuppressed, @NotNull GlobalInspectionContext inspectionContext, @NotNull LocalInspectionTool tool) {
        LocalDescriptorsUtil.addProblemDescriptors(descriptors, filterSuppressed, inspectionContext, tool, CONVERT, dpi);
    }
}

