/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalInspectionToolWrapper
extends InspectionToolWrapper<LocalInspectionTool, LocalInspectionEP> {
    private static final NotNullLazyValue<Map<String, LocalInspectionEP>> ourEPMap = new NotNullLazyValue<Map<String, LocalInspectionEP>>(){

        @NotNull
        protected Map<String, LocalInspectionEP> compute() {
            THashMap map2 = new THashMap();
            for (LocalInspectionEP ep : (LocalInspectionEP[])LocalInspectionEP.LOCAL_INSPECTION.getExtensions()) {
                map2.put(ep.getShortName(), ep);
            }
            return map2;
        }
    };

    public LocalInspectionToolWrapper(@NotNull LocalInspectionTool tool) {
        super((InspectionProfileEntry)tool, (InspectionEP)((Map)ourEPMap.getValue()).get(tool.getShortName()));
    }

    public LocalInspectionToolWrapper(@NotNull LocalInspectionEP ep) {
        super((InspectionEP)ep);
    }

    private LocalInspectionToolWrapper(@NotNull LocalInspectionToolWrapper other) {
        super((InspectionToolWrapper)other);
    }

    @NotNull
    public LocalInspectionToolWrapper createCopy() {
        return new LocalInspectionToolWrapper(this);
    }

    @NotNull
    public JobDescriptor[] getJobDescriptors(@NotNull GlobalInspectionContext context) {
        return context.getStdJobDescriptors().LOCAL_ANALYSIS_ARRAY;
    }

    public boolean isUnfair() {
        return this.myEP == null ? this.getTool() instanceof UnfairLocalInspectionTool : ((LocalInspectionEP)this.myEP).unfair;
    }

    public String getID() {
        return this.myEP == null ? ((LocalInspectionTool)this.getTool()).getID() : (((LocalInspectionEP)this.myEP).id == null ? ((LocalInspectionEP)this.myEP).getShortName() : ((LocalInspectionEP)this.myEP).id);
    }

    @Nullable
    public String getAlternativeID() {
        return this.myEP == null ? ((LocalInspectionTool)this.getTool()).getAlternativeID() : ((LocalInspectionEP)this.myEP).alternativeId;
    }

    public boolean runForWholeFile() {
        return this.myEP == null ? ((LocalInspectionTool)this.getTool()).runForWholeFile() : ((LocalInspectionEP)this.myEP).runForWholeFile;
    }

    @Nullable
    public static InspectionToolWrapper findTool2RunInBatch(@NotNull Project project2, @Nullable PsiElement element, @NotNull String name) {
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance(project2).getCurrentProfile();
        InspectionToolWrapper toolWrapper = element == null ? inspectionProfile.getInspectionTool(name, project2) : inspectionProfile.getInspectionTool(name, element);
        return LocalInspectionToolWrapper.findTool2RunInBatch(project2, element, inspectionProfile, toolWrapper);
    }

    @Nullable
    public static InspectionToolWrapper findTool2RunInBatch(@NotNull Project project2, @Nullable PsiElement element, @NotNull InspectionProfile inspectionProfile, @Nullable InspectionToolWrapper toolWrapper) {
        if (toolWrapper instanceof LocalInspectionToolWrapper && ((LocalInspectionToolWrapper)toolWrapper).isUnfair()) {
            LocalInspectionTool inspectionTool = (LocalInspectionTool)((LocalInspectionToolWrapper)toolWrapper).getTool();
            if (inspectionTool instanceof PairedUnfairLocalInspectionTool) {
                String oppositeShortName = ((PairedUnfairLocalInspectionTool)inspectionTool).getInspectionForBatchShortName();
                return element == null ? inspectionProfile.getInspectionTool(oppositeShortName, project2) : inspectionProfile.getInspectionTool(oppositeShortName, element);
            }
            return null;
        }
        return toolWrapper;
    }
}

